<?php
/**
 *  Dashboard Widget Template
 *
 *  Dashboard Big Counter widget template
 *
 * @since   2.4
 *
 * @author  weDevs <info@wedevs.com>
 *
 * @package dokan
 */
?>
<div class="dashboard-widget big-counter digix-dashboard-counter">
    <ul class="list-inline">
        <li class="sales">
            <i class="icon-insurance"></i>
            <div class="detailes">
                <div class="title"><?php esc_html_e( 'Sales', 'dokan-lite' ); ?></div>
                <div class="count"><?php echo wp_kses_post( wc_price( $earning ) ); ?></div>
            </div>
        </li>
        <li class="earning">
            <i class="icon-exchange"></i>
            <div class="detailes">
                <div class="title"><?php esc_html_e( 'Earning', 'dokan-lite' ); ?></div>
                <div class="count"><?php echo wp_kses_post( dokan_get_seller_earnings( dokan_get_current_user_id() ) ); ?></div>
            </div>
        </li>
        <li class="pageview">
            <i class="icon-tinder"></i>
            <div class="detailes">
                <div class="title"><?php esc_html_e( 'Pageview', 'dokan-lite' ); ?></div>
                <div class="count"><?php echo esc_html( dokan_number_format( $pageviews ) ); ?></div>
            </div>
        </li>
        <li class="order">
            <i class="icon-order"></i>
            <div class="detailes">
                <div class="title"><?php esc_html_e( 'Order', 'dokan-lite' ); ?></div>
                <div class="count">
                    <?php
                    $order_statuses = dokan_withdraw_get_active_order_status();
                    $total          = 0;

                    foreach ( $order_statuses as $order_status ) :
                        if ( isset( $orders_count->$order_status ) ) :
                            $total += $orders_count->$order_status;
                        endif;
                    endforeach;

                    echo esc_html( number_format_i18n( $total, 0 ) );
                    ?>
                </div>
            </div>
        </li>

        <?php do_action( 'dokan_seller_dashboard_widget_counter' ); ?>
    </ul>
</div> <!-- .big-counter -->
