<?php
/**
 *  Dokan Dashboard Template
 *
 *  Dokan Main Dashboard template for Fron-end
 *
 * @since   2.4
 *
 * @package dokan
 */
$dashboard =new WeDevs\Dokan\Dashboard\Templates\dashboard();
if(class_exists('Dokan_Pro')): 
	//$dashpro = new WeDevs\DokanPro\dashboard();
endif;

$user_id = get_current_user_id();
$vendor                   = dokan()->vendor->get( $user_id );
$store_name               = $vendor->get_shop_name();
?>
<?php do_action( 'dokan_dashboard_wrap_start' ); ?>

<div class="dokan-dashboard-wrap">
    <?php

    /**
     *  Added dokan_dashboard_content_before hook
     *
     * @hooked get_dashboard_side_navigation
     *
     * @since  2.4
     */
    do_action( 'dokan_dashboard_content_before' ); // sidebar
    ?>
    <section class="digix-dashboard-header">
        <div class="right">
            <?php printf(
                __('<p>Dear <b>%s</b> WellCome to Your Dashboard.</p>','digix'),esc_html( $store_name )
            ); ?>
        </div>
        <div class="left">
            <ul>
                <li class="store">
                    <a href="<?php echo dokan_get_store_url( dokan_get_current_user_id() ); ?>"><i class="icon-expand"></i></a>
                </li>
                <li class="user">
                    <a href="<?php echo dokan_get_navigation_url( 'edit-account' ); ?>"><i class="icon-user"></i></a>
                </li>
                <li class="shop">
                    <a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>"><i class="icon-shopping-basket"></i></a>
                </li>
                <li class="home">
                    <a href="<?php echo esc_url( home_url() ); ?>"><i class="icon-house"></i></a>
                </li>
                <li class="offline">
                    <a href="<?php echo wc_get_account_endpoint_url( 'customer-logout' ); ?>"><i class="icon-offline"></i></a>
                </li>
            </ul>
        </div>
    </section>
    <div class="dokan-dashboard-content digix-dashboard-content">

        <?php

        /**
         *  Added dokan_dashboard_content_before hook
         *
         * @hooked show_seller_dashboard_notice
         *
         * @since  2.4
         */
        do_action( 'dokan_dashboard_content_inside_before' );
        ?>
        <?php  echo $dashboard -> get_big_counter_widgets(); ?>
        <?php if(class_exists('Dokan_Pro')): ?>
            <div class="seller-progressbar">
                <?php do_action( 'dokan_dashboard_before_widgets' ); ?>
            </div>
        <?php endif; ?>
        <div class="seller-orders">
            <?php  echo $dashboard -> get_orders_widgets(); ?>
            <?php  echo $dashboard -> get_sales_report_chart_widget(); ?>
        </div>
        <?php if(class_exists('Dokan_Pro')): ?>
            <div class="seller-dcontact">
                <?php  do_action( 'dokan_dashboard_right_widgets' ); ?>
                <?php  //echo $dashpro -> get_announcement_widget(); ?>
            </div>
        <?php endif; ?>

        <?php

        /**
         *  Added dokan_dashboard_content_inside_after hook
         *
         * @since 2.4
         */
        do_action( 'dokan_dashboard_content_inside_after' );
        ?>


    </div><!-- .dokan-dashboard-content -->

    <?php

    /**
     *  Added dokan_dashboard_content_after hook
     *
     * @since 2.4
     */
    do_action( 'dokan_dashboard_content_after' );
    ?>

</div><!-- .dokan-dashboard-wrap -->

<?php do_action( 'dokan_dashboard_wrap_end' ); ?>
