<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/dokan/store-lists-filter.php
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package Dokan/Templates
 * @version 2.9.30
 */

defined( 'ABSPATH' ) || exit; ?>


<?php do_action( 'dokan_before_store_lists_filter_right', $stores ); ?>
    <div class="right">
		<?php
		foreach ( $sort_filters as $key => $filter ) {
			$optoins = "<a class='filter-uri' href='?stores_orderby=${key}'>${filter}</a>";
			printf( $optoins );
		}
		?>
    </div>
    <?php do_action( 'dokan_before_store_lists_filter_left', $stores ); ?>
    <div class="left">
		<?php do_action( 'dokan_before_store_lists_filter_form', $stores ); ?>
		<form role="store-list-filter" method="get" name="dokan_store_lists_filter_form">
			<?php
			do_action( 'dokan_before_store_lists_filter_search', $stores );
			if ( apply_filters( 'dokan_load_store_lists_filter_search_bar', true ) ) :
				?>
				<div class="store-search grid-item">
					<input type="search" class="store-search-input" name="dokan_seller_search" placeholder="<?php esc_html_e( 'Search Vendors', 'dokan-lite' ); ?>">
				</div>
				<?php
			endif;
			do_action( 'dokan_after_store_lists_filter_apply_button', $stores );
            wp_nonce_field( 'dokan_store_lists_filter_nonce', '_store_filter_nonce', false ); ?>
            <button type="submit" class="btn"><i class="icon-search"></i></button>
		</form>
    </div>



