<?php
/**
 * The Template for displaying all single posts.
 *
 * @package dokan
 * @package dokan - 2014 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$store_user   = dokan()->vendor->get( get_query_var( 'author' ) );
$store_info   = $store_user->get_shop_info();
$map_location = $store_user->get_location();
$layout       = get_theme_mod( 'store_layout', 'left' );

get_header();
?>
<main class="main" role="main" itemscope itemprop="mainContentOfPage">
	<div class="container">
		<?php
		/**
		 * Hook: woocommerce_before_main_content.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 * @hooked WC_Structured_Data::generate_website_data() - 30
		 * @hooked woocommerce_output_all_notices - 40
		 */
		do_action( 'woocommerce_before_main_content' );
		?>
		<section class="wc-archive">
			
			<?php if (is_active_sidebar('shop')):?>

				<aside class="sidebar shop-sidebar" id="sidebar">

					<?php //dokan_get_template_part( 'store-header' ); ?>
					<?php dynamic_sidebar('shop');?>

				</aside>

			<?php endif; ?>
			<div class="wc-content">
				<div id="dokan-primary" class="dokan-single-store">
					<div id="dokan-content" class="store-page-wrap woocommerce" role="main">
						<?php dokan_get_template_part( 'store-header' ); ?>
						<section class="seller-navigation">
							<?php
							$store_products = dokan_get_option( 'store_products', 'dokan_appearance' );
							if ( ! empty( $store_products['hide_product_filter'] ) ) {
								return;
							}
							$orderby_options = dokan_store_product_catalog_orderby();
							$store_user      = dokan()->vendor->get( get_query_var( 'author' ) );
							$store_id        = $store_user->get_id();
							?>
							<div class="right">
									<i class="icon-spreadsheet-app"></i>
									<span><?php echo __('sort by:','digix');?></span>
								<?php if ( is_array( $orderby_options['catalogs'] ) && isset( $orderby_options['orderby'] ) ) : ?>
									<?php 
										foreach ( $orderby_options['catalogs'] as $id => $name ) : 
											$name = str_replace( 'سازی', '', esc_html( $name ) );
											$name = str_replace( 'بر', '', esc_html( $name ) );
											$name = str_replace( 'اساس', '', esc_html( $name ) );
											$name = str_replace( 'مرتب', '', esc_html( $name ) );
											$name = str_replace( '', '', esc_html( $name ) );
									?>
										<a href="?product-orderboy=<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $name ); ?></a>
									<?php endforeach; ?>
								<?php endif; ?>
							</div>
							<div class="left">
								<form class="dokan-store-products-ordeby" method="get">
									<input type="text" name="product_name" class="product-name-search dokan-store-products-filter-search" placeholder="<?php esc_attr_e( 'Enter product name', 'dokan-lite' ); ?>" autocomplete="off"
											data-store_id="<?php echo esc_attr( $store_id ); ?>">
									<div id="dokan-store-products-search-result" class="dokan-ajax-store-products-search-result"></div>
									<button type="submit" name="search_store_products" class="btn" value="<?php esc_attr_e( 'Search', 'dokan-lite' ); ?>"><i class="icon-search"></i></button>
									<input type="hidden" name="paged" value="1"/>
								</form>
							</div>
						</section>
						<?php if ( have_posts() ) { ?>

							<div class="seller-items">

								<?php woocommerce_product_loop_start(); ?>

								<?php
								while ( have_posts() ) :
									the_post();
									?>

									<?php wc_get_template_part( 'content', 'product' ); ?>

								<?php endwhile; // end of the loop. ?>

								<?php woocommerce_product_loop_end(); ?>

							</div>

							<?php dokan_content_nav( 'nav-below' ); ?>

						<?php } else { ?>

							<p class="dokan-info"><?php esc_html_e( 'No products were found of this vendor!', 'dokan-lite' ); ?></p>

						<?php } ?>
					</div>

				</div><!-- .dokan-single-store -->
			</div>
		</section>
	</div>
</main>
<?php do_action( 'woocommerce_after_main_content' ); ?>

<?php get_footer( 'shop' ); ?>
