<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Digix
 */
Global $options;
?><!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>> 
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="Content-Language" content="fa" />
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate"/>
    <meta http-equiv="Pragma" content="no-cache"/>
    <meta http-equiv="Expires" content="0"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php wp_head(); ?>
</head>
<body itemscope itemtype="http://schema.org/WebPage" <?php body_class('woocommerce'); ?>>
	<?php do_action('notification_bar'); ?>
	<div class="overlay"></div> 
	<?php 
	if ( $options['general-header'] == 'header-default' ){
		get_template_part('partials/header');
	} else if( $options['general-header'] == 'header-modern' ){
		get_template_part('partials/newheader');
	} else if( $options['general-header'] == 'header-cosmetic' ){
		get_template_part('partials/header-cosmetic');
	}
?>
