<?php
/**
 * Brand Thumbnails Widget
 *
 * Show brand images as thumbnails
 *
 * @package		WooCommerce
 * @category	Widgets
 * @author		WooThemes
 */

class WC_Widget_Brand_Thumbnails extends WP_Widget {

	/** Variables to setup the widget. */
	public $woo_widget_cssclass;
	public $woo_widget_description;
	public $woo_widget_idbase;
	public $woo_widget_name;

	/** constructor */
	public function __construct() {

		/* Widget variable settings. */
		$this->woo_widget_name        = __('WooCommerce Brand Thumbnails', 'digix' );
		$this->woo_widget_description = __( 'Show a grid of brand thumbnails.', 'digix' );
		$this->woo_widget_idbase      = 'wc_brands_brand_thumbnails';
		$this->woo_widget_cssclass    = 'widget_brand_thumbnails';

		/* Widget settings. */
		$widget_ops = array( 'classname' => $this->woo_widget_cssclass, 'description' => $this->woo_widget_description );

		/* Create the widget. */
		parent::__construct( $this->woo_widget_idbase, $this->woo_widget_name, $widget_ops );
	}

	/** @see WP_Widget */
	public function widget( $args, $instance ) {
		extract( $args );
		global $options;
		$exclude = array_map( 'intval', explode( ',', $instance['exclude'] ) );
		$order = $instance['orderby'] == 'name' ? 'asc' : 'desc';

		$brands = get_terms( $options['woocommerce-brand-taxonomy'], array( 'hide_empty' => $instance['hide_empty'], 'orderby' => $instance['orderby'], 'exclude' => $exclude, 'number' => $instance['number'], 'order' => $order ) );

		if ( ! $brands ) {
			return;
		}

		$title = apply_filters( 'widget_title', $instance['title'], $instance, $this->woo_widget_idbase );

		echo $args['before_widget'];
		if ( $title !== '' ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		$columns = $instance['columns'];
		$wrapper_class = 'fluid-columns';
		if ( ! $fluid_columns && in_array( $columns, array( 1, 2, 3, 4, 5, 6 ) ) ) {
			$wrapper_class = 'columns-' .  $columns;
		}
		?>
		<ul class="brand-thumbnails <?php echo esc_attr( $wrapper_class ); ?>">

		<?php
			foreach ( array_values( $brands ) as $index => $brand ) :
				$class = '';
				if ( $index == 0 || $index % $columns == 0 ) {
					$class = 'first';
				} else if ( ( $index + 1 ) % $columns == 0 ) {
					$class = 'last';
				}
				?>

				<li class="<?php echo esc_attr( $class ); ?>">
					<a href="<?php echo esc_url( get_term_link( $brand->slug, $options['woocommerce-brand-taxonomy'] ) ); ?>" title="<?php echo esc_attr( $brand->name ); ?>">
						<?php echo get_brand_thumbnail_image( $brand ); ?>
						<span><?php echo esc_attr( $brand->name ); ?></span>
					</a>
				</li>

		<?php endforeach; ?>

		</ul>
		<?php

		echo $after_widget;
	}

	/** @see WP_Widget->update */
	public function update( $new_instance, $old_instance ) {
		$instance['title']         = strip_tags( stripslashes( $new_instance['title'] ) );
		$instance['columns']       = strip_tags( stripslashes( $new_instance['columns'] ) );
		$instance['fluid_columns'] = ! empty( $new_instance['fluid_columns'] ) ? true : false;
		$instance['orderby']       = strip_tags( stripslashes( $new_instance['orderby'] ) );
		$instance['exclude']       = strip_tags( stripslashes( $new_instance['exclude'] ) );
		$instance['hide_empty']    = strip_tags( stripslashes( $new_instance['hide_empty'] ) );
		$instance['number']        = strip_tags( stripslashes( $new_instance['number'] ) );

		if ( ! $instance['columns'] ) {
			$instance['columns'] = 1;
		}

		if ( ! $instance['orderby'] ) {
			$instance['orderby'] = 'name';
		}

		if ( ! $instance['exclude'] ) {
			$instance['exclude'] = '';
		}

		if ( ! $instance['hide_empty'] ) {
			$instance['hide_empty'] = 0;
		}

		if ( ! $instance['number'] ) {
			$instance['number'] = '';
		}

		return $instance;
	}

	/** @see WP_Widget->form */
	public function form( $instance ) {
		if ( ! isset( $instance['hide_empty'] ) ) {
			$instance['hide_empty'] = 0;
		}

		if ( ! isset( $instance['orderby'] ) ) {
			$instance['orderby'] = 'name';
		}

		if ( empty( $instance['fluid_columns'] ) ) {
			$instance['fluid_columns'] = false;
		}

		?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php echo __('Title:', 'wc_brands') ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php if ( isset ( $instance['title'] ) ) echo esc_attr( $instance['title'] ); ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'columns' ); ?>"><?php echo __('Columns:', 'wc_brands') ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'columns' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'columns' ) ); ?>" value="<?php if ( isset ( $instance['columns'] ) ) echo esc_attr( $instance['columns'] ); else echo '1'; ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'fluid_columns' ); ?>"><?php echo __('Fluid columns:', 'wc_brands') ?></label>
				<input type="checkbox" <?php checked( $instance['fluid_columns'] ); ?> id="<?php echo esc_attr( $this->get_field_id( 'fluid_columns' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'fluid_columns' ) ); ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php echo __('Number:', 'wc_brands') ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" value="<?php if ( isset ( $instance['number'] ) ) echo esc_attr( $instance['number'] ); ?>" placeholder="<?php echo __('All', 'wc_brands'); ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'exclude' ); ?>"><?php echo __('Exclude:', 'wc_brands') ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'exclude' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'exclude' ) ); ?>" value="<?php if ( isset ( $instance['exclude'] ) ) echo esc_attr( $instance['exclude'] ); ?>" placeholder="<?php echo __('None', 'wc_brands'); ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'hide_empty' ); ?>"><?php echo __('Hide empty brands:', 'wc_brands') ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'hide_empty' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'hide_empty' ) ); ?>">
					<option value="1" <?php selected( $instance['hide_empty'], 1 ) ?>><?php echo __('Yes', 'wc_brands') ?></option>
					<option value="0" <?php selected( $instance['hide_empty'], 0 ) ?>><?php echo __('No', 'wc_brands') ?></option>
				</select>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php echo __('Order by:', 'wc_brands') ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'orderby' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'orderby' ) ); ?>">
					<option value="name" <?php selected( $instance['orderby'], 'name' ) ?>><?php echo __('Name', 'wc_brands') ?></option>
					<option value="count" <?php selected( $instance['orderby'], 'count' ) ?>><?php echo __('Count', 'wc_brands') ?></option>
				</select>
			</p>
		<?php
	}

}
