<?php

defined('ABSPATH') or die('No script kiddies please!!');

if (!class_exists('CLD_Admin')) {

    class CLD_Admin extends CLD_Library {

        function __construct() {
            parent::__construct();



            /**
             * Add like dislike columns in comments section
             *
             * @since 1.0.5
             */
            add_filter('manage_edit-comments_columns', array($this, 'add_like_dislike_column'));

            /**
             * Display Like Dislike count in each column
             *
             * @since 1.0.5
             */
            add_filter('manage_comments_custom_column', array($this, 'display_like_dislike_values'), 10, 2);

            /**
             * Count Info Meta Box
             */
            add_action('add_meta_boxes', array($this, 'render_count_info_metabox'));

            /**
             * Save comments like dislike meta box
             */
            add_action('edit_comment', array($this, 'save_cld_metabox'));
        }

        function add_like_dislike_column($columns) {
                $columns['cld_like_column'] = __('Likes', 'comments-like-dislike');
                $columns['cld_dislike_column'] = __('Dislikes', 'comments-like-dislike');
            return $columns;
        }

        function display_like_dislike_values($column, $comment_id) {
            if ('cld_like_column' == $column) {
                $like_count = get_comment_meta($comment_id, 'cld_like_count', true);
                if (empty($like_count)) {
                    $like_count = 0;
                }
                echo $like_count;
            }
            if ('cld_dislike_column' == $column) {
                $dislike_count = get_comment_meta($comment_id, 'cld_dislike_count', true);
                if (empty($dislike_count)) {
                    $dislike_count = 0;
                }
                echo $dislike_count;
            }
        }

        function render_count_info_metabox() {
            add_meta_box('cld-count-info', esc_html__('Comments Like Dislike', 'comments-like-dislike'), array($this, 'render_count_info_html'), 'comment', 'normal');
        }

        function render_count_info_html($comment) {
            $comment_id = $comment->comment_ID;
            $like_count = get_comment_meta($comment_id, 'cld_like_count', true);
            $dislike_count = get_comment_meta($comment_id, 'cld_dislike_count', true);
            include(IM_URI . '/includes/classes/comment/views/cld-metabox.php');
        }

        function save_cld_metabox($comment_id) {
            $nonce_name = isset($_POST['cld_metabox_nonce_field']) ? $_POST['cld_metabox_nonce_field'] : '';
            $nonce_action = 'cld_metabox_nonce';

            // Check if nonce is valid.
            if (!wp_verify_nonce($nonce_name, $nonce_action)) {
                return;
            }


            if (isset($_POST['cld_like_count'], $_POST['cld_dislike_count'])) {
                $cld_like_count = sanitize_text_field($_POST['cld_like_count']);
                $cld_dislike_count = sanitize_text_field($_POST['cld_dislike_count']);
                update_comment_meta($comment_id, 'cld_like_count', $cld_like_count);
                update_comment_meta($comment_id, 'cld_dislike_count', $cld_dislike_count);
                return $comment_id;
            } else {
                return $comment_id;
            }
        }

    }

    new CLD_Admin();
}
