<?php
/**
 * Digix functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Digix
 */
// Load plugin class files


class WooCommerce_Product_FAQ_Tab_Admin_API {

	/**
	 * Constructor function
	 */
	public function __construct () {
		
		
		add_action( 'save_post', array( $this, 'save_meta_boxes' ), 10, 1 );
	}

	/**
	 * Generate HTML for displaying fields
	 * @param  array   $field Field data
	 * @param  boolean $echo  Whether to echo the field HTML or return it
	 * @return void
	 */
	public function display_field ( $data = array(), $post = false, $echo = true ) {

		// Get field info
		if ( isset( $data['field'] ) ) {
			$field = $data['field'];
		} else {
			$field = $data;
		}

		// Check for prefix on option name
		$option_name = '';
		if ( isset( $data['prefix'] ) ) {
			$option_name = $data['prefix'];
		}

		// Get saved data
		$data = '';
		if ( $post ) {

			// Get saved field data
			$option_name .= $field['id'];
			$option = get_post_meta( $post->ID, $field['id'], true );

			// Get data to display in field
			if ( isset( $option ) ) {
				$data = $option;
			}

		} 
		else {

			// Get saved option
			$option_name .= $field['id'];
			$option = get_option( $option_name );

			// Get data to display in field
			if ( isset( $option ) ) {
				$data = $option;
			}

		}

		// Show default data if no option saved and default is supplied
		if ( $data === false && isset( $field['default'] ) ) {
			$data = $field['default'];
		} elseif ( $data === false ) {
			$data = '';
		}

		$html = '';

		switch( $field['type'] ) {

			case 'text':
			case 'url':
			case 'email':
				$html .= '<input id="' . esc_attr( $field['id'] ) . '" type="text" name="' . esc_attr( $option_name ) . '" placeholder="' . esc_attr( $field['placeholder'] ) . '" value="' . esc_attr( $data ) . '" />' . "\n";
			break;

			case 'password':
			case 'number':
			case 'hidden':
				$min = '';
				if ( isset( $field['min'] ) ) {
					$min = ' min="' . esc_attr( $field['min'] ) . '"';
				}

				$max = '';
				if ( isset( $field['max'] ) ) {
					$max = ' max="' . esc_attr( $field['max'] ) . '"';
				}
				$html .= '<input id="' . esc_attr( $field['id'] ) . '" type="' . esc_attr( $field['type'] ) . '" name="' . esc_attr( $option_name ) . '" placeholder="' . esc_attr( $field['placeholder'] ) . '" value="' . esc_attr( $data ) . '"' . $min . '' . $max . '/>' . "\n";
			break;

			case 'text_secret':
				$html .= '<input id="' . esc_attr( $field['id'] ) . '" type="text" name="' . esc_attr( $option_name ) . '" placeholder="' . esc_attr( $field['placeholder'] ) . '" value="" />' . "\n";
			break;

			case 'textarea':
				$html .= '<textarea id="' . esc_attr( $field['id'] ) . '" rows="5" cols="50" name="' . esc_attr( $option_name ) . '" placeholder="' . esc_attr( $field['placeholder'] ) . '">' . $data . '</textarea><br/>'. "\n";
			break;

			case 'checkbox':
				$checked = '';
				if ( $data && 'on' == $data ) {
					$checked = 'checked="checked"';
				}
				$html .= '<input id="' . esc_attr( $field['id'] ) . '" type="' . esc_attr( $field['type'] ) . '" name="' . esc_attr( $option_name ) . '" ' . $checked . '/>' . "\n";
			break;

			case 'checkbox_multi':
				foreach ( $field['options'] as $k => $v ) {
					$checked = false;
					if ( in_array( $k, (array) $data ) ) {
						$checked = true;
					}
					$html .= '<label for="' . esc_attr( $field['id'] . '_' . $k ) . '" class="checkbox_multi"><input type="checkbox" ' . checked( $checked, true, false ) . ' name="' . esc_attr( $option_name ) . '[]" value="' . esc_attr( $k ) . '" id="' . esc_attr( $field['id'] . '_' . $k ) . '" /> ' . $v . '</label> ';
				}
			break;

			case 'radio':
				foreach ( $field['options'] as $k => $v ) {
					$checked = false;
					if ( $k == $data ) {
						$checked = true;
					}
					$html .= '<label for="' . esc_attr( $field['id'] . '_' . $k ) . '"><input type="radio" ' . checked( $checked, true, false ) . ' name="' . esc_attr( $option_name ) . '" value="' . esc_attr( $k ) . '" id="' . esc_attr( $field['id'] . '_' . $k ) . '" /> ' . $v . '</label> ';
				}
			break;

			case 'select':
				$html .= '<select name="' . esc_attr( $option_name ) . '" id="' . esc_attr( $field['id'] ) . '">';
				foreach ( $field['options'] as $k => $v ) {
					$selected = false;
					if ( $k == $data ) {
						$selected = true;
					}
					$html .= '<option ' . selected( $selected, true, false ) . ' value="' . esc_attr( $k ) . '">' . $v . '</option>';
				}
				$html .= '</select> ';
			break;

			case 'select_multi':
				$html .= '<select name="' . esc_attr( $option_name ) . '[]" id="' . esc_attr( $field['id'] ) . '" multiple="multiple">';
				foreach ( $field['options'] as $k => $v ) {
					$selected = false;
					if ( in_array( $k, (array) $data ) ) {
						$selected = true;
					}
					$html .= '<option ' . selected( $selected, true, false ) . ' value="' . esc_attr( $k ) . '">' . $v . '</option>';
				}
				$html .= '</select> ';
			break;

			case 'image':
				$image_thumb = '';
				if ( $data ) {
					$image_thumb = wp_get_attachment_thumb_url( $data );
				}
				$html .= '<img id="' . $option_name . '_preview" class="image_preview" src="' . $image_thumb . '" /><br/>' . "\n";
				$html .= '<input id="' . $option_name . '_button" type="button" data-uploader_title="' . __( 'Upload an image' , 'digix' ) . '" data-uploader_button_text="' . __( 'Use image' , 'digix' ) . '" class="image_upload_button button" value="'. __( 'Upload new image' , 'digix' ) . '" />' . "\n";
				$html .= '<input id="' . $option_name . '_delete" type="button" class="image_delete_button button" value="'. __( 'Remove image' , 'digix' ) . '" />' . "\n";
				$html .= '<input id="' . $option_name . '" class="image_data_field" type="hidden" name="' . $option_name . '" value="' . $data . '"/><br/>' . "\n";
			break;

			case 'color':
				?><div class="color-picker" style="position:relative;">
			        <input type="text" name="<?php esc_attr_e( $option_name ); ?>" class="color" value="<?php esc_attr_e( $data ); ?>" />
			        <div style="position:absolute;background:#FFF;z-index:99;border-radius:100%;" class="colorpicker"></div>
			    </div>
			    <?php
			break;
			
			case 'question_answer':
				
				$is_valid = true;
				
				if( !isset($data['question'][0]) || !isset($data['answer'][0]) || !empty($data['question'][0]) || !empty($data['answer'][0]) ){
					
					$arr = ['question' => [ 0 => '' ], 'answer' => [ 0 => '' ]];

					if( isset($data['question']) ){

						$arr['question'] = array_merge($arr['question'],$data['question']);
					}

					if( isset($data['answer']) ){

						$arr['answer'] = array_merge($arr['answer'],$data['answer']);
					}					

					$data = $arr;
				}
				
				$html .= '<div id="'.$field['id'].'" class="'. ( $is_valid ? 'sortable' : 'unsortable').'">';
					
					$html .= ' <a href="#" class="wfaq-add-input-group" data-target="'.$field['id'].'-row" style="line-height:40px;">Add question</a>';
				
					$html .= '<ul class="input-group'. ( $is_valid ? ' ui-sortable' : ' ui-unsortable').'">';
						
						foreach( $data['question'] as $e => $question) {

							if( $e > 0 && $is_valid ){
								
								$class='input-group-row'. ( $is_valid ? ' ui-state-default ui-sortable-handle' : '');
							}
							else{
								
								$class='input-group-row'. ( $is_valid ? ' ui-state-default ui-state-disabled' : '');
							}
						
							$answer = str_replace('\\\'','\'',$data['answer'][$e]);
									
							$html .= '<li class="'.$class.' '.$field['id'].'-row" style="display:'.( $e == 0 ? 'none' : 'inline-block' ).';width:97%;background: rgb(255, 255, 255);">';
						
								$html .= '<div style="width:100%;display:inline-block;'.( $is_valid ? 'background-image: url(' . $this->parent->assets_url . 'images/dnd-icon.png?3);background-position-y:5px;background-position-x:right;background-repeat: no-repeat;background-color: transparent;' : '' ).'">';
						
									$html .= '<input type="text" placeholder="Question" style="width:80%;margin-bottom:5px;" name="'.$option_name.'[question][]" value="'.$data['question'][$e].'">';
									
									if( $e > 0 ){
									
										$html .= '<a class="remove-input-group" href="#">remove</a> ';

									}

								$html .= '</div>';
								
								$html .= '<div style="width:100%;">';
									
									if( $e > 0 && $is_valid ){
									
										$html .= '<div class="wp-media-buttons" style="display: contents;"><button type="button" class="button insert-media add_media" data-editor="'.$field['id'].'-content-'.$e.'"><span class="wp-media-buttons-icon"></span> Add Media</button></div>';
									}
									
									$html .= '<textarea'.( $e > 0 ? ' id="'.$field['id'].'-content-'.$e.'"' : '' ).' class="'.( ( $e > 0  && $is_valid ) ? 'wfaq-rich-text' : '' ).'" placeholder="Answer" name="'.$option_name.'[answer][]" style="width:100%;height:150px;">' . $answer . '</textarea>';

								$html .= '</div>';

							$html .= '</li>';						
						}
					
					$html .= '</ul>';					
					
				$html .= '</div>';

			break;

		}

		switch( $field['type'] ) {

			case 'checkbox_multi':
			case 'radio':
			case 'select_multi':
				$html .= '<br/><span class="description">' . $field['description'] . '</span>';
			break;

			default:
				if ( ! $post ) {
					$html .= '<label for="' . esc_attr( $field['id'] ) . '">' . "\n";
				}

				$html .= '<span class="description">' . $field['description'] . '</span>' . "\n";

				if ( ! $post ) {
					$html .= '</label>' . "\n";
				}
			break;
		}

		if ( ! $echo ) {
			return $html;
		}

		echo $html;

	}

	/**
	 * Validate form field
	 * @param  string $data Submitted value
	 * @param  string $type Type of field to validate
	 * @return string       Validated value
	 */
	public function validate_field ( $data = '', $type = 'text' ) {

		switch( $type ) {
			case 'text': $data = esc_attr( $data ); break;
			case 'url': $data = esc_url( $data ); break;
			case 'email': $data = is_email( $data ); break;
		}

		return $data;
	}

	/**
	 * Add meta box to the dashboard
	 * @param string $id            Unique ID for metabox
	 * @param string $title         Display title of metabox
	 * @param array  $post_types    Post types to which this metabox applies
	 * @param string $context       Context in which to display this metabox ('advanced' or 'side')
	 * @param string $priority      Priority of this metabox ('default', 'low' or 'high')
	 * @param array  $callback_args Any axtra arguments that will be passed to the display function for this metabox
	 * @return void
	 */
	public function add_meta_box ( $id = '', $title = '', $post_types = array(), $context = 'advanced', $priority = 'default', $callback_args = null ) {

		// Get post type(s)
		if ( ! is_array( $post_types ) ) {
			$post_types = array( $post_types );
		}

		// Generate each metabox
		foreach ( $post_types as $post_type ) {
			add_meta_box( $id, $title, array( $this, 'meta_box_content' ), $post_type, $context, $priority, $callback_args );
		}
	}

	/**
	 * Display metabox content
	 * @param  object $post Post object
	 * @param  array  $args Arguments unique to this metabox
	 * @return void
	 */
	public function meta_box_content ( $post, $args ) {

		$fields = apply_filters( $post->post_type . '_custom_fields', array(), $post->post_type );

		if ( ! is_array( $fields ) || 0 == count( $fields ) ) return;

		echo '<div class="custom-field-panel">' . "\n";

		foreach ( $fields as $field ) {

			if ( ! isset( $field['metabox'] ) ) continue;

			if ( ! is_array( $field['metabox'] ) ) {
				$field['metabox'] = array( $field['metabox'] );
			}

			if ( in_array( $args['id'], $field['metabox'] ) ) {
				$this->display_meta_box_field( $field, $post );
			}

		}

		echo '</div>' . "\n";

	}

	/**
	 * Dispay field in metabox
	 * @param  array  $field Field data
	 * @param  object $post  Post object
	 * @return void
	 */
	public function display_meta_box_field ( $field = array(), $post ) {

		if ( ! is_array( $field ) || 0 == count( $field ) ) return;

		$field = '<p class="form-field"><label for="' . $field['id'] . '">' . $field['label'] . '</label>' . $this->display_field( $field, $post, false ) . '</p>' . "\n";

		echo $field;
	}

	/**
	 * Save metabox fields
	 * @param  integer $post_id Post ID
	 * @return void
	 */
	public function save_meta_boxes ( $post_id = 0 ) {

		if ( ! $post_id ) return;

		$post_type = get_post_type( $post_id );

		$fields = apply_filters( $post_type . '_custom_fields', array(), $post_type );

		if ( ! is_array( $fields ) || 0 == count( $fields ) ) return;

		foreach ( $fields as $field ) {
			
			if ( isset( $_REQUEST[ $field['id'] ] ) ) {
				
				update_post_meta( $post_id, $field['id'], $this->validate_field( $_REQUEST[ $field['id'] ], $field['type'] ) );
			} 
			else {
				
				update_post_meta( $post_id, $field['id'], '' );
			}
		}
	}

}

class digix_faqs_class{
	private static $_instance = null;

	public static function instance() 
    {

		if ( is_null( self::$_instance ) ) 
        {
			self::$_instance = new self();
		}

		return self::$_instance;

	}
	public function __construct (){
		
	$obj = new WooCommerce_Product_FAQ_Tab_Admin_API();
	add_filter( 'woocommerce_product_data_tabs', array( $this, 'digix_faqs_tab' ) );			
	add_action( 'woocommerce_product_data_panels', array( $this, 'faq_options_product_tab_content' )); // WC 2.6 and up
	add_action( 'save_post_product', array( $this, 'save_faq_option_fields' ));
	add_action('woocommerce_product_tabs', array( $this, 'digix_faqs' ));
		$this->title 		= __('FAQs','digix');
		$this->priority 	= intval(20);
		$this->accordion 	= 'yes';
		$this->form 		= 'no';
		$this->showEmpty 	= 'no';
	}
	/**
	 * Add a custom product tab.
	 */
	 
	public function digix_faqs_tab($tab_data) {
			
			$new_tab['faq'] = array(
			
				'label'		=> __( 'FAQs', 'wc_faq' ),
				'target'	=> 'faq_options',
				'class'		=> array( 'show_if_simple', 'show_if_variable'  ),
			);
				$position = 10;
				$ftabs = array_slice( $tab_data, 0, $position, true );
				$ftabs = array_merge( $ftabs, $new_tab );
				$ftabs = array_merge( $ftabs, array_slice( $tab_data, $position, null, true ) );

		return $ftabs;
		
	}
	
	/**
	 * Contents of the gift card options product tab.
	 */
	 
	public function faq_options_product_tab_content() {
		$obj = new WooCommerce_Product_FAQ_Tab_Admin_API();
		global $post;
		
		// Note the 'id' attribute needs to match the 'target' parameter set above
		?><div id='faq_options' class='panel woocommerce_options_panel'><?php
			?><div class='options_group'>
			
			<?php
					
				$obj->display_field( array(
				
					'type'				=> 'question_answer',
					'id'				=> 'wfaq_items',
					'name'				=> 'wfaq_items',
					'description'		=> ''
					
				), $post );
			?>
			
			</div>

		</div><?php
	}
	
	/**
	 * Save the custom fields.
	 */
	 
	public function save_faq_option_fields( $post_id ) {
		
		if( !empty($_POST['wfaq_items']) && is_array($_POST['wfaq_items']) && isset($_POST['wfaq_items']['question']) && isset($_POST['wfaq_items']['answer']) && count($_POST['wfaq_items']['question']) == count($_POST['wfaq_items']['answer']) ){
			
			$items = $_POST['wfaq_items'];
			
			if( !empty($items['answer']) ){
				
				foreach( $items['answer'] as $i => $answer ){
					
					$items['answer'][$i] = str_replace('src=\"../','src=\"/',$answer);
				}
			}
			
			update_post_meta( $post_id, 'wfaq_items', $items );
		}
	}
	
	public function get_product_faqs($product_id){
		
		$faqs = array();
		
		if( is_null($this->tab_data) ){
		
			$this->tab_data = get_post_meta( $product_id, 'wfaq_items', true );
		}
		
		if( !empty($this->tab_data['question']) ){
			
			foreach( $this->tab_data['question'] as $e => $question ){

				if( !empty($question) ){
					
					$answer = $this->tab_data['answer'][$e];
					
					$faqs[$question] = $answer;
				}
			}
		}
		
		return $faqs;
	}
	
	/**
	 * Write the images tab on the product view page for WC 2.0+.
	 * In WooCommerce these are handled by templates.
	 */
	public function digix_faqs($tabs){
		
		global $post, $wpdb, $product;
		
		$faqs = $this->get_product_faqs( $post->ID );
		
		$countItems = count($faqs);

		if( $this->showEmpty == 'yes' || $countItems > 0 ){

			$tabs['faqs'] = array(
			
				'title'    => __('FAQS', 'digix') . ' ('.$countItems.')',
				'priority' => 20,
				'callback' => array($this, 'faqs_panel')
			);
		}
		
		return $tabs;
	}

	/**
	 * Write the images tab panel on the product view page.
	 * In WooCommerce these are handled by templates.
	 */
	public function faqs_panel(){
		
		global $post, $wpdb, $product;
		
		$faqs = $this->get_product_faqs( $post->ID );

		/**
		 * Checks if any images are attached to the product.
		 */
		$countItems = count($faqs);

		if( $this->showEmpty == 'yes' || $countItems > 0  ){
		
			echo '<div id="wfaq_items" class="accordion-container wfaq-accordion">';

				$i=1;
				
				foreach( $faqs as $question => $answer ){
					
					echo '<div class="accordion-section' . ( $i==1 ? ' open' : '' ) . '">';
					
						echo '<h3 id="wfaq-section-'.$i.'" class="accordion-section-title wfaq-question" aria-expanded="' . ( $i==1 ? 'true' : 'false' ) . '">' . $question . '<i class="icon-question"></i></h3>';
				
						echo '<div class="accordion-section-content wfaq-answer">' . $answer . '</div>';
					
					echo'</div>';
					
					++$i;
				}
				
			echo '</div>';
		}
	}
}
digix_faqs_class::instance();