<?php
/**
 * Plugin Name: پارسی‌مپ برای ووکامرس
 * Plugin URI: https://docs.parsimap.ir/wordpress/woocommerce
 * Description: ابزاری برای افزودن نقشه و انتخابگر آدرس به فروشگاه ساز ووکامرس
 * Version: 1.0.0
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: parsimap-wooccomerce
 * 
 * Requires at least: 5.5
 * Requires PHP: 7.0
 *
 * @package Parsimap
 */
if (!defined('ABSPATH')) {
    exit;
}
if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) 
{
   return false;
}
add_action('wp_head', 'hook_external_assets_files');
add_action('admin_head', 'hook_external_assets_files');

function hook_external_assets_files()
{
  echo '
    <script src="https://cdn.parsimap.ir/third-party/leaflet/v1.7.1/leaflet.js"></script>
    <link href="https://cdn.parsimap.ir/third-party/leaflet/v1.7.1/leaflet.css" rel="stylesheet" />
    <script src="https://cdn.parsimap.ir/third-party/leaflet/plugins/parsimap-tile/v1.0.0/parsimap-tile.js"></script>
    <script src="https://cdn.parsimap.ir/third-party/leaflet/plugins/parsimap-geocoder/v1.0.0/parsimap-geocoder.js"></script>
    <link href="https://cdn.parsimap.ir/third-party/leaflet/plugins/parsimap-geocoder/v1.0.0/parsimap-geocoder.css" rel="stylesheet" />
  ';
}
add_action('woocommerce_after_checkout_billing_form', 'hook_mapview_after_checkout_billing_form');

function hook_mapview_after_checkout_billing_form()
{
  echo '
  <h2>آدرس جغرافیایی</h2>
  <label style="text-align: justify;">
    با کلیک بروی نقشه و یا جستجو
    در کادر مربوطه آدرس دقیق خود را انتخاب کنید.
  </label>
  <div id="map" style="height: 400px; width: 100%;"></div>

  <script>
    /** See https://docs.parsimap.ir/javascript/leaflet#add-map-to-website */
    const map = new L.Map("map", {
      center: [35.75, 51.41],
      zoom: 6,
      zoomControl: false
    })

    L.parsimapTileLayer("parsimap-streets-v11-raster", {
      key: "PMI_MAP_TOKEN",
      service: true,
    }).addTo(map)

    const control = new ParsimapGeocoder()
    map.addControl(control)

    map.on("blur", function() {
      const latitudeInput = document.querySelector("#pmi_latitude")
      const longitudeInput = document.querySelector("#pmi_longitude")
      const addressInput = document.querySelector("#pmi_address")

      /** See https://docs.parsimap.ir/plugins/geocode/parsimap-geocoder#user-manual */
      control.reverseLocation().then((reverse) => {
        const lngLat = reverse.lngLat
        const address = reverse.address

        latitudeInput.value = lngLat.lat
        longitudeInput.value = lngLat.lng
        addressInput.value = address
      })
    })
  </script>
';
}
add_action('woocommerce_after_checkout_billing_form', 'hook_geolocation_fields_after_checkout_billing_form');

function hook_geolocation_fields_after_checkout_billing_form($checkout)
{
  echo '<div class="woocommerce-billing-fields__field-wrapper">';

  woocommerce_form_field('pmi_latitude', array(
    'type'          => 'text',
    'class'         => array('form-row-wide'),
    'label'         => __('Latitude'),
  ), $checkout->get_value('pmi_latitude'));

  woocommerce_form_field('pmi_longitude', array(
    'type'          => 'text',
    'class'         => array('form-row-wide'),
    'label'         => __('Longitude'),
  ), $checkout->get_value('pmi_longitude'));

  woocommerce_form_field('pmi_address', array(
    'type'          => 'text',
    'class'         => array('form-row-wide'),
    'label'         => __('Position'),
  ), $checkout->get_value('pmi_address'));

  echo '</div>';
}
add_action('woocommerce_checkout_update_order_meta', 'hook_checkout_update_order_meta_with_geolocation');

function hook_checkout_update_order_meta_with_geolocation($order_id)
{
  if (!empty($_POST['pmi_latitude'])) {
    update_post_meta($order_id, 'pmi_latitude', sanitize_text_field($_POST['pmi_latitude']));
  }

  if (!empty($_POST['pmi_longitude'])) {
    update_post_meta($order_id, 'pmi_longitude', sanitize_text_field($_POST['pmi_longitude']));
  }

  if (!empty($_POST['pmi_address'])) {
    update_post_meta($order_id, 'pmi_address', sanitize_text_field($_POST['pmi_address']));
  }
}
add_action('woocommerce_admin_order_data_after_billing_address', 'hook_geolocation_data_after_billing_address');

function hook_geolocation_data_after_billing_address($order)
{
  echo '<p>';
  echo '<strong>' . __('Latitude') . ':</strong>';
  echo get_post_meta($order->id, 'pmi_latitude', true);
  echo '</p>';
  echo '<p>';
  echo '<strong>' . __('Longitude') . '</strong>';
  echo get_post_meta($order->id, 'pmi_longitude', true);
  echo '</p>';
  echo '<p>';
  echo '<strong>' . __('Position') . '</strong>';
  echo get_post_meta($order->id, 'pmi_address', true);
  echo '</p>';
}
add_action('woocommerce_admin_order_data_after_billing_address', 'hook_mapview_after_billing_address');

function hook_mapview_after_billing_address($order)
{
  echo '
   <div id="map" style="height: 200px; width: 100%;"></div>
   <script>
     const center = ['
    . get_post_meta($order->id, 'pmi_latitude', true) . ','
    . get_post_meta($order->id, 'pmi_longitude', true) .
    ']

     /** See https://docs.parsimap.ir/javascript/leaflet#add-map-to-website */
     const map = new L.Map("map", {
       center,
       zoom: 16,
       zoomControl: false
     })

     L.parsimapTileLayer("parsimap-streets-v11-raster", {
       key: "PMI_MAP_TOKEN",
       service: true,
     }).addTo(map)

     const icon = L.icon({
       iconSize: [42, 42],
       iconAnchor: [42 / 2, 42],
       iconUrl: "data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 24 24\' fill=\'%23cc3433\'%3E%3Cpath d=\'M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z\'%3E%3C/path%3E%3C/svg%3E",
     })

     L.marker(center, {
       icon
     }).addTo(map)
   </script>
   ';
}
