<?php
// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

    //
    // Set a unique slug-like ID
    $prefix = 'digix_metabox';
  
    //
    // Create a metabox
    CSF::createMetabox( $prefix, array(
      'title'     => __('MetaBox','digix'),
      'post_type' => 'product',
      'data_type' => 'serialize',
    ) );
  
    //
    // Create a section
    CSF::createSection( $prefix, array(
      'title'  => __('default','digix'),
      'fields' => array(
  
        //
        // A text field
        array(
          'id'    => 'subtitle',
          'type'  => 'text',
          'title' => __('زیرعنوان','digix'),
        ),
        array(
          'id'    => 'video',
          'type'  => 'text',
          'title' => __('لینک ویدئو معرفی محصول','digix'),
        ),
		array(
          'id'       => 'customer-free-switcher',
          'type'     => 'switcher',
          'default'  => false,
          'title'    => __('فیلد های آزاد فعال باشد؟','digix'),
          'text_on'  => 'بله',
          'text_off' => 'خیر',
        ),
		array(
          'id'     => 'customer-free',
		  'dependency' 	=> array( 'customer-free-switcher', '==', true ),
          'type'   => 'group',
          'title'  => __('فیلد های آزاد','digix'),
          'subtitle'  => __('در این بخش میتوانید فیلدهای دلخواه قرار دهید','digix'),
          'fields' => array(
			array(
              'id'    => 'label',
              'type'  => 'text',
              'title' => __('عنوان','digix'),
            ),
			array(
			  'id'      => 'pic',
			  'type'    => 'upload',
			  'title'   => __('تصویر','digix'),
			  'subtitle'   => __('سایز تصویر 20 پیکسل در 20 پیکسل ','digix'),
			  'library' => 'image',
			),
            array(
              'id'    => 'value',
              'type'  => 'textarea',
              'title' => __('مقدار','digix'),
            ),
          ),
          'default' => array(
            array(
			  'pic'  => '',
              'label'     => __('ارسال از انبار تهران:','digix'),
              'value' => __('1 الی 2 روز کاری','digix'),
            ),
          )
        ),
        array(
          'id'     => 'range1',
          'type'   => 'fieldset',
          'title'  => __('امتیاز دیدگاه شماره یک','digix'),
          'fields' => array(
            array(
              'id'    => 'name',
              'type'  => 'text',
              'title' => __('عنوان','digix'),
            ),
            array(
              'id'       => 'slider',
              'type'     => 'slider',
              'title'    => __('مقدار امتیاز','digix'),
              'unit'     => '%',
              'min'      => 0,
              'max'      => 100,
              'step'     => 25,
              'default'  => 50,
            ),
          ),
        ),
        array(
          'id'     => 'range2',
          'type'   => 'fieldset',
          'title'  => __('امتیاز دیدگاه شماره دو','digix'),
          'fields' => array(
            array(
              'id'    => 'name',
              'type'  => 'text',
              'title' => __('عنوان','digix'),
            ),
            array(
              'id'       => 'slider',
              'type'     => 'slider',
              'title'    => __('مقدار امتیاز','digix'),
              'unit'     => '%',
              'min'      => 0,
              'max'      => 100,
              'step'     => 25,
              'default'  => 50,
            ),
          ),
        ),
        array(
          'id'     => 'range3',
          'type'   => 'fieldset',
          'title'  => __('امتیاز دیدگاه شماره سه','digix'),
          'fields' => array(
            array(
              'id'    => 'name',
              'type'  => 'text',
              'title' => __('عنوان','digix'),
            ),
            array(
              'id'       => 'slider',
              'type'     => 'slider',
              'title'    => __('مقدار امتیاز','digix'),
              'unit'     => '%',
              'min'      => 0,
              'max'      => 100,
              'step'     => 25,
              'default'  => 50,
            ),
          ),
        ),
        array(
          'id'     => 'range4',
          'type'   => 'fieldset',
          'title'  => __('امتیاز دیدگاه شماره چهار','digix'),
          'fields' => array(
            array(
              'id'    => 'name',
              'type'  => 'text',
              'title' => __('عنوان','digix'),
            ),
            array(
              'id'       => 'slider',
              'type'     => 'slider',
              'title'    => __('مقدار امتیاز','digix'),
              'unit'     => '%',
              'min'      => 0,
              'max'      => 100,
              'step'     => 25,
              'default'  => 50,
            ),
          ),
        ),
        array(
          'id'     => 'range5',
          'type'   => 'fieldset',
          'title'  => __('امتیاز دیدگاه شماره پنچ','digix'),
          'fields' => array(
            array(
              'id'    => 'name',
              'type'  => 'text',
              'title' => __('عنوان','digix'),
            ),
            array(
              'id'       => 'slider',
              'type'     => 'slider',
              'title'    => __('مقدار امتیاز','digix'),
              'unit'     => '%',
              'min'      => 0,
              'max'      => 100,
              'step'     => 25,
              'default'  => 50,
            ),
          ),
        ),
      )
    ) );
  
  }
  $meta = get_post_meta( get_the_ID(), 'digix_metabox', true );