<?php
class Utility {
	public static function getDatesList( $from ) {
		$dates  = [];
		$period = new \DatePeriod(
			new \DateTime( date( 'Y-m-d', $from ) ),
			new \DateInterval( 'P1D' ),
			new \DateTime( date( 'Y-m-d', strtotime( '+1 day' ) ) )
		);
		foreach ( $period as $key => $value ) {
			$dates[] = $value->format( 'Y-m-d' );
		}

		return $dates;
	}

	public static function niceNumber( $number, $comma = true ) {
		if ( $comma ) {
			$number = number_format( $number );
		}

		return str_replace( array( '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' ), array( '۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹' ), $number );
	}

	public static function human_time( $time ) {
		$date      = sprintf(
			_x( '%s پیش', 'Human-readable time', 'text-domain' ),
			human_time_diff(
				$time,
				current_time( 'timestamp', 1 )
			)
		);
		$translate = str_replace( [ 'second', 'min', 'hour', 'day', 'week', 'month', 'year' ], [ 'ثانیه', 'دقیقه', 'ساعت', 'روز', 'هفته', 'ماه', 'سال' ], $date );

		return self::niceNumber( $translate, false );
	}

	public static function upload_file( $file, $directory, $allowFile = null ) {
		$tmp  = $file['tmp_name'];
		$name = rand( 100, 10000 );
		$name .= '-' . $file['name'];
		if ( $allowFile && ! in_array( $file['type'], $allowFile ) ) {
			return false;
		}
		$size = ( new Option( 'general' ) )->get_option( 'upload_size' );
		if ( $size ) {
			if ( ( $file['size'] >= (int) $size * 1048576 ) || ( $file['size'] == 0 ) ) {
				return false;
			}
		}
		$base_directory = trailingslashit( wp_upload_dir()['basedir'] );
		$base_directory .= $directory;
		if ( ! file_exists( $base_directory ) ) {
			mkdir( $base_directory, 0777, true );
		}
		$base_directory .= '/' . $name;
		if ( move_uploaded_file( $tmp, $base_directory ) ) {
			return $directory . '/' . $name;
		}

		return null;
	}

	public static function startsWith( $string, $startString ) {
		$len = strlen( $startString );

		return ( substr( $string, 0, $len ) === $startString );
	}
}