<?php
/**
 * DIGIX functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package DIGIX
 */
global $product, $options;



#
##
# Woocommerce and gallery support

function digix_woocommerce_support()
{
  add_theme_support( 'woocommerce');
  add_theme_support( 'wc-product-gallery-zoom' );
  add_theme_support( 'wc-product-gallery-lightbox' );
  add_theme_support( 'wc-product-gallery-slider' );
}
add_action( 'after_setup_theme', 'digix_woocommerce_support' );



#
##
# modify woocommerce thumbnail on shop page
 
add_filter( 'woocommerce_get_image_size_thumbnail', function( $size ) {
    return array(
      'width'  => 200,
      'height' => 200,
      'crop'   => 1,
    );
});


#
##
# WooCommerce Sales Sorting Filter
add_filter( 'woocommerce_get_catalog_ordering_args', 'wcs_get_catalog_ordering_args' );
function wcs_get_catalog_ordering_args( $args ) {
	
    $orderby_value = isset( $_GET['orderby'] ) ? woocommerce_clean( $_GET['orderby'] ) : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
     
    if ( 'on_sale' == $orderby_value ) {
        $args['orderby'] = 'meta_value_num';
        $args['order'] = 'DESC';
        //$args['meta_key'] = '_sale_price'; 
		$args['meta_query']     = array(
				'relation' => 'OR',
				array( // Simple products type
					'key'           => '_sale_price',
					'value'         => 0,
					'compare'       => '>',
					'type'          => 'numeric'
				),
				array( // Variable products type
					'key'           => '_min_variation_sale_price',
					'value'         => 0,
					'compare'       => '>',
					'type'          => 'numeric'
				)
			);
    }
    return $args;
	
}
 
add_filter( 'woocommerce_default_catalog_orderby_options', 'wcs_catalog_orderby' );
add_filter( 'woocommerce_catalog_orderby', 'wcs_catalog_orderby' );
function wcs_catalog_orderby( $sortby ) {
    $sortby['on_sale'] = __('on-sale','digix');
	
    return $sortby;

}

#
##
# add on-sale class to body
if( !empty($_GET['orderby']) ){
	if($_GET['orderby'] == 'on_sale' ){
		add_filter( 'body_class', function( $classes ) {return array_merge( $classes, array( 'on-sale' ) );} );
	}
}
if ( $options['woocommerce-outstock'] === '1' ) {
	#
	##
	# show out of stock product on end of list
	add_filter( 'posts_clauses', 'digix_wc_orderby_status', 2000 );
	function digix_wc_orderby_status( $posts_clauses ){
		global $options;
		
		global $wpdb;
		if ( !is_page() && !is_single() && !is_admin() && is_woocommerce() && is_archive() ) {
			$posts_clauses['join'] .= " INNER JOIN $wpdb->postmeta istockstatus ON ( $wpdb->posts.ID = istockstatus.post_id ) ";
			$posts_clauses['orderby'] = " istockstatus.meta_value ASC, " . $posts_clauses['orderby'];
			$posts_clauses['where'] = " AND istockstatus.meta_key = '_stock_status' AND istockstatus.meta_value <> '' " . $posts_clauses['where'];
		}
		return $posts_clauses;
	}
}
#
##
# modify woocommerce thumbnail on Single
 
add_filter('woocommerce_get_image_size_single',function( $size ) {
    return array(
      'width'  => 420,
      'height' => 420,
      'crop'   => 0,
    );
});





#
##
#  Change several of the breadcrumb defaults
add_action( 'woocommerce_product_query', 'digix_amazing_archive_ordering_query' ); // archive - amazing product ordering query
function digix_amazing_archive_ordering_query($q){
	$orderby_value = isset( $_GET['orderby'] ) ? wc_clean( $_GET['orderby'] ) : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
	if ( 'on_sale' == $orderby_value ) {
		$product_ids_on_sale = wc_get_product_ids_on_sale();
		$q->set( 'post__in', (array) $product_ids_on_sale );
	}
}

#
##
#  Change several of the breadcrumb defaults

function digix_woocommerce_breadcrumbs() {
    return array(
            'delimiter'   => ' <i class="icon-arrow-left"></i> ',
            'wrap_before' => '<nav class="box woocommerce-breadcrumb" itemprop="breadcrumb">',
            'wrap_after'  => '</nav>',
            'before'      => '',
            'after'       => '',
            'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
        );
}
add_filter( 'woocommerce_breadcrumb_defaults', 'digix_woocommerce_breadcrumbs' );





#
##
# digix woocommerce ajax add to cart count 

add_filter( 'woocommerce_add_to_cart_fragments', 'digix_woocommerce_totalcount_fragments', 10, 1 );

function digix_woocommerce_totalcount_fragments( $fragments ) {
	$fragments['span.cart-count'] = '<span class="cart-count">' . WC()->cart->get_cart_contents_count()  . '</span>';
		ob_start();
    echo '<div class="mini-cart">';
		woocommerce_mini_cart();
		echo '</div>';
    $fragments['div.mini-cart'] = ob_get_clean();
    return $fragments;

}




#
##
# Remove product in the cart using ajax

function digix_woocommerce_product_remove()
{
    // Get mini cart
    ob_start();

    foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item)
    {
        if($cart_item['product_id'] == $_POST['product_id'] && $cart_item_key == $_POST['cart_item_key'] )
        {
            WC()->cart->remove_cart_item($cart_item_key);
        }
    }

    WC()->cart->calculate_totals();
    WC()->cart->maybe_set_cart_cookies();

    woocommerce_mini_cart();

    $mini_cart = ob_get_clean();

    // Fragments and mini cart are returned
    $data = array(
        'fragments' => apply_filters( 'woocommerce_add_to_cart_fragments', array(
                'div.widget_shopping_cart_content' => '<div class="widget_shopping_cart_content">' . $mini_cart . '</div>'
            )
        ),
        'cart_hash' => apply_filters( 'woocommerce_add_to_cart_hash', WC()->cart->get_cart_for_session() ? md5( json_encode( WC()->cart->get_cart_for_session() ) ) : '', WC()->cart->get_cart_for_session() )
    );

    wp_send_json( $data );

    die();
}

add_action( 'wp_ajax_product_remove', 'digix_woocommerce_product_remove' );
add_action( 'wp_ajax_nopriv_product_remove', 'digix_woocommerce_product_remove' );


#
##
#  add to cart ajax single

add_action('wp_ajax_woocommerce_ajax_add_to_cart', 'woocommerce_ajax_add_to_cart');
add_action('wp_ajax_nopriv_woocommerce_ajax_add_to_cart', 'woocommerce_ajax_add_to_cart');
        
function woocommerce_ajax_add_to_cart() {

    $product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
    $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
    $variation_id = absint($_POST['variation_id']);
    $passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);
    $product_status = get_post_status($product_id);

    if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity, $variation_id) && 'publish' === $product_status) {

        do_action('woocommerce_ajax_added_to_cart', $product_id);

        if ('yes' === get_option('woocommerce_cart_redirect_after_add')) {
            wc_add_to_cart_message(array($product_id => $quantity), true);
        }

        WC_AJAX :: get_refreshed_fragments();
    } else {

        $data = array(
            'error' => true,
            'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id));

        echo wp_send_json($data);
    }

    wp_die();
}

#
##
# Digix WC single product action

function digix_wc_single_action_pricechart()
{
  $post_id = get_the_id();
  Global $post;
	if ( mk_product_has_price_change( $post_id ) ):
      $action  = '<div class="action-item">';
			$action .= '<button class="history-price" data-id="' . $post_id . '" data-toggle="modal" data-target="#price-changes-modal">';
      $action .= '<i class="icon-line-chart"></i>';
      $action .= '<span>' . __('price history','digix') . '</span>';
			$action .= '</button>';
      $action .= '</div>';
	   echo $action;
  endif;
 
}
function digix_wc_single_action_share()
{
  $post_id = get_the_id();
  Global $post;?>
<div class="action-item">
			<button class="product-share" data-toggle="modal" data-target="#share">
        <i class="icon-hare"></i>
        <span><?php echo __('product share','digix');?></span>
			</button>
      <div class="modal fade" id="share" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-md modal-dialog-centered" role="document">
          <div class="modal-content br-0">	  
          <!-- Modal Header -->
          <div class="modal-header">
            <h4 class="modal-title"><?php echo __( 'product share', 'digix' ); ?> <?php the_title(); ?></h4>
            <div type="button" class="close play_close" data-dismiss="modal"><i class="icon-close"></i></div>
          </div>	
          <!-- Modal body -->
          <div class="modal-body">
            <div class="flex w-100">
              <div class="col-lg-12 p-0">
                <div class="shortlink">
                  <span><i class="icon-link"></i><?php echo __( 'product short link:', 'digix' ); ?></span>
                  <textarea onclick="javascript:this.select();" readonly="readonly"><?php echo home_url()."/?p=".get_the_ID(); ?></textarea>
                </div>
                <div class="social-sharing">
                  <p><?php echo __( 'If this article was useful for you, share it', 'digix' ); ?></p>
                  <div class="lets-share">
                    <div class="social-btn text-center">
                      <div class="share-btn facebook">
                        <a class="facebook" href="https://www.facebook.com/sharer.php?u=<?php the_permalink();?>&t=<?php the_title(); ?>" target="_blank">
                          <i class="icon-facebook"></i>
                        </a>
                      </div>
                      <div class="share-btn twitter">
                        <a class="twitter" href="https://twitter.com/home?status=Reading: <?php the_permalink(); ?>" title="<?php echo __('share in twitter','digix'); ?>" target="_blank">
                          <i class="icon-twitter"></i>
                        </a>
                      </div>
                      <div class="share-btn pinterest">
                        <a class="pinterest" href="https://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php global $post; $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) ); echo $url; ?>" title="Pinterest" rel="nofollow" target="_blank">
                          <i class="icon-pinterest"></i>
                        </a>
                      </div>
                      <div class="share-btn telegram">
                        <a class="telegram" href="https://t.me/share/url?url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" title="share on Telegram" rel="nofollow" target="_blank">
                          <i class="icon-telegram"></i>
                        </a>
                      </div>
                      <div class="share-btn whatsapp">
                        <a class="whatsapp" href="whatsapp://send?text=<?php the_permalink(); ?>" data-action="share/whatsapp/share">
                          <i class="icon-whatsapp"></i>
                        </a>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          </div>
        </div>
		</div>
</div>
    <?php
}
function digix_wc_single_action_video()
{
  $post_id = get_the_id();
  $meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
  if( isset( $meta['video'] ) && !empty( $meta['video'] )):
      $action  = '<div class="action-item">';
			$action .= '<button class="product-video" data-toggle="modal" data-target="#video">';
      $action .= '<i class="icon-tiktok"></i>';
      $action .= '<span>' . __('product video','digix') . '</span>';
			$action .= '</button>';
      $action .= '<div class="modal fade" id="video" role="dialog" aria-hidden="true">';
      $action .= '<div class="modal-dialog modal-lg modal-dialog-centered">';
      $action .= '<div class="modal-content">';
      $action .= '<div class="modal-header">';
      $action .= '<h4 class="modal-title">' . __('Introduction video ','digix') . get_the_title() . '</h4>';
      $action .= '<div type="button" class="close play_close" data-dismiss="modal"><i class="icon-close"></i></div>';
      $action .= '</div>';
      $action .= '<div class="modal-body">';
      $action .= '<video controls class="play-video">';
      $action .= '<source src="' . $meta['video'] . '" type="video/mp4">';
      $action .= '</video>';
      $action .= '</div>';
      $action .= '</div>';
      $action .= '</div>';
			$action .= '</div>';
      $action .= '</div>';
  echo $action;
  endif;
}

add_action( 'digix_wc_single_action','digix_wc_single_action_pricechart', 10 );
add_action( 'digix_wc_single_action','digix_wc_single_action_share', 30 );
add_action( 'digix_wc_single_action','digix_wc_single_action_video', 40 );




#
##
# special icon on digix single action

function digix_wc_single_action_amazing()
{
  $regular_price 	= get_post_meta( get_the_id(), '_sale_price_dates_to', true );
  if(!empty($regular_price)) {
      $action  = '<div class="action-item">';
			$action .= '<button class="single-amazing">';
      $action .= '<i class="icon-lightning"></i>';
      $action .= '<span>' . __('This product is special','digix') . '</span>';
			$action .= '</button>';
      $action .= '</div>';
      echo $action;
  }
}
add_action( 'digix_wc_single_action','digix_wc_single_action_amazing', 50 );

#
##
# amazing icon on digix single action

function digix_wc_single_action_special()
{
  $active = get_post_meta( get_the_id(), 'digix_special_slider_active', true );
  if( !empty($active) ) {
      $action  = '<div class="action-item">';
			$action .= '<button class="single-special">';
      $action .= '<i class="icon-cup"></i>';
      $action .= '<span>' . __('This product is amazing','digix') . '</span>';
			$action .= '</button>';
      $action .= '</div>';
      echo $action;
  }
}
add_action( 'digix_wc_single_action','digix_wc_single_action_special', 60 );


#
##
# Change number of related products output

add_filter( 'woocommerce_output_related_products_args', function ( $args ) 
{
	$args['posts_per_page'] = 5; // 5 related products
	$args['columns'] = 5; // arranged in 5 columns
	return $args;
}, 20 );




#
##
# Woocommerce Variable Price Format

function digix_woocommerce_variable_price( $price, $product ) 
{

		$prices = array( $product->get_variation_price( 'min', true ), $product->get_variation_price( 'max', true ) );
		$price = $prices[0] !== $prices[1] ? sprintf( __( '%1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );

		$prices = array( $product->get_variation_regular_price( 'min', true ), $product->get_variation_regular_price( 'max', true ) );
		sort( $prices );
		$saleprice = $prices[0] !== $prices[1] ? sprintf( __( '%1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );
		if ( $price !== $saleprice ) 
    {
		  $price = '<del>' . $saleprice . '</del> <ins>' . $price . '</ins>';
		}
		return $price;
}
 
add_filter( 'woocommerce_variable_sale_price_html', 'digix_woocommerce_variable_price', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 'digix_woocommerce_variable_price', 10, 2 );

#
##
# digix woocommerce child category show in parent category

function digix_woocommerce_child_category()
{
  Global $options;
  if ( $options['woocommerce-childcat'] == 'yes' ):
    if (is_product_category()):
      $term = get_queried_object();
      $children = get_terms( $term->taxonomy, array(
        'parent'    => $term->term_id,
        'hide_empty' => false
      ) );
    $terms = get_terms([
          'taxonomy' => 'product_cat',
          'hide_empty' => false,
          'parent' => get_queried_object_id()
        ]);
    
    if ( $children ):

      $html =  '<section class="digix-child-procat">';
      $html .= '<header class="title-catchild">';
      $html .= '<h3>' . __('child category','digix') . '</h3>';
      $html .= '</header>';
      $html .= '<div class="childcat-list">';
        foreach( $terms as $term ){
          $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
          $html .= '<a href="' . esc_url(get_term_link($term, 'product_cat')) . '" class="childcat-item">';
          $html .= '<em>' .$term->count. '</em>';
          $html .= '<figure class="childcat-img">';
          if ($thumbnail_id){
              $html .= wp_get_attachment_image($thumbnail_id, array(80,80), false, ['class' => 'img-fluid']);
            }
            else{
              $html .=  wc_placeholder_img();
            }
            $html .= '</figure>';

            $html .= '<div class="childcat-title">'.$term->name.'</div>';

            $html .= '</a>';

        }

        $html .= '</div></section>';
        echo $html;
      endif;
    endif;
  endif;
}
add_action('woocommerce_before_main_content','digix_woocommerce_child_category',50);

#
##
# product loop start

function digix_product_loop_start()
{
  echo'<section class="im-product woocommerce-archive">';
}
add_action('woocommerce_product_loop_start','digix_product_loop_start',1);


#
##
# product loop end

function digix_product_loop_end()
{
  echo'</section>';
}
add_action('woocommerce_product_loop_end','digix_product_loop_end',1);



#
##
# Woocommerce Discount 
 
function digix_wooocmmerce_discount ($id)
{
  $product = wc_get_product( $id );
  if($product->is_on_sale()){
	  if($product->is_type( 'variable' ))
	  {
		  $regular_price = $product->get_variation_regular_price( 'min' );
		  $sale_price = $product->get_variation_sale_price( 'min' );
	  } 
	  else 
	  {
		  $regular_price = $product->get_regular_price();
		  $sale_price = $product->get_sale_price();
	  }

	  $insale_price = (int)$regular_price - (int)$sale_price;
	  $discount_price = round(($insale_price/$regular_price)*100);
	  return $discount_price;
  }
}


#
##
# WooCommerce Compatibility Functions

function get_gallery_image_ids( $product ) {
	if ( ! is_a( $product, 'WC_Product' ) ) {
		return;
	}

	if ( is_callable( 'WC_Product::get_gallery_image_ids' ) ) {
		return $product->get_gallery_image_ids();
	} else {
		return $product->get_gallery_image_ids();
	}
}


#
##
# WooCommerce Product Image Flipper

function digix_woocommerce_product_has_gallery( $classes ) {
	global $product;

	$post_type = get_post_type( get_the_ID() );

	if ( ! is_admin() ) {

		if ( $post_type == 'product' ) {

			$attachment_ids = get_gallery_image_ids( $product );

			if ( $attachment_ids ) {
				$classes[] = 'im-second-gallery';
			}
		}
	}

	return $classes;
}
add_filter( 'post_class',  'digix_woocommerce_product_has_gallery'  );


function digix_woocommerce_second_product_thumbnail() {
	global $product, $woocommerce;

	$attachment_ids = get_gallery_image_ids( $product );

	if ( $attachment_ids ) {
		$attachment_ids     = array_values( $attachment_ids );
		$secondary_image_id = $attachment_ids['0'];

		$secondary_image_alt = get_post_meta( $secondary_image_id, '_wp_attachment_image_alt', true );
		$secondary_image_title = get_the_title($secondary_image_id);

		echo wp_get_attachment_image(
			$secondary_image_id,
			'shop_catalog',
			'',
			array(
				'class' => 'secondary-image attachment-shop-catalog wp-post-image gallery-secondary',
				'alt' => $secondary_image_alt,
				
			)
		);
	}
}
function digix_second_thumbnail($array) {
	global $product, $woocommerce;

	$attachment_ids = get_gallery_image_ids( $product );

	if ( $attachment_ids ) {
		$attachment_ids     = array_values( $attachment_ids );
		$secondary_image_id = $attachment_ids['0'];

		$secondary_image_alt = get_post_meta( $secondary_image_id, '_wp_attachment_image_alt', true );
		$secondary_image_title = get_the_title($secondary_image_id);

		echo wp_get_attachment_image(
			$secondary_image_id,
			$array,
			'',
			array(
				'class' => 'secondary-image attachment-shop-catalog wp-post-image gallery-secondary',
				'alt' => $secondary_image_alt,
				
			)
		);
	}
}
add_action( 'woocommerce_before_shop_loop_item_title','digix_woocommerce_second_product_thumbnail', 11 );
add_action( 'wc_secondary_thumbnails','digix_woocommerce_second_product_thumbnail', 11 );


#
##
# Woocommerce Myaccount Options

function digix_myaccount_dasboard_information()
{?>
<section class="myaccount-detailes">
	<div class="detailes-panel">
	
		<div class="detailes-item">
		
			<div class="detailes-icon">
			
				<i class="icon-clock"></i>
			
			</div>
			
			<div class="detailes-body">
			
				<h6><?php echo __('Your Membership','digix');?></h6>
				<div>
				
					<?php
						$user = wp_get_current_user();
						$udata = get_userdata( $user->ID );
						$registered = $udata->user_registered;
						date_default_timezone_set("Asia/Tehran");
						$now = time()-3600;
						$in = strtotime($registered)+12600;
						echo '<span>' . human_time_diff( $in, $now) . ' ' . __('ago','digix') . '</span>'; 
					?>
					
				</div>
			
			</div>
		
		</div>
		
		<div class="detailes-item">
		
			<div class="detailes-icon">
			
				<i class="icon-audit"></i>
			
			</div>
			
			<div class="detailes-body">
			
				<h6><?php echo __('Total orders','digix');?></h6>
				<div>
				
					<?php
						$user_id = get_current_user_id();
						$iranwp_total_paid = wc_get_customer_total_spent( $user_id ) - '0.00';
						echo '<span>' . $iranwp_total_paid . ' ' . __('Tooman','digix') . '</span>';
					?>
					
				</div>
			
			</div>
		
		</div>
		
		<div class="detailes-item">
		
			<div class="detailes-icon">
			
				<i class="icon-chat"></i>
			
			</div>
			
			<div class="detailes-body">
			
				<h6><?php echo __('Your Comments','digix');?></h6>
				<div>
				
					<?php
						global $wpdb, $post, $current_user;
						$userId = $current_user->ID;
						$where = 'WHERE comment_approved = 1 AND user_id = ' . $userId ;
						$comment_count = $wpdb->get_var("SELECT COUNT( * ) AS total 
						FROM {$wpdb->comments}
						{$where}");
						echo '<span>' . $comment_count . ' ' . __('comment','digix') . '</span>';
					?>
					
				</div>
			
			</div>
		
		</div>
		
		<div class="detailes-item">
		
			<div class="detailes-icon">
			
				<i class="icon-app-store"></i>
			
			</div>
			
			<div class="detailes-body">
			
				<h6><?php echo __('Total purchase','digix');?></h6>
				<div>
					<?php
						$user_id = get_current_user_id();
						$order_count = wc_get_customer_order_count($user_id);
						echo $order_count;
					?>
				</div>
			
			</div>
		
		</div>
	
	
	</div>
	
</section>
<?php	
}




#
##
# User Information And Detailes ON My Account

function digix_myaccount_user_detaile()
{ 
$current_user = wp_get_current_user();
?>
	
	<section class="user-info">
    <?php if ( empty($current_user->user_email) || empty($current_user->user_firstname) || empty($current_user->user_lastname) ) : ?>
      <div class="user-Authentication">
        <p class="Authentication-desc">
            <i class="icon-alert"></i>
            <?php echo '<b>' . $current_user->display_name . '</b> ' . __('To increase the security of your account and prevent misuse, please confirm your identity','digix');?>

        </p>
        <div class="Authentication-more">
          <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'edit-account' ) ); ?>"><span><?php echo __('Account information','digix'); ?></span>
            <i class="icon-arrow-left"></i>
          </a>
        </div>
      </div>
    <?php endif; ?>
		<div class="user-detailes">
		
			<div class="user-detailes-item">
				
				<i class="icon-user"></i>
				
				<span><?php echo $current_user->user_firstname . "  " . $current_user->user_lastname; ?></span>
			
			</div>
			
			<div class="user-detailes-item">
				
				<i class="icon-growth"></i>
				
				<span><?php echo $current_user->user_login; ?></span>
			
			</div>
			
			<div class="user-detailes-item">
				
				<i class="icon-mobile"></i>
				
				<span><?php echo $current_user->billing_phone; ?></span>
			
			</div>
			
			<div class="user-detailes-item">
				
				<i class="icon-mail"></i>
				
				<span><?php echo $current_user->user_email; ?></span>
			</div>
		
		</div>
	
	</section>

  


<?php	
}


#
##
# Woocommerce User Order

function digix_myaccount_user_order()
{ 
  $current_user_id    = get_current_user_id();
  $on_hold_orders     = wc_get_orders( array( 'status' => array( 'wc-on-hold' ), 'customer_id' => $current_user_id ) );
  $processing_orders  = wc_get_orders( array( 'status' => array( 'wc-processing' ), 'customer_id' => $current_user_id ) );
  $completed_orders   = wc_get_orders( array( 'status' => array( 'wc-completed' ), 'customer_id' => $current_user_id ) );
  $pending_orders     = wc_get_orders( array( 'status' => array( 'wc-pending' ), 'customer_id' => $current_user_id ) );
  $canceled_orders    = wc_get_orders( array( 'status' => array( 'wc-cancelled' ), 'customer_id' => $current_user_id ) ); 
  ?>
    <section class="myaccount-order">
        <div class="order-status">
            <header class="order-header">
                <h3><?php echo __('My orders','digix');?></h3>
                <a href="<?php echo esc_url( trailingslashit( wc_get_account_endpoint_url( 'orders' ) ) ); ?>">
                    <?php echo __('view all','digix');?>
                </a>
            </header>
            <div class="order-content">
                <div class="order-item">
                  <img src="<?php echo DIGIX_IMG . 'pending-order.svg';?>" alt="order-pending" class="img-fluid">
                  <div class="order-information">
                        <div class="total"><?php echo count($pending_orders) . ' ' . __('order','digix'); ?></div>
                        <div class="name"><?php echo __('Pending','digix'); ?></div>
                  </div>
                </div>
                <div class="order-item">
                  <img src="<?php echo DIGIX_IMG . 'processing-order.svg';?>" alt="order-processing" class="img-fluid">
                  <div class="order-information">
                        <div class="total"><?php echo count($processing_orders) . ' ' . __('order','digix'); ?></div>
                        <div class="name"><?php echo __('Processing','digix'); ?></div>
                  </div>
                </div>
                <div class="order-item">
                  <img src="<?php echo DIGIX_IMG . 'delivered-order.svg';?>" alt="order-delivered" class="img-fluid">
                  <div class="order-information">
                        <div class="total"><?php echo count($completed_orders) . ' ' . __('order','digix'); ?></div>
                        <div class="name"><?php echo __('Delivered','digix'); ?></div>
                  </div>
                </div>
                <div class="order-item">
                  <img src="<?php echo DIGIX_IMG . 'cancelled-order.svg';?>" alt="order-canlcelled" class="img-fluid">
                  <div class="order-information">
                        <div class="total"><?php echo count($canceled_orders) . ' ' . __('order','digix'); ?></div>
                        <div class="name"><?php echo __('Cancelled','digix'); ?></div>
                  </div>
                </div>
            </div>
        </div>
        <div class="order-chart">
            <header class="order-header">
                <h3><?php echo __('Order report','digix');?></h3>
            </header>
            <div class="order-content">
              <div class="chart">
                <canvas id="OrderChart"></canvas>
              </div>
            </div>
        </div>
    </section>
<?php
}


#
##
# User Information And Detailes ON My Account

function digix_woocommerce_myaccount()
{
	
	$current_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	$myaccount_url = esc_url(get_permalink( get_option('woocommerce_myaccount_page_id')));
	
	if(is_user_logged_in() && $myaccount_url == $current_url)
	{
		add_action('woocommerce_after_account_navigation','digix_myaccount_dasboard_information', 5);
		add_action('woocommerce_after_account_navigation','digix_myaccount_user_detaile', 10);
    add_action('woocommerce_after_account_navigation','digix_myaccount_user_order', 15);
	}
}
add_action('init','digix_woocommerce_myaccount');



#
##
# Display the mobile phone field

function add_billing_phone_to_edit_account_form() 
{
	$user = wp_get_current_user();
?>
	<p class="woocommerce-form-row woocommerce-form-row–wide form-row form-row-wide">
	
	<label for="billing_phone"><?php echo __('phone number','digix'); ?> <span class="required">*</span></label>
	
	<input type="text" class="woocommerce-Input woocommerce-Input–phone input-text" name="billing_phone" id="billing_phone" value="<?php echo esc_attr( $user->billing_phone ); ?>" />
	
	</p>
<?php
}
add_action( 'woocommerce_edit_account_form', 'add_billing_phone_to_edit_account_form' ); // After existing fields




#
##
# Check and validate the mobile phone

function billing_phone_field_validation( $args )
{
	if ( !isset($_POST['billing_phone']) && empty($_POST['billing_phone']) )
	$args->add( 'error', __( 'Please fill in your Mobile phone', 'woocommerce' ),”);
}
add_action( 'woocommerce_save_account_details_errors','billing_phone_field_validation', 20, 1 );



#
##
# Save the mobile phone value to user data

function my_account_saving_billing_phone( $user_id ) 
{
	if( isset($_POST['billing_phone']) && ! empty($_POST['billing_phone']) )
	update_user_meta( $user_id, 'billing_phone', sanitize_text_field($_POST['billing_phone']) );
}
add_action( 'woocommerce_save_account_details', 'my_account_saving_billing_phone', 20, 1 );




#
##
# User Comment On Myaccount Page

 add_filter('woocommerce_account_menu_items', 'comment_account_menu', 5, 1);
 add_action('init', 'add_comment_endpoint');
 add_action('woocommerce_account_comment_endpoint', 'comment_endpoint_content');
 
 
 
 function comment_account_menu($items) {
         $logout = null;
         if (isset($items['customer-logout'])) {
             $logout = $items['customer-logout'];
         }
         unset($items['customer-logout']);
         $items['comment'] = __('Your Comment','digix');
         if ($logout) {
             $items['customer-logout'] = $logout;
         }
 
         return $items;
     }
 
 function add_comment_endpoint() {
         add_rewrite_endpoint('comment', EP_PAGES);
         flush_rewrite_rules();
     }
 
 function comment_endpoint_content() {
         $args = array(
             'user_id' => get_current_user_id(),
         );
         $comments = get_comments($args);
         if (count($comments)) {
             echo '<div class="comment-posted"><b>' . __('All Comments you have posted','digix') . '</b></div><div class="digix-wc-comment">';
             foreach ($comments as $comment) {
                 $post = get_post($comment->comment_post_ID);
 
                 if (get_post_status($post) != 'publish') {
                     continue;
                 }
                 $rating = get_comment_meta($comment->comment_ID, 'rating', true);
 
                 ?>
                 <figure class="comment-item">
                    <div class="comment-thumbnail">
                        <?php
                        echo get_the_post_thumbnail($post->ID, 'woocommerce_thumbnail', ['class' => 'img-fluid']);
                        ?>
                    </div>
                    <div class="comment-detailes">
                        <header class="comment-title">
                            <h3><a href="<?php echo get_the_permalink($post->ID); ?>"><?php echo limit_words(get_the_title($post->ID), '8').' ...'; ?></a></h3>
                        </header>
                        <div class="your-comment"><?php echo limit_words($comment->comment_content, '15').' ...'; ?></div>
                        <?php
                          if ($rating) {
                              echo '<div class="comment-rate">' . __('Your Rate','digix') . '<div class="rating-star">'. wc_get_rating_html($rating, 1) . '</div></div>';
                          }
                        ?>
                    </div>
                 </figure>
                 <?php
             }
             echo '</div>';
         } else {
             echo '<div class="woocommerce-Message woocommerce-Message--info woocommerce-info">' . esc_html__('No comments found','digix') . '</div>';
         }
     }

     
	
	
#
##
#Order Tracker For My account

add_filter('woocommerce_account_menu_items', 'tracking_account_menu', 1, 2);
add_action('init', 'add_tracking_endpoint');
add_action('woocommerce_account_tracking_endpoint', 'tracking_endpoint_content');



function tracking_account_menu($items) {
        $logout = null;
        if (isset($items['customer-logout'])) {
            $logout = $items['customer-logout'];
        }
        unset($items['customer-logout']);
        $items['tracking'] = __('tracking','digix');
        if ($logout) {
            $items['customer-logout'] = $logout;
        }

        return $items;
    }

function add_tracking_endpoint() {
        add_rewrite_endpoint('tracking', EP_PAGES);
        flush_rewrite_rules();
    }

function tracking_endpoint_content() {?>
  <section class="order-tracking-container">
			<div class="digix-tracking">
				<!-- Pre Loader-->
				<div class="digix_result_preload_area">
					<div class="digix_result_preload">
						<div></div><div></div><div></div>
					</div>
				</div><!--/ Pre Loader-->
				
				<!-- Show All Output-->
				<div class="digix-traking-form-result"></div><!--/ Show All Output-->
					<!--Tracking Form -->
          <div class="digix-tracking-from">
					<form method="POST">
						<div class="digix-tracking-form-area">
							<div class="digix-tracking-form-field inp">
								<input type="text" id="order_number" name="order_number" placeholder="کد رهگیری سفارش">
							</div>
							<!--<div class="digix-tracking-form-field">
								<input type="text" id="phone" name="phone_number" placeholder="شماره تماس"> 
							</div>-->
							<div class="digix-tracking-form-field digix-traking-form-submit">
								<?php wp_nonce_field('digix_nonce_data'); ?>							
								<input type="submit" value="رهگیری سفارش">
							</div>	
						</div>					
					</form>
				</div><!--/ Tracking Form -->
			</div>
  </section>
	<?php
}



/**
	* Register new status ( warehouse )
**/

if( $options['woocommerce-shipping-warehouse'] == '1' ){
	function register_mk_warehouse_order_status() {
		register_post_status( 'wc-mk-warehouse', array(
			'label'                     => 'تحویل به انبار',
			'public'                    => true,
			'exclude_from_search'       => false,
			'show_in_admin_all_list'    => true,
			'show_in_admin_status_list' => true,
			'label_count'               => _n_noop( 'تحویل به انبار (%s)', 'تحویل به انبار (%s)' )
		) );
	}
	add_action( 'init', 'register_mk_warehouse_order_status' );



	// Add to list of WC Order statuses
	function add_mk_warehouse_to_order_statuses( $order_statuses ) {
	 
		$new_order_statuses = array();
	 
		// add new order status after processing
		foreach ( $order_statuses as $key => $status ) {
	 
			$new_order_statuses[ $key ] = $status;
	 
			if ( 'wc-processing' === $key ) {
				$new_order_statuses['wc-mk-warehouse'] = 'تحویل به انبار';
			}
		}
	 
		return $new_order_statuses;
	}
	add_filter( 'wc_order_statuses', 'add_mk_warehouse_to_order_statuses' );
}



/**
	* Register new status ( packing )
**/

if( $options['woocommerce-shipping-packing'] == '1' ){
	function register_mk_packing_order_status() {
		register_post_status( 'wc-mk-packing', array(
			'label'                     => 'بسته بندی شده',
			'public'                    => true,
			'exclude_from_search'       => false,
			'show_in_admin_all_list'    => true,
			'show_in_admin_status_list' => true,
			'label_count'               => _n_noop( 'بسته بندی شده (%s)', 'بسته بندی شده (%s)' )
		) );
	}
	add_action( 'init', 'register_mk_packing_order_status' );



	// Add to list of WC Order statuses
	function add_mk_packing_to_order_statuses( $order_statuses ) {
	 
		$new_order_statuses = array();
	 
		// add new order status after processing
		foreach ( $order_statuses as $key => $status ) {
	 
			$new_order_statuses[ $key ] = $status;
	 
			if ( 'wc-processing' === $key ) {
				$new_order_statuses['wc-mk-packing'] = 'بسته بندی شده';
			}
		}
	 
		return $new_order_statuses;
	}
	add_filter( 'wc_order_statuses', 'add_mk_packing_to_order_statuses' );
}



/**
	* Register new status ( ready )
**/

if( $options['woocommerce-shipping-ready'] == '1' ){
	function register_mk_ready_order_status() {
		register_post_status( 'wc-mk-ready', array(
			'label'                     => 'آماده ارسال',
			'public'                    => true,
			'exclude_from_search'       => false,
			'show_in_admin_all_list'    => true,
			'show_in_admin_status_list' => true,
			'label_count'               => _n_noop( 'آماده ارسال (%s)', 'آماده ارسال (%s)' )
		) );
	}
	add_action( 'init', 'register_mk_ready_order_status' );



	// Add to list of WC Order statuses
	function add_mk_ready_to_order_statuses( $order_statuses ) {
	 
		$new_order_statuses = array();
	 
		// add new order status after processing
		foreach ( $order_statuses as $key => $status ) {
	 
			$new_order_statuses[ $key ] = $status;
	 
			if ( 'wc-processing' === $key ) {
				$new_order_statuses['wc-mk-ready'] = 'آماده ارسال';
			}
		}
	 
		return $new_order_statuses;
	}
	add_filter( 'wc_order_statuses', 'add_mk_ready_to_order_statuses' );
}



#
##
# wishlist

add_filter( 'woocommerce_account_menu_items', 'iranwp_account_menu_favorites', 10, 1 );
	function iranwp_account_menu_favorites( $items ) {
		$logout = $items['customer-logout'];
		unset( $items['customer-logout'] );
		$items['favorites']       = __('Favorites','digix');
		$items['customer-logout'] = $logout;

		return $items;
	}
	add_action( 'init', 'iranwp_add_favorites_endpoint' );
	function iranwp_add_favorites_endpoint() {
		add_rewrite_endpoint( 'favorites', EP_PAGES );
		flush_rewrite_rules();
	}
	add_action( 'woocommerce_account_favorites_endpoint', 'iranwp_favorites_endpoint_content' );
	function iranwp_favorites_endpoint_content() {
		echo do_shortcode('[iranwp_wishlist]');
	}


	
#
##	
# Product Attributes On Special Element

function digix_woocommerce_attributes($product)
{
  $attributes = $product->get_attributes();
  if ( $attributes && is_array( $attributes ) ) 
  {
    if ( count( $attributes ) ) 
    {
      $i = 0;
      foreach ( $attributes as $attribute ) 
      {
        echo '<li><span class="attributes-label">' . wc_attribute_label( $attribute->get_name() ) . ': </span>';
        $values = array();
        if ( $attribute->is_taxonomy() ) 
        {
          $attribute_taxonomy = $attribute->get_taxonomy_object();
          $attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );
          foreach ( $attribute_values as $attribute_value )
          {
            $value_name = esc_html( $attribute_value->name );

            if ( $attribute_taxonomy->attribute_public ) 
            {
              $values[] = '<span class="attributes-label">' . $value_name . '</span>';
            } else {
              $values[] = $value_name;
            }
          }
        } else {
          $values = $attribute->get_options();

          foreach ( $values as &$value ) 
          {
            $value = make_clickable( esc_html( $value ) );
          }
        }
        echo apply_filters( 'woocommerce_attribute', wptexturize( implode( ', ', $values ) ), $attribute, $values );
        echo '</li>';
        $i ++;
        if ( $i > 3 ) {
          break;
        }
      } // End foreach
    }
  }
}

# Add Product Excerpt To Description Tab

function digix_wooocommerce_single_excerpt($content) 
{
  global $post;
  $post_id = get_the_id();
  $post_type = $post->post_type;
  if ($post_type == 'product') 
  {
    $expert = $post->post_excerpt;
    if ($expert) 
    {
      $expert_html = '
      <figure class="im-product-description woocommerce-product-details__short-description">
        <h2><div>' .  __( "Overview", "digix" ) . '</div><strong>' .  $post->post_title . '</strong></h2>
        <figcaption>
        <span class="icon-pen"></span>
          ' . apply_filters('woocommerce_short_description', $expert) . '
        </figcaption>
      </figure>';
      return $expert_html . $content;
    }
  }
	return $content;
}
add_filter('the_content', 'digix_wooocommerce_single_excerpt');


# Add delivery Method And Warranty

function digix_woocommerce_delivery(){
	$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
  Global $options;
  if(!empty($options['woocommerce-delivery-gurantee']) || !empty($options['woocommerce-delivery-method'])){
	  echo '<section class="im-delivery-wrranty">';
	if(!empty($options['woocommerce-delivery-gurantee'])){  echo '<div class="im-wrranty"><span class="icon-shield-check"></span><span>' . $options['woocommerce-delivery-gurantee'] . '</span></div>';}
	if(!empty($options['woocommerce-delivery-method'])){  echo '<div class="im-delivery"><span class="icon-express-delivery"></span><span>' . $options['woocommerce-delivery-method'] . '</span></div>';}
	  echo '</section>';
  }
  if( !empty($options['woocommerce-delivery-home']) || !empty($options['woocommerce-delivery-other'])){
  echo '<section class="delivery-time"><span>'. $options['woocommerce-delivery-home'] . '</span><span>'. $options['woocommerce-delivery-other'] . '</span></section>';
  }
  if(! empty($meta['customer-free-switcher'])){
	  if($meta['customer-free-switcher'] == true){
		echo'<div class="ShippingCondition">';
			echo'<ul class="list">';
				foreach($meta['customer-free'] as $item){
					$img = ! empty( $item['pic'] ) ? '<img src="' . $item['pic'] . '" class="img-fluid" width="20" height="20">' : '';
					echo'<li class="item">' . $img . '<span class="label">' . $item['label'] . '</span> <span class="value">' . $item['value'] . '</span></li>';
				}
			echo'</ul>';
		echo'</div>';
	  }
  }
}


#
##
# Remove shipping tab

function digix_remove_tab( $tabs ) {
  unset( $tabs['shipping'] );
  unset( $tabs['seller'] );
  return $tabs;
}
add_filter( 'woocommerce_product_tabs', 'digix_remove_tab', 11 );



 
if ( class_exists( 'WeDevs_Dokan' ) ){
if ( class_exists( 'Dokan_Single_Product_Multi_Vendor' ) ) {

#
##
# Check already cloned this product

function check_already_cloned( $product_id ) {
      global $wpdb;

      $map_id = get_post_meta( $product_id, '_has_multi_vendor', true );
      $user_id = get_current_user_id();

      if ( empty( $map_id ) ) {
          return false;
      }

      $sql     = "SELECT * FROM `{$wpdb->prefix}dokan_product_map` WHERE `map_id`= '$map_id' AND `seller_id` = '$user_id' AND `is_trash` IN (0,2,3)";
      $results = $wpdb->get_row( $sql );

      if ( $results ) {
          return true;
      }

      return false;
}  

#
##
# Check is seller is elligible for sell this item

function is_valid_user( $product_id ) {
    if ( ! is_user_logged_in() ) {
        return false;
    }

    $user_id = get_current_user_id();

    if ( ! dokan_is_user_seller( $user_id ) ) {
        return false;
    }

    // Check if the vendor can create new product based on the active subscription
    if ( ! dokan_spmv_can_vendor_create_new_product( $user_id ) ) {
        return false;
    }

    $product_author = get_post_field( 'post_author', $product_id );

    if ( $user_id == $product_author ) {
        return false;
    }

    if ( check_already_cloned( $product_id ) ) {
        return false;
    }

    return true;
}

#
##
# Added Sell This Item Btn

function digix_dokan_new_seller() {
  global $product;

  if ( $product->get_type() == 'product_pack' ) {
      return;
  }

  if ( ! is_valid_user( $product->get_id() ) ) {
      return;
  }
  ?>
  <form method="post" class="dokan-new-seller">
      <?php wp_nonce_field( 'dokan-sell-item-action', 'dokan-sell-item-nonce' ); ?>
      <p><?php echo __('Do you intend to sell this product?','digix'); ?></p>
      <button name="dokan_sell_this_item" class="dokan-btn dokan-btn-theme digix-sell-new"><?php echo __( 'Sell This Item', 'digix' ); ?></button>
      <input type="hidden" name="product_id" value="<?php echo $product->get_id(); ?>">
      <input type="hidden" name="user_id" value="<?php echo get_current_user_id(); ?>">
  </form>
  <?php
}
add_action('digix_dokan_new_seller','digix_dokan_new_seller'); 

}


#
##
# Set More Product From Seller

function digix_set_more_from_seller_tab( $tabs ) {
  if ( check_more_seller_product_tab() ) {
      $tabs['more_seller_product'] = [
          'title'    => __( 'More Products', 'digix' ),
          'priority' => 99,
          'callback' => 'digix_get_more_products_from_seller',
      ];
  }

  return $tabs;
}
remove_action( 'woocommerce_product_tabs', 'dokan_set_more_from_seller_tab', 10 );
add_action( 'woocommerce_product_tabs', 'digix_set_more_from_seller_tab', 10 );

#
##
# Get More Product From Seller

function digix_get_more_products_from_seller( $seller_id = 0, $posts_per_page = 6 ) {
  global $product, $post;

  if ( $seller_id === 0 || 'more_seller_product' === $seller_id ) {
      $seller_id = $post->post_author;
  }

  if ( ! is_int( $posts_per_page ) ) {
      $posts_per_page = apply_filters( 'dokan_get_more_products_per_page', 6 );
  }

  $args = [
      'post_type'      => 'product',
      'posts_per_page' => $posts_per_page,
      'orderby'        => 'rand',
      'post__not_in'   => [ $post->ID ],
      'author'         => $seller_id,
  ];

  $products = new WP_Query( $args );

  if ( $products->have_posts() ) { ?>
      <section class="related im-product products">
        <div dir="rtl" class="swiper-container im-swiper-product">
            <div class="swiper-wrapper">
      <?php
      while ( $products->have_posts() ) {
          $products->the_post();
          echo'<div class="swiper-slide">';
          wc_get_template_part( 'content', 'product' );
          echo'</div>';
      } ?>

            </div>	
        </div>
 <?php
  } else {
      esc_html_e( 'No product has been found!', 'dokan-lite' );
  }
    echo'</section>';
  wp_reset_postdata();
}
}

#
##
# Redirect User After Register

function filter_woocommerce_registration_redirect( $redirect ) {
  $login = get_permalink( get_option('woocommerce_myaccount_page_id') );
  return $login;
}
add_filter( 'woocommerce_registration_redirect', 'filter_woocommerce_registration_redirect', 10, 1 );



# Retrieve product sale percentage

function digix_woocommerce_get_sale_percentage( $product ) 
{
  $max_percentage = 0;
  if ( $product->is_on_sale() ) 
  {
    if ( ! $product->is_type( 'variable' ) ) 
    {
      $max_percentage = ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100;
    } else {
      foreach ( $product->get_children() as $child_id ) 
      {
        $variation = wc_get_product( $child_id );
        $price = $variation->get_regular_price();
        $sale = $variation->get_sale_price();
        
        $percentage = 0;
        if ( $price != 0 && ! empty( $sale ) ) 
        {
          $percentage = ( $price - $sale ) / $price * 100;
        }
        if ( $percentage > $max_percentage ) 
        {
          $max_percentage = $percentage;
        }
      }
    }
  }
  return round( $max_percentage );
}
function digix_woocommerce_single_price_html( $price, $product ) 
{
  $html = $price;
  if ( ! is_admin() && is_single() && is_product() ) 
  {
    $discount = '';
    $regular_price = $product->is_type( 'variable' ) ? $product->get_variation_regular_price( 'min', true ) : $product->get_regular_price();
    $sale_price = $product->is_type( 'variable' ) ? $product->get_variation_sale_price( 'min', true ) : $product->get_sale_price();
    
    if ( $regular_price && $sale_price )
    {
      $discount_percent = round( digix_woocommerce_get_sale_percentage( $product ) );
      $discount = '<span class="price-discount"><span>' . $discount_percent . ' <i class="icon-discount-symbol"></i></span></span>';
    }
    if ( $product->is_on_sale() )
    {
      $html = str_replace( '</ins>', '</ins>' . $discount, $html );
    }
  }
  return $html;
}
  
add_filter( 'woocommerce_get_price_html', 'digix_woocommerce_single_price_html', 100, 2 );


#
##
# Digix woocommerce Brands

function wc_brands_init()
{

	require_once IM_DIR . '/includes/brand/class-wc-brands.php';

	if ( is_admin() ) {
		require_once IM_DIR . '/includes/brand/class-wc-brands-admin.php';
	}

	require_once IM_DIR . '/includes/brand/wc-brands-functions.php';
}

add_action( 'after_setup_theme', 'wc_brands_init', 1 );


function wc_brands_activate() 
{
	if ( class_exists( 'WooCommerce' ) ) {
		require_once IM_DIR . '/includes/brand/class-wc-brands.php';
		WC_Brands::init_taxonomy();
	}
}

add_action( 'after_setup_theme', 'wc_brands_activate', 10 );



#
##
# ADD new calog ordering and result count

function digix_woocommrece_merge_catelog_result()
{
  if ( ! wc_get_loop_prop( 'is_paginated' ) || ! woocommerce_products_will_display() ) {
		return;
	}
  echo'<section class="wc-archive-detail">';
    $show_default_orderby    = 'menu_order' === apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', 'menu_order' ) );
    $catalog_orderby_options = apply_filters(
      'woocommerce_catalog_orderby',
      array(
        'menu_order' => __( 'Default sorting', 'woocommerce' ),
        'popularity' => __( 'Sort by popularity', 'woocommerce' ),
        'rating'     => __( 'Sort by average rating', 'woocommerce' ),
        'date'       => __( 'Sort by latest', 'woocommerce' ),
        'price'      => __( 'Sort by price: low to high', 'woocommerce' ),
        'price-desc' => __( 'Sort by price: high to low', 'woocommerce' ),
      )
    );

    $default_orderby = wc_get_loop_prop( 'is_search' ) ? 'relevance' : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', '' ) );
    // phpcs:disable WordPress.Security.NonceVerification.Recommended
    $orderby = isset( $_GET['orderby'] ) ? wc_clean( wp_unslash( $_GET['orderby'] ) ) : $default_orderby;
    // phpcs:enable WordPress.Security.NonceVerification.Recommended

    if ( wc_get_loop_prop( 'is_search' ) ) {
      $catalog_orderby_options = array_merge( array( 'relevance' => __( 'Relevance', 'woocommerce' ) ), $catalog_orderby_options );

      unset( $catalog_orderby_options['menu_order'] );
    }

    if ( ! $show_default_orderby ) {
      unset( $catalog_orderby_options['menu_order'] );
    }

    if ( ! wc_review_ratings_enabled() ) {
      unset( $catalog_orderby_options['rating'] );
    }

    if ( ! array_key_exists( $orderby, $catalog_orderby_options ) ) {
      $orderby = current( array_keys( $catalog_orderby_options ) );
    }?>

    <form class="woocommerce-ordering" method="get" style="display:none;">
      <select name="orderby" class="orderby">
        <?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
          <option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
        <?php endforeach; ?>
      </select>
      <input type="hidden" name="paged" value="1" />
      <?php wc_query_string_form_fields( null, array( 'orderby', 'submit', 'paged', 'product-page' ) ); ?>
    </form>
    <div class="wc-ordering">
      <ul class="catelog-list">
            <i class="icon-spreadsheet-app"></i>
            <span><?php echo __('sort by:','digix');?></span>
            
            
            <?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
          <?php
          $link = remove_query_arg( 'orderby' );
          $link = add_query_arg( array( 'orderby' => $id ), $link );
          $name = str_replace( 'Sort by ', '', esc_html( $name ) );
          $name = str_replace( 'Sort', '', esc_html( $name ) );
          $name = str_replace( '', '', esc_html( $name ) );
          $link = add_query_arg( array( 'orderby' => $id ), $link );
          $name = str_replace( 'سازی', '', esc_html( $name ) );
          $name = str_replace( 'بر', '', esc_html( $name ) );
          $name = str_replace( 'اساس', '', esc_html( $name ) );
          $name = str_replace( 'مرتب', '', esc_html( $name ) );
          $name = str_replace( '', '', esc_html( $name ) );
          ?>
            <li class="list-inline-item <?php echo $orderby == $id ? 'active' : ''; ?>">
                <a href="<?php echo $link; ?>" class="<?php echo $orderby == $id ? 'active' : ''; ?>" rel="nofollow"><?php echo $name; ?></a>
            </li>
          <?php endforeach; ?>
      </ul>
    </div>
        <?php
      array(
        'catalog_orderby_options' => $catalog_orderby_options,
        'orderby'                 => $orderby,
        'show_default_orderby'    => $show_default_orderby,
      );
      $total =  wc_get_loop_prop( 'total' );
      $per_page = wc_get_loop_prop( 'per_page' );
      $current = wc_get_loop_prop( 'current_page' );

    echo'<p class="woocommerce-result-count">';

      // phpcs:disable WordPress.Security
      if ( 1 === intval( $total ) ) {
        _e( 'Showing the single result', 'woocommerce' );
      } elseif ( $total <= $per_page || -1 === $per_page ) {
        /* translators: %d: total results */
        printf( _n( 'Showing all %d result', 'Showing all %d results', $total, 'woocommerce' ), $total );
      } else {
        $first = ( $per_page * $current ) - $per_page + 1;
        $last  = min( $total, $per_page * $current );
        /* translators: 1: first result 2: last result 3: total results */
        printf( _nx( 'Showing %1$d&ndash;%2$d of %3$d result', 'Showing %1$d&ndash;%2$d of %3$d results', $total, 'with first and last result', 'woocommerce' ), $first, $last, $total );
      }
      // phpcs:enable WordPress.Security
      
    echo'</p>';
  echo'</section>';
}

if( class_exists('WPCleverWpcvs') ){
	#
	##
	#  Remove Advancedd Variation Wpc
	$class= WPCleverWpcvs::instance();
	remove_filter( 'woocommerce_dropdown_variation_attribute_options_html', [ $class, 'variation_attribute_options_html' ], 199, 2 );


	#
	##
	#  Digix Advancedd Variation 

	function dx_variation_attribute_options_html( $options_html, $args ) {
		$class= WPCleverWpcvs::instance();
		$options    = $args['options'];
		$product    = $args['product'];
		$attribute  = $args['attribute'];
		$count      = 0;
		$limit      = absint( isset( $args['limit'] ) ? $args['limit'] : 0 );
		$hint       = $class::get_setting( 'tooltip', 'top' );
		$hint_class = $hint !== 'no' ? 'hint--' . $hint : '';
		$style      = $class::get_setting( 'style', 'square' );
		$attr_id    = wc_attribute_taxonomy_id_by_name( $attribute );

		ob_start();

		if ( empty( $options ) && ! empty( $product ) && ! empty( $attribute ) ) {
			$attributes = $product->get_variation_attributes();
			$options    = $attributes[ $attribute ];
		}

		if ( $attr_id ) {
			$attr      = wc_get_attribute( $attr_id );
			$attr_type = isset( $attr->type ) ? $attr->type : 'select';

			$terms = wc_get_product_terms(
				$product->get_id(),
				$attribute,
				array(
					'fields' => 'all',
				)
			);

			if ( ( $attr_type === 'select' ) && ( $class::get_setting( 'button_default', 'no' ) === 'yes' ) ) {
				$attr_type = 'button';
			}

			if ( ( $attr_type !== '' ) && ( $attr_type !== 'select' ) ) {
				do_action( 'wpcvs_terms_above', $args );

				$terms_class = apply_filters( 'wpcvs_terms_class', 'wpcvs-terms wpcvs-type-' . $attr_type . ' wpcvs-style-' . $style, $terms, $args );
				echo '<div class="' . esc_attr( $terms_class ) . '" data-attribute="' . esc_attr( $attribute ) . '">';
				do_action( 'wpcvs_terms_before', $args );

				switch ( $attr_type ) {
					case 'button' :
						foreach ( $terms as $term ) {
							if ( ! $limit || ( $count < $limit ) ) {
								$val     = get_term_meta( $term->term_id, 'wpcvs_button', true ) ?: $term->name;
								$tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $val;
								$class   = apply_filters( 'wpcvs_term_class', 'wpcvs-term ' . $hint_class, $term, $args );
								do_action( 'wpcvs_term_before', $term );
								echo apply_filters( 'wpcvs_term_html', '<span class="' . esc_attr( $class ) . '" aria-label="' . esc_attr( $tooltip ) . '" title="' . esc_attr( $tooltip ) . '" data-term="' . esc_attr( $term->slug ) . '"><span>' . esc_html( $val ) . '</span></span>', $term, $args );
								do_action( 'wpcvs_term_after', $term );
							}

							$count ++;
						}

						break;
					case 'color':
						foreach ( $terms as $term ) {
							if ( ! $limit || ( $count < $limit ) ) {
								$val     = get_term_meta( $term->term_id, 'wpcvs_color', true ) ?: '';
								$tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
								$class   = apply_filters( 'wpcvs_term_class', 'wpcvs-term ' . $hint_class, $term, $args );
								do_action( 'wpcvs_term_before', $term );
								echo apply_filters( 'wpcvs_term_html', '<li class="' . esc_attr( $class ) . '" aria-label="' . esc_attr( $tooltip ) . '" title="' . esc_attr( $tooltip ) . '" data-term="' . esc_attr( $term->slug ) . '"><div class="colorize"><span ' . ( ! empty( $val ) ? 'style="background-color: ' . esc_attr( $val ) . '"' : '' ) . ' class="bg">' . esc_html( $val ) . '</span><span class="title">' . esc_attr( $tooltip ) . '</span></div></li>', $term, $args );
								do_action( 'wpcvs_term_after', $term );
							}

							$count ++;
						}

						break;
					case 'image':
						foreach ( $terms as $term ) {
							if ( ! $limit || ( $count < $limit ) ) {
								$val     = get_term_meta( $term->term_id, 'wpcvs_image', true ) ? wp_get_attachment_thumb_url( get_term_meta( $term->term_id, 'wpcvs_image', true ) ) : wc_placeholder_img_src();
								$tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
								$class   = apply_filters( 'wpcvs_term_class', 'wpcvs-term ' . $hint_class, $term, $args );
								do_action( 'wpcvs_term_before', $term );
								echo apply_filters( 'wpcvs_term_html', '<span class="' . esc_attr( $class ) . '" aria-label="' . esc_attr( $tooltip ) . '" title="' . esc_attr( $tooltip ) . '" data-term="' . esc_attr( $term->slug ) . '"><span><img src="' . esc_url( $val ) . '" alt="' . esc_attr( $term->name ) . '"/></span></span>', $term, $args );
								do_action( 'wpcvs_term_after', $term );
							}

							$count ++;
						}

						break;
					case 'radio':
						$name = uniqid( 'wpcvs_radio_' );

						foreach ( $terms as $term ) {
							if ( ! $limit || ( $count < $limit ) ) {
								$val     = get_term_meta( $term->term_id, 'wpcvs_radio', true ) ?: $term->name;
								$tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
								$class   = apply_filters( 'wpcvs_term_class', 'wpcvs-term ' . $hint_class, $term, $args );
								do_action( 'wpcvs_term_before', $term );
								echo apply_filters( 'wpcvs_term_html', '<span class="' . esc_attr( $class ) . '" aria-label="' . esc_attr( $tooltip ) . '" title="' . esc_attr( $tooltip ) . '" data-term="' . esc_attr( $term->slug ) . '"><span><input type="radio" name="' . esc_attr( $name ) . '" value="' . esc_attr( $term->slug ) . '"/> ' . esc_html( $val ) . '</span></span>', $term, $args );
								do_action( 'wpcvs_term_after', $term );
							}

							$count ++;
						}

						break;
					default:
						break;
				}

				if ( $limit && ( $count > $limit ) ) {
					//echo apply_filters( 'wpcvs_more_html', '<span class="wpcvs-more"><a href="' . esc_url( $product->get_permalink() ) . '">' . sprintf( $class::localization( 'more', esc_html__( '+%d More', 'wpc-variation-swatches' ) ), ( $count - $limit ) ) . '</a></span>', ( $count - $limit ) );
				}

				do_action( 'wpcvs_terms_after', $args );
				echo '</div>';
				do_action( 'wpcvs_terms_below', $args );
			}
		} else {
			// custom attribute
			if ( $class::get_setting( 'button_default', 'no' ) === 'yes' ) {
				do_action( 'wpcvs_terms_above', $args );

				$terms_class = apply_filters( 'wpcvs_terms_class', 'wpcvs-terms wpcvs-type-button wpcvs-style-' . $style, $options, $args );
				echo '<div class="' . esc_attr( $terms_class ) . '" data-attribute="' . esc_attr( wc_sanitize_taxonomy_name( $attribute ) ) . '">';
				do_action( 'wpcvs_terms_before', $args );

				foreach ( $options as $option ) {
					if ( ! $limit || ( $count < $limit ) ) {
						$class = apply_filters( 'wpcvs_term_class', 'wpcvs-term ' . $hint_class, $option, $args );
						do_action( 'wpcvs_term_before', $option );
						echo apply_filters( 'wpcvs_term_html', '<span class="' . esc_attr( $class ) . '" aria-label="' . esc_attr( $option ) . '" title="' . esc_attr( $option ) . '" data-term="' . esc_attr( $option ) . '"><span>' . esc_html( $option ) . '</span></span>', $option, $args );
						do_action( 'wpcvs_term_after', $option );
					}

					$count ++;
				}

				do_action( 'wpcvs_terms_after', $args );
				echo '</div>';
				do_action( 'wpcvs_terms_below', $args );
			}
		}

		return apply_filters( 'wpcvs_terms_html', ob_get_clean(), $args ) . $options_html;
	}
	add_filter( 'woocommerce_dropdown_variation_attribute_options_html', 'dx_variation_attribute_options_html', 199, 2 );

	#
	##
	#  Digix Archive Advanced variation

	function dx_archive( $product_id = null ) {
		global $product;
		$global_product = $product;

		if ( $product_id ) {
			$product = wc_get_product( $product_id );
		}

		if ( ! $product || ! $product->is_type( 'variable' ) ) {
			return;
		}

		$attributes           = $product->get_variation_attributes();
		$available_variations = $product->get_available_variations();
		$variations_json      = wp_json_encode( $available_variations );
		$variations_attr      = function_exists( 'wc_esc_json' ) ? wc_esc_json( $variations_json ) : _wp_specialchars( $variations_json, ENT_QUOTES, 'UTF-8', true );

		if ( is_array( $attributes ) && ( count( $attributes ) > 0 ) ) {
			do_action( 'wpcvs_archive_variations_form_above', $product );
			echo '<div class="wpcvs_archive dx_form" >';
			do_action( 'wpcvs_archive_variations_form_before', $product );
			echo '<div class="variations">';
			do_action( 'wpcvs_archive_variations_before', $product );

			foreach ( $attributes as $attribute_name => $options ) { ?>
				<div class="dx_var">
					<div class="dx_select">
						<?php
						$attr     = 'attribute_' . sanitize_title( $attribute_name );
						$selected = isset( $_REQUEST[ $attr ] ) ? wc_clean( stripslashes( urldecode( $_REQUEST[ $attr ] ) ) ) : $product->get_variation_default_attribute( $attribute_name );
						wc_dropdown_variation_attribute_options( array(
							'options'          => $options,
							'attribute'        => $attribute_name,
							'product'          => $product,
							'limit'            => '10',
							'selected'         => $selected,
						) );
						?>
					</div>
				</div>
			<?php }
			do_action( 'wpcvs_archive_variations_after', $product );
			echo '</div>';
			do_action( 'wpcvs_archive_variations_form_after', $product );
			echo '</div>';
			do_action( 'wpcvs_archive_variations_form_below', $product );
		}

		$product = $global_product;
	}
	#
	##
	#  Digix Archive Advanced variation - add shortcode

	function dx_shortcode_archive( $attrs ) {
		$attrs = shortcode_atts( array(
			'id' => null,
		), $attrs, 'wpcvs_archive' );

		ob_start();
		dx_archive( $attrs['id'] );

		return ob_get_clean();
	}
	add_shortcode( 'dx_attributes', 'dx_shortcode_archive' );

}

add_action('woocommerce_before_shop_loop','digix_woocommrece_merge_catelog_result',10);

# Remove Woocommerce result count

remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );

# Remove Woocommerce catelog ordering

remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
  
# Remove Outputs Opening Divs For The Content

remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );


# Remove Outputs Closing Divs For The Content

remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );


# Remove Single Product Default Excerpt

remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);

# Remove Single Product Sale Flash

remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);


# Remove Single Product Default Single Rating

remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);


# Add Single Product New Single Rating

add_action('woocommerce_before_add_to_cart_button', 'woocommerce_template_single_rating', 1);


# Remove Woocommerce single variation default

remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation', 10 );


# Add Sending Method and delivery

add_action('woocommerce_before_add_to_cart_button', 'digix_woocommerce_delivery', 2);


# Add Woocommerce single variation

add_action('woocommerce_before_add_to_cart_button', 'woocommerce_single_variation', 3);


# Remove Woocommerce single Price default

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );


# Add Woocommerce single Price Before Add To cart Button

add_action('woocommerce_before_add_to_cart_button', 'woocommerce_template_single_price', 10);


# Remove Woocommerce Output All notice

remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);


# add Woocommerce Output All notice

add_action('woocommerce_before_main_content', 'woocommerce_output_all_notices', 40);


# Remove Dokan Sell Btn

remove_action( 'woocommerce_single_product_summary', 'show_sell_now_btn', 32 );


#remove checkout login

remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_login_form', 10 );

#remove checkout register

//add_filter( 'woocommerce_checkout_registration_enabled', '__return_false' );

remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );