<?php
/**
 * The template for displaying the footer.
 *
 * Contains the body & html closing tags.
 *
 * @package DIGIX
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
Global $options;
?>
<footer class="cosmetic-footer" role="contentinfo" itemscope itemtype="http://schema.org/WPFooter">
	<section class="sectiontop" style="background-color:<?php //echo $options['footer-newsletter-color'];?>;">
		<div class="container">
			<div class="logo">
				<a class="uri" href="<?php echo esc_url( home_url() ); ?>">
					<img src="<?php echo $options['footer-logo-cosmetic'];?>" alt="<?php echo $options['general-title']; ?>" class="img-fluid">
				</a>
				<strong><?php echo $options['general-title']; ?></strong>
			</div>
			<div class="newsletter">
				<p>
					<?php echo $options['footer-newsletterdesc'];?>
				</p>
				<?php echo do_shortcode($options['footer-newsletter']);?>
			</div>
		</div>
	</section>
	<section class="sectiondown">
		<div class="container">
			<div class="top">
				<div class="right">
					<div class="title"><?php echo __('menus','digix'); ?></div>
					 <?php
							wp_nav_menu(array(
									'theme_location' => 'footer',
									'container' => false,
									'menu_id' => 'footer-menu',
									'menu_class' => 'menu',
									'depth' => 1,
								));
						?>
				</div>
				<div class="left">
					<?php 
						$server = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
						$home   = esc_url( home_url() ).'/';
						if ( $server == $home ):?>
							<h1>
									<?php bloginfo('name'); ?>
							</h1>
					<?php
						else:?>
							<h2>
									<?php bloginfo('name'); ?>
							</h2>
					<?php 
						endif; ?>             
					<div class="description">
						<?php echo $options['footer-about'];?>
					</div>
				</div>
			</div>
			<div class="down">
				<div class="right">
					<div class="social">
						<p>
							<i class="icon-hare"></i>
							<?php echo __('Following us in social media','digix');?>
						</p>
						<ul>
							<?php if( isset($options['contact-instagram']) && !empty($options['contact-instagram'])):?>
								<li class="item"><a href="<?php echo $options['contact-instagram'];?>"><i class="icon-instagram"></i></a></li>
							<?php endif;?>
							<?php if( isset($options['contact-twitter']) && !empty($options['contact-twitter'])):?>    
								<li class="item"><a href="<?php echo $options['contact-twitter'];?>"><i class="icon-twitter"></i></a></li>
							<?php endif;?>
							<?php if( isset($options['contact-telegram']) && !empty($options['contact-telegram'])):?>        
								<li class="item"><a href="<?php echo $options['contact-telegram'];?>"><i class="icon-telegram"></i></a></li>
							<?php endif;?>
							<?php if( isset($options['contact-facebook']) && !empty($options['contact-facebook'])):?>
								<li class="item"><a href="<?php echo $options['contact-facebook'];?>"><i class="icon-facebook"></i></a></li>
							<?php endif;?>
							<?php if( isset($options['contact-rubika']) && !empty($options['contact-rubika'])):?>
								<li class="item"><a href="<?php echo $options['contact-rubika'];?>"><i class="icon-rubika"></i></a></li>
							<?php endif;?>
							<?php if( isset($options['contact-bale']) && !empty($options['contact-bale'])):?>
								<li class="item"><a href="<?php echo $options['contact-bale'];?>"><i class="icon-bale"></i></a></li>
							<?php endif;?>
							<?php if( isset($options['contact-sapp']) && !empty($options['contact-sapp'])):?>
								<li class="item"><a href="<?php echo $options['contact-sapp'];?>"><i class="icon-sapp"></i></a></li>
							<?php endif;?>
							<?php if( isset($options['contact-eitaa']) && !empty($options['contact-eitaa'])):?>
								<li class="item"><a href="<?php echo $options['contact-eitaa'];?>"><i class="icon-eitaa"></i></a></li>
							<?php endif;?>
							<?php if( isset($options['contact-gap']) && !empty($options['contact-gap'])):?>
								<li class="item"><a href="<?php echo $options['contact-gap'];?>"><i class="icon-gap"></i></a></li>
							<?php endif;?>
						</ul>
					</div>
					<div class="address">
						<p>
							<i class="icon-location"></i>
							<?php echo __('address','digix'); ?>
						</p>
						<div class="addr">
							<?php echo $options['footer-address'];?>
						</div>
					</div>
				</div>
				<div class="left">
					<div class="phone">
						<a href="#">
							<svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="512" height="512" x="0" y="0" viewBox="0 0 682.667 682.667" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g transform="matrix(6.123233995736766e-17,-1,1,6.123233995736766e-17,-0.07246875762939453,682.7402486801147)"><defs><clipPath id="a" clipPathUnits="userSpaceOnUse"><path d="M0 512h512V0H0Z" fill="#5ac95a" data-original="#000000" class=""></path></clipPath></defs><g clip-path="url(#a)" transform="matrix(1.33333 0 0 -1.33333 0 682.667)"><path d="M0 0c116.11 0 210.57-94.46 210.57-210.569" style="stroke-width:20;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" transform="translate(291.43 501.89)" fill="none" stroke="#5ac95a" stroke-width="20" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-dasharray="none" stroke-opacity="" data-original="#000000" class=""></path><path d="M0 0c82.931 0 150.41-67.48 150.41-150.41" style="stroke-width:20;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" transform="translate(291.43 441.73)" fill="none" stroke="#5ac95a" stroke-width="20" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-dasharray="none" stroke-opacity="" data-original="#000000" class=""></path><path d="M0 0c49.761 0 90.24-40.479 90.24-90.239" style="stroke-width:20;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" transform="translate(291.43 381.56)" fill="none" stroke="#5ac95a" stroke-width="20" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-dasharray="none" stroke-opacity="" data-original="#000000" class=""></path><path d="M0 0c16.61 0 30.08-13.471 30.08-30.08" style="stroke-width:20;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" transform="translate(291.43 321.4)" fill="none" stroke="#5ac95a" stroke-width="20" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-dasharray="none" stroke-opacity="" data-original="#000000" class=""></path><path d="M0 0c0-5.523-4.477-10-10-10-5.522 0-10 4.477-10 10 0 5.522 4.478 10 10 10C-4.477 10 0 5.522 0 0" style="fill-opacity:1;fill-rule:nonzero;stroke:none" transform="translate(187.418 187.196)" fill="#5ac95a" data-original="#000000" class=""></path><path d="M0 0a383.558 383.558 0 0 0-18.018 25.798c-7.439 11.649-5.189 27.079 4.58 36.849l33.951 33.951c7.309 7.299 7.309 19.149 0 26.45l-79.901 79.899c-7.3 7.311-19.149 7.311-26.449 0l-20.221-20.219c-32.819-32.811-41.689-82.89-21.089-124.47 36.65-73.99 112.07-187.41 257.37-258.66 41.71-20.441 92.02-11.771 124.86 21.069l20.68 20.681c7.309 7.299 7.309 19.149 0 26.46l-79.901 79.889c-7.3 7.311-19.149 7.311-26.449 0l-33.95-33.95c-9.771-9.769-25.2-12.019-36.851-4.58a383.454 383.454 0 0 0-36.228 26.25" style="stroke-width:20;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" transform="translate(148.197 221.393)" fill="none" stroke="#5ac95a" stroke-width="20" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-dasharray="none" stroke-opacity="" data-original="#000000" class=""></path></g></g></svg>	
								<div class="detailes"><p><?php echo $options['contact-tell']; ?></p><span><?php echo $options['contact-detailes'];?></span></div>
						</a>
					</div>
					<div class="namad">
						<?php echo $options['footer-trust'];?>
						<?php 
							if ( isset ( $options['footer-trust-shortcode'] ) && !empty ( $options['footer-trust-shortcode'] ) ){ 
								$namad_two = $options['footer-trust-shortcode']; echo do_shortcode($namad_two);
							} 
						?>
						<?php echo $options['footer-saramad'];?>
						<?php 
							if ( isset ( $options['footer-saramad-shortcode'] ) && !empty ( $options['footer-saramad-shortcode'] ) ){ 
								$namad_two = $options['footer-saramad-shortcode']; echo do_shortcode($namad_two);
							} 
						?>
					</div>
				</div>

			</div>
		</div>
	</section>
	<section class="copyright" itemprop="copyrightHolder" itemscope itemtype="http://schema.org/Organization"><div class="container"><?php echo $options['footer-copyright'];?></div></section>
</footer>