<?php

class digix_elementor_bestselling extends \Elementor\Widget_Base 
{

	public function get_name() 
    {
		return 'bestseller-element';
	}

	public function get_title() 
    {
		return __('best selling element','digix');
	}

	public function get_icon() 
    {
		return 'eicon-product-stock';
	}

	public function get_categories() 
    {
		return [ 'digix' ];
	}

	protected function _register_controls() 
    {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('best selling element','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'placeholder' => '',
			]
		);
		
		$this->add_control(
			'cat',
			[
				'label'   => __('category','digix'),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'all',
				'options' => $this->get_product_cats(),
			]
		);

		$this->add_control(
			'post_in',
			[
				'label'       => __('include product','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'description' => __('Separate product IDs with English commas.','digix'),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'      => __('number of products','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
			]
		);

		$this->add_control(
			'instock',
			[
				'label'        => __('instock products','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);

		$this->end_controls_section();
	}

	private function get_product_cats() 
    {
		$output_categories = [ 'all' => __('all','digix') ];

		$args       = [
			'taxonomy'     => 'product_cat',
			'orderby'      => 'id',
			'order'        => 'ASC',
			'hide_empty'   => false,
			'hierarchical' => true,
		];

		$categories = get_categories( $args );

		foreach ( $categories as $category )
         {
			$output_categories[ $category->cat_ID ] = $category->name;
		}

		return $output_categories;
	}

	protected function render()
    {

		$settings = $this->get_settings_for_display();

		$title          = $settings['title'];
		$cat            = ! empty( $settings['cat'] ) ? $settings['cat'] : '';
		$post_in        = ! empty( $settings['post_in'] ) ? trim( $settings['post_in'] ) : '';
		$posts_per_page = ! empty( $settings['posts_per_page'] ) ? $settings['posts_per_page'] : 10;
		$instock        = ! empty( $settings['instock'] ) ? 1 : 0;
		$products_args = array(
			'post_type'      => 'product',
			'posts_per_page' => $posts_per_page,
		);

		if ( $cat != 'all' ) {
			$tax_query                     = array(
				'taxonomy'         => 'product_cat',
				'field'            => 'term_id',
				'terms'            => $cat,
				'operator'         => 'AND',
				'include_children' => false,
			);
			$products_args['tax_query'][0] = $tax_query;
		}

		if ( ! empty( $post_in ) ) {
			if ( preg_match( '/^\d+(?:,?\d+,?)+$/', $post_in ) ) {
				$array                     = explode( ',', $post_in );
				$post__in                  = array_filter( $array, function ( $value ) {
					return $value !== '';
				} );
				$products_args['post__in'] = $post__in;
			}
		}

		if ( $instock ) {
			$meta_query                     = array(
				'key'     => '_stock_status',
				'value'   => 'instock',
				'compare' => '=',
			);
			$products_args['meta_query'][0] = $meta_query;
		}

			$products_args['meta_key']     = 'total_sales';
			$products_args['meta_compare'] = '!=';
			$products_args['meta_value']   = '0';
			$products_args['orderby']      = 'meta_value_num';
		if(isset($_COOKIE['digixproductlocation']) && !empty(($_COOKIE['digixproductlocation']))){
			$product_city=explode(',', $_COOKIE['digixproductlocation']);
			if (!empty($product_city) && $product_city !== 0) {
				if (is_array($products_args["tax_query"])) {
					$products_args["tax_query"][] = ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city];
				} else {
					$products_args["tax_query"] = ["relation" => "AND", ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city]];
				}
			}
		}
		$products = new WP_Query( $products_args );
		if ( $products->have_posts() ) : ?>
			<section class="digix-bestselling">
				<header dir="rtl" class="bestselling-header">
					<?php
						if ( empty( $post_in ) ) 
						{
							if ( $cat && $cat == 'all' ) 
							{
								echo '<h3><a href="' . get_permalink( wc_get_page_id( 'shop' ) ) . '"><strong>' . $title . '</strong></a></h3>';
							}
							if ( $cat && $cat != 'all' ) 
							{
								$term = get_term( $cat, 'product_cat' );
								echo '<h3><a href="' . get_term_link( $term, 'product_cat' ) . '"><strong>' . $title . '</strong></a></h3>';
							}
						}
					?>	
                </header>
                <div class="bestselling-list">					
					<?php $i = 0; while ( $products->have_posts() ) : $products->the_post(); ?>
					  	<?php $product = wc_get_product( $products->post->ID ); ?>
                            <a class="bestselling-item" href="<?php echo $product->get_permalink(); ?>">
                                <figure class="bestselling-thumbnails">
                                    <?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(), 'woocommerce_thumbnail', array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) ); ?>
                                </figure>
								<span class="bestselling-number"><?php echo ++$i;?></span>
                                <div class="bestselling-detailes">
                                    <p> <?php echo $product->get_title(); ?> </p>
                                </div>
							</a>
						<?php endwhile; ?>
					<?php wp_reset_postdata(); ?>
                </div>
			</section>
		<?php endif;
	}
}