<?php

class digix_elementor_cosmeticproduct extends \Elementor\Widget_Base 
{

	public function get_name() 
    {
		return 'cosmeticproduct-element';
	}

	public function get_title() 
    {
		return __('cosmetic product element','digix');
	}

	public function get_icon() 
    {
		return 'eicon-product-stock';
	}

	public function get_categories() 
    {
		return [ 'digix' ];
	}

	protected function _register_controls() 
    {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('product element','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'placeholder' => '',
			]
		);
		
		$this->add_control(
			'cat',
			[
				'label'   => __('category','digix'),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'all',
				'options' => $this->get_product_cats(),
			]
		);

		$this->add_control(
			'post_in',
			[
				'label'       => __('include product','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'description' => __('Separate product IDs with English commas.','digix'),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'      => __('number of products','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
			]
		);
		
		$this->add_control(
			'instock',
			[
				'label'        => __('instock products','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->add_control(
			 'add_cart',
			 [
                'label' => __( 'show add to cart button', 'digix' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',

			 ]
		);
		$this->add_control(
			'attributes',
			[
				'label'        => __('show attributes','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->add_control(
			'best_selling',
			[
				'label'        => __('best-selling products','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->add_control(
			'slide_per_view',
			[
				'label'      => __('number of slide per view','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
				'default'	 => 7,
				'min'		 => 4,
				'max'		 => 7,
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'style',
			[
				'label' => __( 'style', 'digix' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'add_to_cart_bgcolor',
			[
				'label' => __( 'add to cart background color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#3ab54a',
				'selectors' => [
					'{{WRAPPER}} .im-product .product-item .product-detailes .product-add button' => 'background-color: {{VALUE}} !important',
				],
			]
		);
	   $this->add_control(
		'discount_bgcolor',
		[
			'label' => __( 'discount background color', 'digix' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#ff0000',
			'selectors' => [
				'{{WRAPPER}} .im-product .product-item .discount' => 'background-color: {{VALUE}}',
			],
		]
		);
		$this->add_control(
            'del_color',
            [
                'label' => __( 'sale color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#8c8c8c',
                'selectors' => [
                    '{{WRAPPER}} .cosmetic-product .product-item .product-detailes .product-add .product-price del' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'price_color',
            [
                'label' => __( 'price color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3ab54a',
                'selectors' => [
                    '{{WRAPPER}} .im-product .product-item .product-detailes .product-add .product-price>span' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .im-product .product-item .product-detailes .product-add .product-price ins' => 'color: {{VALUE}} !important',
                ],
            ]
        );
	  $this->end_controls_section();
	}

	private function get_product_cats() 
    {
		$output_categories = [ 'all' => __('all','digix') ];

		$args       = [
			'taxonomy'     => 'product_cat',
			'orderby'      => 'id',
			'order'        => 'ASC',
			'hide_empty'   => false,
			'hierarchical' => true,
		];

		$categories = get_categories( $args );

		foreach ( $categories as $category )
         {
			$output_categories[ $category->cat_ID ] = $category->name;
		}

		return $output_categories;
	}

	protected function render()
    {

		$settings = $this->get_settings_for_display();

		$title          = $settings['title'];
		$add_cart   	= ! empty( $settings['add_cart'] ) ? 1 : 0;
		$attributes   	= ! empty( $settings['attributes'] ) ? 1 : 0;
		$cat            = ! empty( $settings['cat'] ) ? $settings['cat'] : '';
		$post_in        = ! empty( $settings['post_in'] ) ? trim( $settings['post_in'] ) : '';
		$posts_per_page = ! empty( $settings['posts_per_page'] ) ? $settings['posts_per_page'] : 10;
		$instock        = ! empty( $settings['instock'] ) ? 1 : 0;
		$best_selling   = ! empty( $settings['best_selling'] ) ? 1 : 0;
		$slide_per_view = $settings['slide_per_view'];
		$products_args = array(
			'post_type'      => 'product',
			'posts_per_page' => $posts_per_page,
		);

		if ( $cat != 'all' ) {
			$tax_query                     = array(
				'taxonomy'         => 'product_cat',
				'field'            => 'term_id',
				'terms'            => $cat,
				'operator'         => 'AND',
				'include_children' => false,
			);
			$products_args['tax_query'][0] = $tax_query;
		}

		if ( ! empty( $post_in ) ) {
			if ( preg_match( '/^\d+(?:,?\d+,?)+$/', $post_in ) ) {
				$array                     = explode( ',', $post_in );
				$post__in                  = array_filter( $array, function ( $value ) {
					return $value !== '';
				} );
				$products_args['post__in'] = $post__in;
			}
		}

		if ( $instock ) {
			$meta_query                     = array(
				'key'     => '_stock_status',
				'value'   => 'instock',
				'compare' => '=',
			);
			$products_args['meta_query'][0] = $meta_query;
		}

		if ( $best_selling ) {
			$products_args['meta_key']     = 'total_sales';
			$products_args['meta_compare'] = '!=';
			$products_args['meta_value']   = '0';
			$products_args['orderby']      = 'meta_value_num';
		}

		$products = new WP_Query( $products_args );
		if ( $products->have_posts() ) : ?>
			<section class="cosmetic-product">
				<div dir="rtl" class="swiper-container cosmetic-swiper-product swiper-html" data-swiper='{"spaceBetween": 10, "slidesPerView":<?php echo $slide_per_view; ?>, "loop": false, "navigation": {"nextEl": ".swiper-button-next", "prevEl": ".swiper-button-prev"}, "breakpoints": {"320": {"slidesPerView":2},"991": {"slidesPerView":5},"1100": {"slidesPerView":<?php echo $slide_per_view; ?>}}}'>

					<div class="swiper-button-next"></div>
					<?php
						if ( empty( $post_in ) && ! $best_selling ) 
						{
							if ( $cat && $cat == 'all' ) 
							{
								echo '<h3><a href="' . get_permalink( wc_get_page_id( 'shop' ) ) . '"><strong>' . $title . '</strong></a></h3>';
							}
							if ( $cat && $cat != 'all' ) 
							{
								$term = get_term( $cat, 'product_cat' );
								echo '<h3><a href="' . get_term_link( $term, 'product_cat' ) . '"><strong>' . $title . '</strong></a></h3>';
							}
						}
					?>						
					<div class="swiper-button-prev"></div>
					<div class="swiper-wrapper">
						<?php while ( $products->have_posts() ) : $products->the_post(); ?>
					  		<?php $product = wc_get_product( get_the_id() ); ?>
							<div class="swiper-slide">
								<div class="product-item">
									<?php if($product->is_on_sale()){ ?>
										<div class="discount <?php if($attributes){echo'left-auto right-10';}?>">
											٪<?php echo digix_wooocmmerce_discount(get_the_ID()) ?>
										</div>
									<?php } ?>
									<?php if($attributes):?>
										<div class="product-attribute">
											<?php echo do_shortcode('[dx_attributes]');do_action('digix_woocommerce_before_thumbnails');?>
										</div>
									<?php endif; ?>
									<figure class="product-thumbnails">
										<a href="<?php echo $product->get_permalink(); ?>">
											<?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(), array(150,150), array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) );$array= array(150,150);digix_second_thumbnail($array); ?>
										</a>
									</figure>
									<div class="product-detailes">
										<h2>
											<a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a>
										</h2>
										<div class="product-add  <?php if(! $add_cart){echo'justify-content-center';}?>">
											<div class="product-price">
												<?php echo $product->get_price_html(); ?>
											</div>
											<?php if($add_cart):?>
												<button class="add-to-cart-wrap" data-toggle="tooltip" data-original-title="<?php echo esc_html( $product->add_to_cart_text() );?>">
													<a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" data-quantity="1" class="<?php echo esc_attr( implode( ' ', array_filter( array( 'button', 'product_type_' . $product->get_type(), $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '', $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '', ) ) ) );?>" <?php echo wc_implode_html_attributes( array( 'data-product_id'  => $product->get_id(), 'data-product_sku' => $product->get_sku(), 'aria-label'       => $product->add_to_cart_description(), 'rel'              => 'nofollow',) );?>><i class="icon-shopping-basket"></i></a>
												</button>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>
					</div>	
				</div>
			</section>
		<?php endif;
	}
}