<?php

class digix_elementor_product extends \Elementor\Widget_Base 
{

	public function get_name() 
    {
		return 'product-element';
	}

	public function get_title() 
    {
		return __('product element','digix');
	}

	public function get_icon() 
    {
		return 'eicon-product-stock';
	}

	public function get_categories() 
    {
		return [ 'digix' ];
	}

	protected function _register_controls() 
    {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('product element','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'placeholder' => '',
			]
		);
		$this->add_control(
			'product_filter',
			[
				'label' => __( 'Product filtering', 'digix' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category' 	 	=> __( 'Products category', 'digix' ),
					'tag' 			=> __( 'Products tag', 'digix' ),
					'brand' 		=> __( 'Products brand', 'digix' ),
				],
			]
		);
		$this->add_control(
			'cat',
			[
				'label'   => __('category','digix'),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'all',
				'options' => $this->get_product_cats(),
				'condition' => [
                    'product_filter' => 'category',
                ],
			]
		);
		$this->add_control(
			'tag',
			[
				'label' => __( 'Product tag', 'digix' ),
				'description' => __( 'Empty tags (no product) are not displayed', 'digix' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'multiple' => true,
				'options' => $this->get_product_tags(),
				'condition' => [
					'product_filter' => 'tag',
				],
			]
		);
		$this->add_control(
			'brand',
			[
				'label' => __( 'Product brand', 'digix' ),
				'description' => __( 'Empty brands (no product) are not displayed', 'digix' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'multiple' => true,
				'options' => $this->get_product_brands(),
				'condition' => [
					'product_filter' => 'brand',
				],
			]
		);
		$this->add_control(
			'post_in',
			[
				'label'       => __('include product','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'description' => __('Separate product IDs with English commas.','digix'),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'      => __('number of products','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
			]
		);

		$this->add_control(
			'instock',
			[
				'label'        => __('instock products','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->add_control(
			 'add_cart',
			 [
                'label' => __( 'show add to cart button', 'digix' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',

			 ]
		);
		$this->add_control(
			'attributes',
			[
				'label'        => __('show attributes','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->add_control(
			'best_selling',
			[
				'label'        => __('best-selling products','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->add_control(
			'slide_per_view',
			[
				'label'      => __('number of slide per view','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
				'default'	 => 7,
				'min'		 => 4,
				'max'		 => 7,
			]
		);
		$this->add_control(
			'autoplay',
			[
				'label'        => __('Is the automatic slider active?','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
				'default'   => "0",
			]
		);
		$this->add_control(
			'delay', [
				'label'     => __( 'Slider autoplay time in seconds', 'digix' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => "5",
				'condition' => [
					'autoplay' => '1',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'style',
			[
				'label' => __( 'style', 'digix' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'pitem_boxshadow',
			[
				'label'        => __('box shadow product item','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'default' 	   => '1',
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->add_control(
			'pitem_h2a',
			[
				'label' => __( 'product title font size', 'digix' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
				'default'	 => 15,
				'min'		 => 12,
				'max'		 => 20,
				'selectors' => [
					'{{WRAPPER}} .im-product .product-item .product-detailes h2 a' => 'font-size: {{VALUE}}px !important',
				],
			]
		);
		$this->add_control(
			'pitem_h2a_color',
			[
				'label' => __( 'product title color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .im-product .product-item .product-detailes h2 a' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'add_to_cart_bgcolor',
			[
				'label' => __( 'add to cart background color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#3ab54a',
				'selectors' => [
					'{{WRAPPER}} .im-product .product-item .product-detailes .product-add button' => 'background-color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
		'discount_color',
		[
			'label' => __( 'discount text color', 'digix' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#fff',
			'selectors' => [
				'{{WRAPPER}} .im-product .product-item .discount' => 'color: {{VALUE}}; border-color: {{VALUE}};',
				'{{WRAPPER}} .digix-product .product-item .discount' => 'color: {{VALUE}}; border-color: {{VALUE}};',
			],
		]
		);
	   $this->add_control(
		'discount_bgcolor',
		[
			'label' => __( 'discount background color', 'digix' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#ff0000',
			'selectors' => [
				'{{WRAPPER}} .im-product .product-item .discount' => 'background-color: {{VALUE}}',
				'{{WRAPPER}} .digix-product .product-item .discount' => 'background-color: {{VALUE}}',
			],
		]
		);
		$this->add_control(
            'del_color',
            [
                'label' => __( 'sale color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'red',
                'selectors' => [
                    '{{WRAPPER}} .im-product .product-item .product-detailes .product-add .product-price del' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .digix-product .product-item .product-detailes .product-add .product-price del' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'price_color',
            [
                'label' => __( 'price color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3ab54a',
                'selectors' => [
                    '{{WRAPPER}} .im-product .product-item .product-detailes .product-add .product-price>span' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .digix-product .product-item .product-detailes .product-add .product-price>span' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .im-product .product-item .product-detailes .product-add .product-price ins' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .digix-product .product-item .product-detailes .product-add .product-price ins' => 'color: {{VALUE}} !important',
                ],
            ]
        );
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'title color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .im-product .swiper-container h3' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .digix-product h3' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .im-product .swiper-container h3 strong' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .digix-product h3 strong' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .im-product .swiper-container h3.right strong::after' => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'text_align',
			[
				'label' => __( 'title text align', 'digix' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'center',
				'options' => [
					'center' => __( 'center', 'digix' ),
					'right'  => __( 'right', 'digix' ),
				],
				'selectors' => [
					'{{WRAPPER}} .im-product .swiper-container h3' => 'text-align: {{VALUE}};',
				],
			]
		);
	  $this->end_controls_section();
	}

	private function get_product_cats() 
    {
		$output_categories = [ 'all' => __('all','digix') ];

		$args       = [
			'taxonomy'     => 'product_cat',
			'orderby'      => 'id',
			'order'        => 'ASC',
			'hide_empty'   => false,
			'hierarchical' => true,
		];

		$categories = get_categories( $args );

		foreach ( $categories as $category )
         {
			$output_categories[ $category->cat_ID ] = $category->name;
		}

		return $output_categories;
	}
	private function get_product_tags() 
    {
		$product_tags = array();
		$tags = get_terms("product_tag");
		if ( !empty( $tags ) && !is_wp_error( $tags ) ){
			foreach ( $tags as $tag ) {
				$product_tags[ $tag->term_id ] = $tag->name;
			}
		}

		return $product_tags;
	}
	private function get_product_brands() 
    {
		global $options;
		$taxonomy = $options['woocommerce-brand-taxonomy'];
		$product_brand = array();
		$brands = get_terms($taxonomy);
		if ( !empty( $brands ) && !is_wp_error( $brands ) ){
			foreach ( $brands as $brand ) {
				$product_brand[ $brand->term_id ] = $brand->name;
			}
		}

		return $product_brand;
	}

	protected function render()
    {
		global $options;
		$settings = $this->get_settings_for_display();

		$title          = $settings['title'];
		$add_cart   	= ! empty( $settings['add_cart'] ) ? 1 : 0;
		$autoplay   	= ! empty( $settings['autoplay'] ) ? 1 : 0;
		$delay   		= $settings['delay'];
		$attributes   	= ! empty( $settings['attributes'] ) ? 1 : 0;
		$filter			= $settings['product_filter'];
		$cat            = ! empty( $settings['cat'] ) ? $settings['cat'] : '';
		$tag            = ! empty( $settings['tag'] ) ? $settings['tag'] : '';
		$brand          = ! empty( $settings['brand'] ) ? $settings['brand'] : '';
		$post_in        = ! empty( $settings['post_in'] ) ? trim( $settings['post_in'] ) : '';
		$posts_per_page = ! empty( $settings['posts_per_page'] ) ? $settings['posts_per_page'] : 10;
		$instock        = ! empty( $settings['instock'] ) ? 1 : 0;
		$pitem_boxshadow = ! empty( $settings['pitem_boxshadow'] ) ? 1 : 0;
		$best_selling   = ! empty( $settings['best_selling'] ) ? 1 : 0;
		$text_align     = $settings['text_align'];
		$slide_per_view = $settings['slide_per_view'];
		if($slide_per_view <= 5){
			$arr = array(200,200);
			$size = '200px';
			$number = 'five';
		}else if($slide_per_view >= 5){
			$arr = array(150,150);
			$size = '150px';
			$number = 'upfive';
		}
		$products_args = array(
			'post_type'      => 'product',
			'posts_per_page' => $posts_per_page,
		);
		if ( $filter === 'category' ) {
			if ( $cat != 'all' ) {
				$tax_query                     = array(
					'taxonomy'         => 'product_cat',
					'field'            => 'term_id',
					'terms'            => $cat,
					'operator'         => 'AND',
					'include_children' => false,
				);
				$products_args['tax_query'][0] = $tax_query;
			}
		} else if ( $filter === 'tag' ) {
			$tax_query                     = array(
				'taxonomy'         => 'product_tag',
				'field'            => 'term_id',
				'terms'            => $tag,
				'operator'         => 'AND',
				'include_children' => false,
			);
			$products_args['tax_query'][0] = $tax_query;
		} else if ( $filter === 'brand' ) {
			$tax_query                     = array(
				'taxonomy'         => $options['woocommerce-brand-taxonomy'],
				'field'            => 'term_id',
				'terms'            => $brand,
				'operator'         => 'AND',
				'include_children' => false,
			);
			$products_args['tax_query'][0] = $tax_query;
			
		}
		if ( ! empty( $post_in ) ) {
			if ( preg_match( '/^\d+(?:,?\d+,?)+$/', $post_in ) ) {
				$array                     = explode( ',', $post_in );
				$post__in                  = array_filter( $array, function ( $value ) {
					return $value !== '';
				} );
				$products_args['post__in'] = $post__in;
			}
		}

		if ( $instock ) {
			$meta_query                     = array(
				'key'     => '_stock_status',
				'value'   => 'instock',
				'compare' => '=',
			);
			$products_args['meta_query'][0] = $meta_query;
		}

		if ( $best_selling ) {
			$products_args['meta_key']     = 'total_sales';
			$products_args['meta_compare'] = '!=';
			$products_args['meta_value']   = '0';
			$products_args['orderby']      = 'meta_value_num';
		}
		if(isset($_COOKIE['digixproductlocation']) && !empty(($_COOKIE['digixproductlocation']))){
			$product_city=explode(',', $_COOKIE['digixproductlocation']);
			if (!empty($product_city) && $product_city !== 0) {
				if (is_array($products_args["tax_query"])) {
					$products_args["tax_query"][] = ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city];
				} else {
					$products_args["tax_query"] = ["relation" => "AND", ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city]];
				}
			}
		}
		$taxonomy = $options['woocommerce-brand-taxonomy'];

		$products = new WP_Query( $products_args );
		if ( $products->have_posts() ) : ?>
			<section class="im-product">
				<div dir="rtl" class="swiper-container im-swiper-product <?php echo $text_align . '-item';?> swiper-html" data-swiper='{"spaceBetween": 10, "slidesPerView":<?php echo $slide_per_view; ?>, "loop": false, <?php if ($autoplay == '1' ) {?>"autoplay": {"delay": "<?php echo $delay; ?>000"},<?php } ?> "navigation": {"nextEl": ".swiper-button-next", "prevEl": ".swiper-button-prev"}, "breakpoints": {"320": {"slidesPerView":2},"991": {"slidesPerView":5},"1100": {"slidesPerView":<?php echo $slide_per_view; ?>}}}'>

					<div class="swiper-button-next"></div>
					<?php
						if ( empty( $post_in ) && ! $best_selling ) 
						{
							if ( $filter === 'category' ) {
								if ( $cat && $cat == 'all' ) 
								{
									echo '<h3 class="' . $text_align . '"><a href="' . get_permalink( wc_get_page_id( 'shop' ) ) . '"><strong>' . $title . '</strong></a></h3>';
								}
								if ( $cat && $cat != 'all' ) 
								{
									$term = get_term( $cat, 'product_cat' );
									echo '<h3 class="' . $text_align . '"><a href="' . get_term_link( $term, 'product_cat' ) . '"><strong>' . $title . '</strong></a></h3>';
								}
							} else if ( $filter === 'tag' ) {
								if ( $tag ) 
								{
									$term = get_term( $tag, 'product_tag' );
									echo '<h3 class="' . $text_align . '"><a href="' . get_term_link( $term, 'product_tag' ) . '"><strong>' . $title . '</strong></a></h3>';
								}
							} else if ( $filter === 'brand' ) {
								if ( $brand ) 
								{
									$term = get_term( $brand, $taxonomy );
									echo '<h3 class="' . $text_align . '"><a href="' . get_term_link( $term, $taxonomy ) . '"><strong>' . $title . '</strong></a></h3>';
								}
							}
						}
					?>						
					<div class="swiper-button-prev"></div>
					<div class="swiper-wrapper">
						<?php while ( $products->have_posts() ) : $products->the_post(); ?>
					  		<?php $product = wc_get_product( get_the_id() );$attachment_ids = get_gallery_image_ids( $product ); ?>
							<div class="swiper-slide">
								<div class="product-item <?php if( ! $pitem_boxshadow ) {echo'no-boxshadow';}?> <?php echo $number; ?>">
									<?php if($product->is_on_sale()){ ?>
										<div class="discount <?php if($attributes){echo'left-auto right-10';}?>">
											٪<?php echo digix_wooocmmerce_discount(get_the_ID()) ?>
										</div>
									<?php } ?>
									<?php if($attributes):?>
										<?php if ( function_exists( 'wpcvs_init' ) ) {?>
											<div class="product-attribute">
												<?php echo do_shortcode('[dx_attributes]');do_action('digix_woocommerce_before_thumbnails');?>
											</div>
										<?php } ?>
									<?php endif; ?>
									<figure class="product-thumbnails <?php  if ( $attachment_ids ) {echo'has-gallery';}?>">
										<a href="<?php echo $product->get_permalink(); ?>" style="width:<?php echo $size; ?>;max-width:100%;">
											<?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(), $arr, array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) );digix_second_thumbnail($arr); ?>
										</a>
									</figure>
									<div class="product-detailes">
										<h2>
											<a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a>
										</h2>
										<div class="product-add  <?php if(! $add_cart){echo'justify-content-center text-center';}?>">
											<div class="product-price">
												<?php if ( ! $product->is_in_stock() ) {
														echo'<div class="OutStock">' . __( "Out Of Stock", "digix" ) . '</div>';
												}else{
														echo $product->get_price_html();
														
												} ?>
											</div>
											<?php if ( $product->is_in_stock() ) { if($add_cart):?>
												<button class="add-to-cart-wrap" data-toggle="tooltip" data-original-title="<?php echo esc_html( $product->add_to_cart_text() );?>">
													<a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" data-quantity="1" class="<?php echo esc_attr( implode( ' ', array_filter( array( 'button', 'product_type_' . $product->get_type(), $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '', $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '', ) ) ) );?>" <?php echo wc_implode_html_attributes( array( 'data-product_id'  => $product->get_id(), 'data-product_sku' => $product->get_sku(), 'aria-label'       => $product->add_to_cart_description(), 'rel'              => 'nofollow',) );?>><i class="icon-shopping-basket"></i></a>
												</button>
											<?php endif; }?>
										</div>
									</div>
								</div>
							</div>
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>
					</div>	
				</div>
			</section>
		<?php endif;
	}
}