<?php

class digix_elementor_special extends \Elementor\Widget_Base {

	public function get_name() 
    {
		return 'special-slider';
	}

	public function get_title() 
    {
		return __('special element','digix');
	}

	public function get_icon() 
    {
		return 'eicon-slider-device';
	}

	public function get_categories() 
    {
		return [ 'digix' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('special element','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'ms_important_note',
			[
				'label'           => '',
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __('special element','digix'),
				'content_classes' => '',
			]
		);
        
		$this->add_control(
			'title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'placeholder' => __('special products today','digix'),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'      => __('number of products','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
                'default'     => '10',
			]
		);

        $this->add_control(
            'special_timer',
            [
              'label' => __( 'Select Time', 'digix' ),
              'type' => \Elementor\Controls_Manager::DATE_TIME
            ]
        );
        $this->add_control(
			'attributes',
			[
				'label'        => __('show attributes','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
        $this->add_control(
			'special_bgcolor',
			[
				'label'       => __( 'special background color', 'digix' ),
				'type'        => \Elementor\Controls_Manager::COLOR,
				'default' => '#9172fb',
				'selectors' => [
                    '{{WRAPPER}} .im-special .special-box:before' => 'background-color: {{VALUE}} !important',
                    '{{WRAPPER}} .im-special .special-box:after' => 'background-color: {{VALUE}} !important',
                ],
			]
		);
		$this->add_control(
			'item_bgcolor',
			[
				'label'       => __( 'item active background color', 'digix' ),
				'type'        => \Elementor\Controls_Manager::COLOR,
				'default' => '#9172fb',
				'selectors' => [
                    '{{WRAPPER}} .im-special .special-box .special-content .special-list .special-list-container .swiper-wrapper .swiper-slide-active' => 'background-color: {{VALUE}} !important',
                    '{{WRAPPER}} .im-special .special-box .special-content .special-list .special-list-container .swiper-wrapper .special-item:hover' => 'background-color: {{VALUE}} !important',
                ],
			]
		);
		$this->add_control(
            'price_color',
            [
                'label' => __( 'price color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3ab54a',
                'selectors' => [
                    '{{WRAPPER}} .im-special .special-box .special-content .special-detailes .special-main .special-product-uri .special-product-content .special-product-price' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .im-special .special-box .special-content .special-detailes .special-main .special-product-uri .special-product-content .special-product-price ins' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'discount_color',
            [
                'label' => __( 'discount text color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .im-special .special-box .special-content .special-detailes .special-main .special-product-uri .special-product-content .special-product-price .product-sale' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                    '{{WRAPPER}} .digix-product .product-item .discount' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                ],
            ]
            );
        $this->add_control(
            'discount_bgcolor',
            [
                'label' => __( 'discount background color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',
                'selectors' => [
                    '{{WRAPPER}} .im-special .special-box .special-content .special-detailes .special-main .special-product-uri .special-product-content .special-product-price .product-sale' => 'background-color: {{VALUE}} !important',
                    '{{WRAPPER}} .digix-product .product-item .discount' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'timer_bgcolor',
            [
                'label' => __( 'timer background color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#9172fb',
                'selectors' => [
                    '{{WRAPPER}} .im-special .special-box .special-timer .timer-box .timer-amount' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
		$this->end_controls_section();
	}

	protected function render() 
    { 
        $settings = $this->get_settings_for_display();

		$title          = $settings['title'];
        $attributes   	= ! empty( $settings['attributes'] ) ? 1 : 0;
		$posts_per_page = ! empty( $settings['posts_per_page'] ) ? $settings['posts_per_page'] : 10;
        $timer          = $settings['special_timer'];
		$sale = wc_get_product_ids_on_sale();
		$products_args = array(
			'posts_per_page' => $posts_per_page,
			'no_found_rows' => 1,
			'post_status' => 'publish',
			'post_type' => 'product',
			'meta_query' => WC()->query->get_meta_query(),
			'post__in' => array_merge(array(0), wc_get_product_ids_on_sale()),
		);
		if(isset($_COOKIE['digixproductlocation']) && !empty(($_COOKIE['digixproductlocation']))){
			$product_city=explode(',', $_COOKIE['digixproductlocation']);
			if (!empty($product_city) && $product_city !== 0) {
				if (is_array($products_args["tax_query"])) {
					$products_args["tax_query"][] = ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city];
				} else {
					$products_args["tax_query"] = ["relation" => "AND", ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city]];
				}
			}
		}
        global $product;
		$products = new WP_Query( $products_args );
        $regular_price 	= get_post_meta( get_the_id(), '_sale_price_dates_to', true );
        if ( $products->have_posts() ) : ?>

            <section class="im-special">
                <div class="special-box">
                    <div class="special-header">
                        <span class="special-title"><?php echo $title; ?></span>
                        <?php if( !empty($timer) ): ?>
                        <div class="special-timer intimer" data-date="<?php echo $timer; ?>">
                            <script>
                            jQuery(function($) {
                                var dayz = new Date('<?php  echo $timer; ?>');
                                jQuery('.intimer').countdown({ 
                                    until: dayz, 
                                    layout: '<div class="timer-box"><span class="timer-amount">{dn}</span><span class="timer-label"><?php echo __('day','digix'); ?></span></div><div class="timer-box"><span class="timer-amount">{hn}</span><span class="timer-label"><?php echo __('hour','digix'); ?></span></div><div class="timer-box"><span class="timer-amount">{mn}</span><span class="timer-label"><?php echo __('minutes','digix'); ?></span></div><div class="timer-box"><span class="timer-amount">{sn}</span><span class="timer-label"><?php echo __('seconds','digix'); ?></span></div> '
                                });
                            });
                            </script>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="special-content">
                        <div class="special-detailes">
                            <div class="swiper-container special-main swiper-container-initialized swiper-container-horizontal swiper-container-rtl">
                                <div class="swiper-wrapper">
                                    <?php while ( $products->have_posts() ) : $products->the_post(); ?>
                                    <?php 
                                    $product = wc_get_product( $products->post->ID );
                                    $regular_price 	= get_post_meta(get_the_id(), '_sale_price_dates_to', true );
                                    ?>
                                        <a href="<?php echo $product->get_permalink(); ?>" class="swiper-slide special-product-uri">
                                            <?php echo( has_post_thumbnail() ? get_the_post_thumbnail( $products->post->ID, 'woocommerce_thumbnail', array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) ); ?>
                                            <div class="special-product-content">
                                                <h3 data-toggle="tooltip" data-placement="top" title="<?php echo $product->get_title(); ?>"><strong><?php echo $product->get_title(); ?></strong></h3>
                                                <div class="special-product-price">
                                                    <?php echo $product->get_price_html(); ?>   
                                                    <span class="product-sale">٪<?php echo digix_wooocmmerce_discount(get_the_ID()) ?></span>                         
                                                </div>
                                                <ul class="special-attributes-list">
                                                    <?php echo digix_woocommerce_attributes($product); ?>
                                                </ul>
                                                <div class="more-timer">
                                                    <span class="special-product-more"><?php echo __('view product','digix'); ?></span>
                                                    <?php if(!empty($regular_price)): ?>
                                                    <div class="special-timer timer-<?php $gshoprand=rand(); echo($gshoprand);?>" data-date="<?php  echo date( 'Y-m-d', $regular_price ); ?>">
                                                        <script>
                                                        jQuery(function($) {
                                                            var dayz = new Date('<?php  echo date( 'Y/m/d', esc_attr( $regular_price ) ); ?> 00:00:00');
                                                            jQuery('.timer-<?php  echo($gshoprand);?>').countdown({ 
                                                                until: dayz, 
                                                                layout: '<div class="timer-box"><span class="timer-amount">{dn}</span><span class="timer-label"><?php echo __('day','digix'); ?></span></div><div class="timer-box"><span class="timer-amount">{hn}</span><span class="timer-label"><?php echo __('hour','digix'); ?></span></div><div class="timer-box"><span class="timer-amount">{mn}</span><span class="timer-label"><?php echo __('minutes','digix'); ?></span></div><div class="timer-box"><span class="timer-amount">{sn}</span><span class="timer-label"><?php echo __('seconds','digix'); ?></span></div> '
                                                            });
                                                        });
                                                        </script>
                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                                    
                                            </div>
                                        </a>
                                    <?php endwhile;wp_reset_postdata(); ?>
                                </div>
                                <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
                            </div>
                        </div>
                        <div class="special-list">
                            <div class="swiper-container special-list-container swiper-container-initialized swiper-container-vertical swiper-container-rtl">
                                <div class="swiper-wrapper" style="transition-duration: 0ms;transform: translate3d(0px, 110.688px, 0px);">
                                    <?php while ( $products->have_posts() ) : $products->the_post(); ?>
                                    <?php $product = wc_get_product( $products->post->ID ); ?>
                                        <div class="swiper-slide special-item swiper-slide-active">
                                            <span class="special-item-sale">					
                                            ٪<?php echo digix_wooocmmerce_discount(get_the_ID()) ?> <?php echo __('discount','digix'); ?>
                                            </span>
                                            <div class="special-item-image">
                                                <?php echo( has_post_thumbnail() ? get_the_post_thumbnail( $products->post->ID, 'shop_thumbnail', array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'shop_thumbnail' ) ); ?>
                                            </div>

                                            <div class="special-item-title">
                                                <span class="item-product-title"><?php echo $product->get_title(); ?></span>
                                                <span>
                                                    <span class="woocommerce-Price-amount amount">
                                                        <?php echo wc_price($product->get_price()); ?>
                                                    </span>
                                                </span>
                                            </div>
                                        </div>	
                                    <?php endwhile;wp_reset_postdata(); ?>			
                                </div>
                                <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
    <?php
        endif;
	}

}