<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Digix
 */

get_header();
Global $post;
?>
<main class="main" role="main" itemscope itemprop="mainContentOfPage">
	<div class="container">
        <?php 
        if( function_exists('digix_breadcrumb')):
            echo digix_breadcrumb(); 
        endif;
        ?>
        <?php echo do_shortcode('[Digix_postnavigation]');?>	
        <?php $category= get_the_category(); $cat_id = $category[0] -> term_id;if ( have_posts() ) : ?>
            <section class="digix-post post-archive">
                <header class="page-header">
                    <h1 class="page-title">
                        <?php
                        /* translators: %s: search query. */
                        printf( __( 'Search Results for: %s', 'digix' ), '<span>' . get_search_query() . '</span>' );
                        ?>
                    </h1>
                </header>
                <div class="post-list">
                    <?php while ( have_posts() ) : the_post();?>
                    <?php $post_id = get_the_id();?>
                        <article class="post-item">
                            <div class="item-wrapper">
                                <figure class="thumbnail  position-relative">						
                                    <a href="<?php the_permalink($post_id); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark" class="d-block  img-style" style="background: url('<?php echo get_the_post_thumbnail_url(); ?>')">
                                    </a>
                                </figure>
                                <div class="item-content">
                                    <h3><a href="<?php the_permalink($post_id); ?>"><?php the_title(); ?></a></h3>
                                    <div class="item-detailes">
                                        <div class="item-heart">
                                            <?php $like_count =get_post_meta( $post_id, "_post_like_count", true );  if( $like_count <= '0' && $like_count == '' ){echo'0';}else{echo get_post_meta( $post_id, "_post_like_count", true );}?><i class="icon-heart"></i>
                                        </div>	
                                        <div class="item-date">
                                            <span><i class="icon-tinder"></i><?php echo digix_wp_get_views($post_id); ?></span>				
                                            <span><i class="icon-calendar"></i><?php $i = get_post_time(); $timestamp2 = strtotime(get_post_time()); echo dx_jdate('Y/m/d', $i); ?></span>
                                        </div>
                                        
                                    </div>
                                    <div class="item-info">
                                        <div><?php echo get_avatar( get_the_author_meta( 'ID' ), 25 ); ?><span><?php echo get_the_author_meta( 'display_name', get_the_author_meta('ID')  ); ?></span></div>
                                        <div>
                                            <?php if ( function_exists('rmp_get_visual_rating') && rmp_get_visual_rating($post_id) ) { ?>
                                                <span class="post-rate">
                                                    <div class="average-rate"><span class="average-rate"><?php echo str_replace('/',',',rmp_get_avg_rating($post_id)); ?></span>/5</div>
                                                    <div class="average-stars"><?php echo rmp_get_visual_rating($post_id); ?></div>
                                                </span>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </article>
                    <?php endwhile; ?>
                </div>
                
            </section>
        <?php endif; ?>
    </div>
</main>
<?php get_footer(); ?>