'use strict';

(function($) {
  var digix_timer = 0;
  var digix_auto_exclude = '#digix_search_keyword, #wpcsa_search_input, #woosc_search_input';

  if (digix.auto_exclude !== '') {
    digix_auto_exclude += ', ' + digix.auto_exclude;
  }

  // auto show
  if (digix.auto_show !== 'no') {
    $(document).
        on('click touch',
            'input[type="search"]:not(' + digix_auto_exclude + ')',
            function() {
              if (digix.auto_show === 'yes_inline') {
                var $this = $(this);
                var offset = $this.offset();
                var width = $this.outerWidth();
                var height = $this.outerHeight();

                $('#digix-area').
                    css('top', offset.top + height).css('left', offset.left).
                    css('width', width).css('max-width', width);
                digix_show('inline');
              } else {
                digix_toggle('popup');
              }
            });

    $(document).
        on('keyup', 'input[type="search"]:not(' + digix_auto_exclude + ')',
            function() {
              if (digix.auto_show === 'yes_inline') {
                var $this = $(this);
                var offset = $this.offset();
                var width = $this.outerWidth();
                var height = $this.outerHeight();

                $('#digix-area').
                    css('top', offset.top + height).css('left', offset.left).
                    css('width', width).css('max-width', width);
                digix_show('inline');
              } else {
                digix_toggle('popup');
              }

              var kw = $(this).val();

              if (kw !== '') {
                $('.digix-area').data('kw', kw);

                if (digix_timer != null) {
                  clearTimeout(digix_timer);
                }

                digix_timer = setTimeout(digix_ajax_search, 300);
                return false;
              }
            });
  }

  $(document).on('click touch', function(e) {
    if (($(e.target).closest('.digix-area').length === 0) && ($(e.target).
                closest('input[type="search"]:not(#digix_search_keyword)').length ===
            0) && ($(e.target).closest(digix.manual_show).length === 0) &&
        ($(e.target).closest('.digix-menu-item a').length === 0)) {
      digix_hide();
    }
  });

  // manual show
  if (digix.manual_show !== '') {
    $(document).on('click touch', digix.manual_show, function(e) {
      digix_toggle('popup');
      e.preventDefault();
    });
  }

  // search menu
  $(document).on('click touch', '.digix-menu-item a', function(e) {
    digix_toggle('popup');
    e.preventDefault();
  });

  $(document).on('click touch', '.digix-close', function() {
    digix_hide();
  });

  $(document).on('click touch', '.digix-popular-keywords a', function(e) {
    var kw = $(this).text();

    if ($('.digix-area').hasClass('digix-area-show-inline')) {
      $('input[type="search"]:not(#digix_search_keyword)').
          val(kw).
          trigger('keyup');
    } else {
      $('#digix_search_keyword').val(kw).trigger('keyup');
    }

    e.preventDefault();
  });

  $(document).on('keyup', '#digix_search_keyword', function() {
    var kw = $('#digix_search_keyword').val();

    if (kw !== '') {
      $('.digix-area').data('kw', kw);

      if (digix_timer != null) {
        clearTimeout(digix_timer);
      }

      digix_timer = setTimeout(digix_ajax_search, 300);
      return false;
    }
  });

  $(document).on('change', '#digix_search_cats', function() {
    if (digix_timer != null) {
      clearTimeout(digix_timer);
    }

    digix_timer = setTimeout(digix_ajax_search, 300);
    return false;
  });

  $(document).on('digix_show', function() {
    setTimeout(function() {
      $('#digix_search_keyword').get(0).focus();
    }, 300);
  });

  function digix_ajax_search() {
    $('.digix-search-input-icon').addClass('digix-loading');
    $('.digix-search-result').addClass('digix-loading');
    // ajax search product
    digix_timer = null;

    var data = {
      action: 'digix_search',
      keyword: $('.digix-area').data('kw'),
      category: $('#digix_search_cats').length ?
          $('#digix_search_cats').val() :
          0,
      nonce: digix.nonce,
    };

    $.post(digix.ajax_url, data, function(response) {
      $('.digix-search-result').html(response).removeClass('digix-loading');
      $('.digix-search-input-icon').removeClass('digix-loading');
      digix_perfect_scrollbar();
    });
  }
})(jQuery);

function digix_perfect_scrollbar() {
  jQuery('.digix-search-result').
      perfectScrollbar({suppressScrollX: true, theme: 'wpc'});
}

function digix_show(context = '') {
  if (context === 'popup') {
    jQuery('.digix-area').addClass('digix-position-' + digix.position);
  } else {
    jQuery('.digix-area').
        removeClass(
            'digix-position-01 digix-position-02 digix-position-03 digix-position-04 digix-position-05');
  }

  jQuery('body').addClass('digix-body-show digix-body-show-' + context);
  jQuery('.digix-area').addClass('digix-area-show digix-area-show-' + context);

  digix_perfect_scrollbar();

  jQuery(document.body).trigger('digix_show_' + context);
  jQuery(document.body).trigger('digix_show');
}

function digix_hide(context = '') {
  jQuery('.digix-area').
      attr('style', '').
      removeClass(
          'digix-area-show digix-area-show-inline digix-area-show-popup');

  jQuery('body').
      removeClass(
          'digix-body-show digix-body-show-inline digix-body-show-popup');

  setTimeout(function() {
    jQuery('.digix-area').addClass('digix-position-' + digix.position);
  }, 500);

  jQuery(document.body).trigger('digix_hide_' + context);
  jQuery(document.body).trigger('digix_hide');
}

function digix_toggle(context = '') {
  if (jQuery('body').hasClass('digix-body-show')) {
    digix_hide(context);
  } else {
    digix_show(context);
  }

  jQuery(document.body).trigger('digix_toggle_' + context);
  jQuery(document.body).trigger('digix_toggle');
}
