<?php
/*
 * Template Name: سبد خرید
 */
 
 
get_header(); 


Global $post;


 ?>
<?php if ( WC()->cart->get_cart_contents_count() == 0 ) : ?> 
<main class="main" itemscope itemprop="mainContentOfPage">
	<div class="container">
		<article class="cart-empty">
			<div class="cart-is-empty text-center">
				<div class="cart-is-empty-text">
					<h1><?php echo __('Your shopping cart is empty!','digix'); ?></h1>
					<p><?php echo __('On the main page, we introduce the best-selling and popular products. <br>It may be interesting for you, visit it.','digix'); ?></p>
					<a class="btn btn-success" href="<?php echo esc_url( home_url() ); ?>"><?php echo __('Home','digix'); ?></a>
				</div>
				<div class="cart-is-empty-img">
					<img src="<?php echo DIGIX_IMG . 'empty.png';?>" alt="سبد خرید شما خالی است.">
				</div>
			</div>
		</article>
	</div>
</main>
<?php else: ?>
<main class="main" itemscope itemprop="mainContentOfPage">
	<div class="container">
		<section class="checkout-process">
			<ul>
				<li class="nav <?php if ( is_page( 'cart' ) || is_cart() ) {echo'true-bar';}?>">
					<a href="<?php echo esc_url( wc_get_cart_url() ); ?>"></a>
					<p><?php echo __('cart','digix'); ?></p>
					<span>1</span>
				</li>
				<li class="bar <?php if ( is_page( 'cart' ) || is_cart() ) {echo'true-bar';}?>">
					<span></span>
				</li>
				<li class="nav <?php if ( is_checkout() || is_page('checkout') ) {echo'true-bar';}?>">
					<a href="<?php echo esc_url( wc_get_checkout_url() ); ?>"></a>
					<p><?php echo __('checkout','digix'); ?></p>
					<span>2</span>
				</li>
				<li class="bar <?php if ( is_checkout() || is_page('checkout') ) {echo'true-bar';}?>">
					<span></span>
				</li>
				<li class="nav">
					<p><?php echo __('invoice','digix'); ?></p>
					<span>3</span>
				</li>
			</ul>
		</section>
		<?php if ( have_posts() ): ?>
			<?php while ( have_posts() ):the_post(); ?>
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<?php the_content(); ?>
				</article>
			<?php endwhile; ?>
		<?php endif; ?>
	</div>
</main>
<?php endif; ?>

<?php


get_footer();


?>