<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
global $options;
$attributes = $options['woocommerce-archive-attributes'];
$pitem_boxshadow = $options['woocommerce-pitem-boxshadow'];
// Ensure visibility.
if ( empty( $product ) || false === wc_get_loop_product_visibility( $product->get_id() ) || ! $product->is_visible() ) {
	return;
}
$attachment_ids = get_gallery_image_ids( $product );
?>
<div class="product-item <?php if(  $pitem_boxshadow != 'yes' ) {echo'no-boxshadow';}?>">
	<?php if($product->is_on_sale()){ ?>
		<div class="discount <?php if($attributes == 'yes'){echo'left-auto right-10';}?>">
			٪<?php echo digix_wooocmmerce_discount(get_the_ID()) ?>
		</div>
	<?php } ?>
	<?php if ( $options['woocommerce-archive-attributes'] == 'yes' ) : ?>
		<?php if ( function_exists( 'wpcvs_init' ) ) {?>
		<div class="product-attribute">
			<?php echo do_shortcode('[dx_attributes]');do_action('digix_woocommerce_before_thumbnails');?>
		</div>
		<?php } ?>
	<?php endif; ?>
	<figure class="product-thumbnails <?php  if ( $attachment_ids ) {echo'has-gallery';}?>">
		<a href="<?php echo $product->get_permalink(); ?>">
			<?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(), 'woocommerce_thumbnail', array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) );do_action('wc_secondary_thumbnails'); ?>
		</a>
	</figure>
	<div class="product-detailes">
		<h2>
			<a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a>
		</h2>
		<div class="product-add <?php if ( $options['woocommerce-addcart'] != 'yes' ){echo'justify-content-center text-center';}?>">
			<div class="product-price">
			<?php if ( ! $product->is_in_stock() ) {
					echo'<div class="OutStock">' . __( "Out Of Stock", "digix" ) . '</div>';
			}else{
					echo $product->get_price_html();
					
			} ?>
			</div>
			<?php if ( $product->is_in_stock() ) {if ( $options['woocommerce-addcart'] == 'yes' ) : ?>
				<button class="add-to-cart-wrap" data-toggle="tooltip" data-original-title="<?php echo esc_html( $product->add_to_cart_text() );?>">
					<a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" data-quantity="1" class="<?php echo esc_attr( implode( ' ', array_filter( array( 'button', 'product_type_' . $product->get_type(), $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '', $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '', ) ) ) );?>" <?php echo wc_implode_html_attributes( array( 'data-product_id'  => $product->get_id(), 'data-product_sku' => $product->get_sku(), 'aria-label'       => $product->add_to_cart_description(), 'rel'              => 'nofollow',) );?>><i class="icon-shopping-basket"></i></a>
				</button>
			<?php endif;} ?>
		</div>
	</div>
</div>
