<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
Global $product;
global $options;
$slide_per_view = $options['woocommerce-related-number'];
$text_align     = $options['woocommerce-related-align'];
$attributes = $options['woocommerce-archive-attributes'];
$pitem_boxshadow = $options['woocommerce-pitem-boxshadow'];
if($slide_per_view <= 5){
	$arr = array(200,200);
	$size = '200px';
}else if($slide_per_view >= 5){
	$arr = array(150,150);
	$size = '150px';
}
if ( $upsells ) : ?>

	<section class="related im-product products">
		<div dir="rtl" class="swiper-container im-swiper-product <?php echo $text_align . '-item';?> swiper-html" data-swiper='{"spaceBetween": 10, "slidesPerView":<?php echo $slide_per_view; ?>, "loop": false, "navigation": {"nextEl": ".swiper-button-next", "prevEl": ".swiper-button-prev"}, "breakpoints": {"320": {"slidesPerView":2},"991": {"slidesPerView":5},"1100": {"slidesPerView":<?php echo $slide_per_view; ?>}}}'>
		<!-- Add Arrows -->
            <div class="swiper-button-next"></div>
            <?php
				$heading = apply_filters( 'woocommerce_product_upsells_products_heading', __( 'You may also like&hellip;', 'woocommerce' ) );
                if ( $heading ) :
                    ?>
                    <h3 class="<?php echo $text_align; ?>"><strong><?php echo esc_html( $heading ); ?></strong></h3>
                <?php endif; ?>					
            <div class="swiper-button-prev"></div>
			<div class="swiper-wrapper">

			<?php foreach ( $upsells as $upsell ) : ?>

				<?php
				$post_object = get_post( $upsell->get_id() );

				setup_postdata( $GLOBALS['post'] =& $post_object );$product = wc_get_product( get_the_ID() );?>
				
				<div class="swiper-slide">
					<div class="product-item <?php if(  $pitem_boxshadow != 'yes' ) {echo'no-boxshadow';}?>">
						<?php if($product->is_on_sale()){ ?>
							<div class="discount <?php if($attributes == 'yes'){echo'left-auto right-10';}?>">
								٪<?php echo digix_wooocmmerce_discount(get_the_ID()) ?>
							</div>
						<?php } ?>
						<?php if ( $options['woocommerce-archive-attributes'] == 'yes' ) : ?>
						<?php if ( function_exists( 'wpcvs_init' ) ) {?>
							<div class="product-attribute">
								<?php echo do_shortcode('[dx_attributes]');do_action('digix_woocommerce_before_thumbnails');?>
							</div>
						<?php } ?>
						<?php endif; ?>
						<figure class="product-thumbnails">
							<a href="<?php echo $product->get_permalink(); ?>" style="width:<?php echo $size; ?>;height: <?php echo $size; ?>;">
								<?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(), $arr, array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) );digix_second_thumbnail($arr); ?>
							</a>
						</figure>
						<div class="product-detailes">
							<h2>
								<a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a>
							</h2>
							<div class="product-add <?php if ( $options['woocommerce-addcart'] != 'yes' ){echo'justify-content-center text-center';}?>">
								<div class="product-price">
								<?php if ( ! $product->is_in_stock() ) {
										echo'<div class="OutStock">' . __( "Out Of Stock", "digix" ) . '</div>';
								}else{
										echo $product->get_price_html();
										
								} ?>
								</div>
								<?php if ( $product->is_in_stock() ) {if ( $options['woocommerce-addcart'] == 'yes' ) : ?>
									<button class="add-to-cart-wrap" data-toggle="tooltip" data-original-title="<?php echo esc_html( $product->add_to_cart_text() );?>">
										<a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" data-quantity="1" class="<?php echo esc_attr( implode( ' ', array_filter( array( 'button', 'product_type_' . $product->get_type(), $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '', $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '', ) ) ) );?>" <?php echo wc_implode_html_attributes( array( 'data-product_id'  => $product->get_id(), 'data-product_sku' => $product->get_sku(), 'aria-label'       => $product->add_to_cart_description(), 'rel'              => 'nofollow',) );?>><i class="icon-shopping-basket"></i></a>
									</button>
								<?php endif;} ?>
							</div>
						</div>
					</div>
				</div>

			<?php endforeach; ?>
			</div>
		</div>
	</section>

	<?php
endif;

wp_reset_postdata();
