<?php
/**
 * The Template for displaying all single posts.
 *
 * @package dokan
 * @package dokan - 2014 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$store_user   = dokan()->vendor->get( get_query_var( 'author' ) );
$store_info   = $store_user->get_shop_info();
$map_location = $store_user->get_location();
$layout       = get_theme_mod( 'store_layout', 'left' );

get_header();
?>
<main class="main" role="main" itemscope itemprop="mainContentOfPage">
	<div class="mobtainer woocommerce">
		<?php
		/**
		 * Hook: woocommerce_before_main_content.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 * @hooked WC_Structured_Data::generate_website_data() - 30
		 * @hooked woocommerce_output_all_notices - 40
		 */
		do_action( 'woocommerce_before_main_content' );
		?>
		<section class="wc-archive">
			<div class="wc-content">
				<div  class="digix-single-store">
					<div class="store-page-wrap woocommerce" role="main">
						<?php dokan_get_template_part( 'store-header' ); ?>
						<?php if ( have_posts() ) { ?>
						<section class="digix-product woocommerce-archive">
							<section class="archive-filter">
								<button class="left" type="button" data-toggle="modal" data-target="#digix-filter"><i class="icon-sort"></i>فیلتر کردن</button>
								<button class="right" type="button" data-toggle="modal" data-target="#digix-catelog"><i class="icon-spreadsheet-app"></i>مرتب سازی</button>
							</section>
							<div class="element-product">

								<?php woocommerce_product_loop_start(); ?>

								<?php
								while ( have_posts() ) :
									the_post();
									?>

									<?php wc_get_template_part( 'content', 'product' ); ?>

								<?php endwhile; // end of the loop. ?>

								<?php woocommerce_product_loop_end(); ?>

							</div>

							<?php dokan_content_nav( 'nav-below' ); ?>
						</section>
						<?php } else { ?>

							<p class="dokan-info"><?php esc_html_e( 'No products were found of this vendor!', 'dokan-lite' ); ?></p>

						<?php } ?>
					</div>

				</div><!-- .dokan-single-store -->
			</div>
		</section>
	</div>
</main>
<?php do_action( 'woocommerce_after_main_content' ); ?>
<div class="modal fade toggle-tab" id="digix-catelog">
  <div class="modal-dialog">
	<div class="modal-content">

	  <!-- Modal Header -->
	  <div class="modal-header">
		<h4 class="modal-title">مرتب سازی محصولات</h4>
		<button type="button" class="close" data-dismiss="modal">بازگشت<i class="icon-arrow-left"></i></button>
	  </div>

	  <!-- Modal body -->
	  <div class="modal-body">
			<ul class="catelog-list">
				<?php if ( is_array( $orderby_options['catalogs'] ) && isset( $orderby_options['orderby'] ) ) : ?>
					<?php 
						foreach ( $orderby_options['catalogs'] as $id => $name ) : 
							$name = str_replace( 'سازی', '', esc_html( $name ) );
							$name = str_replace( 'بر', '', esc_html( $name ) );
							$name = str_replace( 'اساس', '', esc_html( $name ) );
							$name = str_replace( 'مرتب', '', esc_html( $name ) );
							$name = str_replace( '', '', esc_html( $name ) );
					?>
						<li class="catelog-item <?php echo $orderby == $id ? 'active' : ''; ?>">
							<a href="?product-orderboy=<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $name ); ?></a>
						</li>
					<?php endforeach; ?>
				<?php endif; ?>
		  </ul>
	  </div>

	  <!-- Modal footer -->
	  <div class="modal-footer">
		<button type="button" class="btn btn-danger w-100" data-dismiss="modal"><?php echo __('Close','digix');?></button>
	  </div>

	</div>
  </div>
</div>
<?php get_footer( 'shop' ); ?>
