<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Digix functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Digix
 */

if ( ! function_exists( 'WC' ) ) {
	if ( $GLOBALS['pagenow'] == 'wp-login.php' || is_admin() ) {
		// nothing
	} else {
		wp_die( "<div class='otice notice-error'><p>" . __( 'Install and activate the Woocommerce plugin to use the template ', 'digix' ) . "</p></div>" );
	}
}
#
##
# Define PATH and URI for Template
 
define("DIGIX_DIR", get_template_directory());
define("DIGIX_URI", get_template_directory_uri());
define("DIGIX_IMG", get_template_directory_uri() . '/static/img/');
define("DIGIX_VER", "1.0.0");

add_theme_support( 'title-tag' );
function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');



// Load Mobile Detect Class
if ( class_exists( 'Mobile_Detect' ) ) {
	global $device_detect;
	$device_detect = new Mobile_Detect;
}
require_once DIGIX_DIR .'/includes/framework/codestar-framework.php';
require_once DIGIX_DIR .'/includes/options.php';
require_once DIGIX_DIR .'/includes/metabox.php';
require_once DIGIX_DIR . '/includes/class-main.php';
require_once DIGIX_DIR . '/includes/functions.php';
require_once DIGIX_DIR . '/includes/elementor.php';
require_once DIGIX_DIR . '/includes/includes.php';
require_once DIGIX_DIR . '/includes/avatar.php';


function guard_digix_mobile()
{
	if ( class_exists('Digix_Guard') ) 
	{
		if( Digix_Guard::is_activated() != true ) 
		{
			echo'<div class="notice notice-info is-dismissible"><p class="no-license">برای فعال شدن نسخه آداپتیو قالب دیجیکس باید لایسنس محصول را ثبت نمایید</p></div>';
		}
	}
}
add_action('admin_notices', 'guard_digix_mobile');


/**
 * Note: Do not add any custom code here.
 * Please read the documentation about making custom changes so that your customizations aren't lost during updates.
*/

add_action( 'wp_enqueue_scripts', 'wsis_dequeue_stylesandscripts_select2', 100 );

function wsis_dequeue_stylesandscripts_select2() {
    if ( class_exists( 'woocommerce' ) ) {
        wp_dequeue_style( 'selectWoo' );
        wp_deregister_style( 'selectWoo' );

        wp_dequeue_script( 'selectWoo');
        wp_deregister_script('selectWoo');
    } 
}


/*
 * Let WordPress manage the document title.
 * By adding theme support, we declare that this theme does not use a
 * hard-coded <title> tag in the document head, and expect WordPress to
 * provide it for us.
 */

add_theme_support( 'title-tag' );


function digix_wp_register_menus() 
{
	register_nav_menus( array( 'mobile' => __('mobile menus','digix') ) );
	register_nav_menus( array( 'primary' => __('Megamenu','digix') ) );
	register_nav_menus( array( 'header' => __('Header Menu','digix') ) );
	register_nav_menus( array( 'footer' => __('Footer Menu','digix') ) );
	register_nav_menus( array( 'blog' => __('Blog Menu','digix') ) );
}
add_action( 'init', 'digix_wp_register_menus' );
add_theme_support( 'menus' );




#
##
# Register Siebar

register_sidebar(array(
	'name' 				=> __('shop sidebar','digix'),
	'id' 				=> 'shop', 
	'before_title' 		=> '<header class="widget-header"><h3 class="widget-title">', 
	'after_title' 		=> '</h3></header><figure class="widget-content">',
	'before_widget' 	=> '<div class="%2$s widget">',
	'after_widget' 		=> '</figure></div>', 
 ));

