<html <?php language_attributes(); ?>>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no, minimal-ui">

    <?php wp_head(); ?>
    
</head>
<?php Global $options;?>
<body <?php body_class();?>>
	<div class="panel-overlay"></div>
	<?php if( $options['mobile-header'] == 'modern' ):?>
	<?php if ( is_product() && is_single() ){?>
		<header class="header-modern-single">
			<div class="ms-list">
				<div class="right">
					<button type="button" class="btn-back ms-item" onclick="window.history.back()">
						<i class="icon-arrow-right"></i>
					</button>
					<a href="<?php echo esc_url( home_url() ); ?>" class="ms-item">
						<i class="icon-house"></i>
					</a>
					<div class="ms-item">
						<a href="#" class="link open-panel">
							<i class="icon-bars"></i>
						</a>
						<a href="#" class="link close-panel">
							<i class="icon-close"></i>
						</a>
					</div>
					<a href="<?= home_url( "?s=&post_type=product" ); ?>" class="btn-serch ms-item">
						<i class="icon-search"></i>
					</a>
				</div>
				<div class="left">
					<div class="ms-item">
						<a class="feature" href="<?php if(class_exists( 'WC_Product' )){echo get_permalink( wc_get_page_id( 'cart' ) );}else{echo'#';} ?>">
							<i class="icon-cart"></i><span class="cart-count" id="toolbox_cart"><?php if(class_exists( 'WC_Product' )){ if ( is_null(WC()->cart) ) {} else {echo WC()->cart->cart_contents_count;}}else{echo'0';} ?></span>
						</a>
						<?php echo do_shortcode('[wish_btn_single_product]');?>
						<button class="single-more">
							<svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="20" height="20" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g transform="matrix(1,0,0,1,190,0)"><path d="M128 256c0 35.348-28.652 64-64 64S0 291.348 0 256s28.652-64 64-64 64 28.652 64 64zM128 64c0 35.348-28.652 64-64 64S0 99.348 0 64 28.652 0 64 0s64 28.652 64 64zM128 448c0 35.348-28.652 64-64 64S0 483.348 0 448s28.652-64 64-64 64 28.652 64 64zm0 0" fill="#000000" data-original="#000000" class=""></path></g></svg>
						</button>
					</div>
				
				</div>
			</div>
		</header>
		<section class="product-action ms-header">
			<?php do_action('digix_wc_single_action');?>
		</section>
	<?php }else{ ?>
		<header class="header-modern">
			<div class="mobtainer">
				<div class="header-item">
						<div class="right">
							<a href="#" class="link open-panel">
								<i class="icon-bars"></i>
							</a>
							<a href="#" class="link close-panel">
								<i class="icon-close"></i>
							</a>
						</div>
						<div class="center">
							<a href="<?php echo esc_url( home_url() ); ?>" class="im-uri">
								<img src="<?php echo $options['mobile-logo'];?>" alt="<?php bloginfo('name'); ?>" class="img-fluid" itemprop="logo">
							</a>
						</div>
						<div class="left">
						<?php 
							$server = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
							$home   = esc_url( home_url() ).'/';
							if ( $server == $home ):?>
								<a href="<?php echo $options['mobile-faqs'];?>">
									<i class="<?php echo $options['mobile-faqs-icon'];?>"></i>
								</a>
							<?php else:?>
								<button type="button" class="btn-back" onclick="window.history.back()">
									<i class="icon-arrow-left"></i>
								</button>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</header>
	<?php } ?>
	<div class="zeynep right modern-slidemenu">
		<?php
			wp_nav_menu(array(  
				'theme_location'  	=> 'mobile',
				'menu' 				=> 'Main Navigation', 
				'container_id' 		=> 'digix_sidemenu', 
				'walker' 			=> new digix_sidemenu()
			));
		?>
	</div>
	<?php
		if( $options['contact-floating'] == 'yes'){ ?>
			<div class="modern-social">
				<ul class="list">
				<?php
					if(  $options["whatsapp-activate"] == true) : 
					echo'<li>
					   <a href="https://wa.me/' . $options["contact-whatsapp"] . '"> <i class="icon-whatsapp"></i> </a>
					 </li>';
					endif;
					if(  $options["twitter-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-twitter"] . '"> <i class="icon-twitter"></i> </a>
					 </li>';
					endif;
					if(  $options["facebook-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-facebook"] . '"> <i class="icon-facebook"></i> </a>
					 </li>';
					endif;
					if(  $options["telegram-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-telegram"] . '"> <i class="icon-telegram"></i> </a>
					 </li>';
					endif;
					if(  $options["instagram-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-instagram"] . '"> <i class="icon-instagram"></i> </a>
					 </li>';
					endif;

					if(  $options["sapp-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-sapp"] . '"> <i class="icon-sapp"></i> </a>
					 </li>';
					endif;

					if(  $options["gap-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-gap"] . '"> <i class="icon-gap"></i> </a>
					 </li>';
					endif;

					if(  $options["bale-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-bale"] . '"> <i class="icon-bale"></i> </a>
					 </li>';
					endif;

					if(  $options["rubika-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-rubika"] . '"> <i class="icon-rubika"></i> </a>
					 </li>';
					endif;

					if(  $options["eitaa-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-eitaa"] . '"> <i class="icon-eitaa"></i> </a>
					 </li>';
					endif;
				?>
				</ul>
			</div>
	<?php } ?>
	<div class="zeynep-overlay"></div>
	<?php else: ?>
	<header class="header-mobile">
		<section class="up">
			<div class="mobtainer">
				<div class="hm-item">
					<div class="right">
						<a href="#" class="link open-panel">
							<i class="icon-bars"></i>
							<span><?php echo __('menu','digix'); ?></span>
						</a>
						<a href="#" class="link close-panel">
							<i class="icon-close"></i>
							<span><?php echo __('close','digix'); ?></span>
						</a>
					</div>
					<div class="center">
						<a href="<?php echo esc_url( home_url() ); ?>" class="im-uri">
							<img src="<?php echo $options['mobile-logo'];?>" alt="<?php bloginfo('name'); ?>" class="img-fluid" itemprop="logo">
						</a>
					</div>
					<div class="left">
						<a href="<?php echo $options['mobile-faqs'];?>">
							<i class="<?php echo $options['mobile-faqs-icon'];?>"></i>
						</a>
					</div>
				</div>
			</div>
		</section>
		<section class="down">
			<div class="mobtainer">
				<div class="hm-item">
					<form class="search" role="search" method="get" data-custom-search="true" action="<?php echo esc_url( home_url( '/' ) ); ?>" >
						<input type="search" placeholder="<?php echo $options['search-title']; ?>" name="s">
						<input type="hidden" name="post_type" value="product">
						<button type="submit">
							<i class="icon-search"></i>
						</button>
					</form>
					<div class="cart-user">
						<?php if ( is_user_logged_in() ) : ?>
							<a href="<?php if(class_exists( 'WC_Product' )){ echo get_permalink( get_option('woocommerce_myaccount_page_id') );}else{echo'#';} ?>" class="user"><i class="icon-user"></i></a>
						<?php else: ?>
							<?php if( $options['woocommerce-digits'] == '1' ) { ?>
								<?php if ( $options['woocommerce-digits-type'] == 'popup' ) { ?>
									<button style="background:0;border:0;outline:0;position:relative;color:#666;font-size:22px;font-weight:400;box-shadow: none;" href="?login=true" onclick="jQuery('this').digits_login_modal(jQuery(this));return false;" attr-disclick="1" class="digix-digit-btn user btn digits-login-modal" type="1">
										<i class="icon-user"></i>
									</button>
								<?php }else{ ?>
									<a href="<?php echo $options['woocommerce-redirect-login']; ?>" class="user"><i class="icon-user"></i></a>
								<?php } ?>
							<?php }else{ ?>
								<a href="<?php if(class_exists( 'WC_Product' )){ echo get_permalink( get_option('woocommerce_myaccount_page_id') );}else{echo'#';} ?>" class="user"><i class="icon-user"></i></a>
							<?php } ?>
						<?php endif; ?>
						<a href="<?php if(class_exists( 'WC_Product' )){echo get_permalink( wc_get_page_id( 'cart' ) );}else{echo'#';} ?>" class="cart"><i class="icon-shopping-basket"></i><span class="cart-count"><?php if(class_exists( 'WC_Product' )){ if ( is_null(WC()->cart) ) {} else {echo WC()->cart->cart_contents_count;}}else{echo'0';} ?></span></a>
					
					</div>
				</div>
			</div>
		</section>
	</header>
	
	<div class="zeynep right zeynep-default">
	<div class="zeynep-user">
		<?php if ( is_user_logged_in() ) : ?>
			<div class="zeynep-avatar">
				<svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="80" height="80" x="0" y="0" viewBox="0 0 496 496" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g transform="matrix(1.000000000000001,0,0,1.000000000000001,75,-1.1368683772161603e-13)"><path fill="#28a7e6" d="M343.664 172.5C343.664 77.23 266.73 0 171.832 0S0 77.23 0 172.5 76.934 345 171.832 345s171.832-77.23 171.832-172.5zm0 0" data-original="#28a7e6" class=""></path><path fill="#ffffff" d="M276.457 94.523c-3.125-9.945-10.336-32.214-31.984-49.945-25.305-20.969-54.059-21.726-62.993-21.617-55.886-5.73-86.148 27.027-86.148 27.027-20.46 14.489-7.434 36.325-7.434 36.325-4.09 3.566-8.183 7.027-12.273 10.593a82.243 82.243 0 0 0-1.887 4.965c-5.789 16.883-4.949 32.406-3.27 44.414h-.175c.39 2.344.828 4.621 1.262 6.895.07.39.136.793.203 1.172a150.241 150.241 0 0 0 3.097 13.957c8.973 36.644 22.813 63.234 33.184 79.945 21.504 34.633 37.715 42.453 47.273 45.726 4.739 1.622 22.614 6.918 42.536 0 11.879-4.125 25.39-13.054 43.718-43.89 7.493-12.602 16.77-30.543 24.692-53.903-.035.47-.067 1.004-.098 1.454 4.98-11.07 11.313-28.352 13.637-50.36 1.394-13.23 3.433-31.18-3.34-52.758zm0 0" data-original="#ffffff" class=""></path><path fill="#173851" d="M176.883 301.469c-10.414 0-18.715-2.285-22.863-3.703-10.88-3.727-27.829-12.692-49.38-47.407-15.132-24.367-26.46-51.656-33.671-81.097a152.606 152.606 0 0 1-3.156-14.23l-.204-1.18a298.36 298.36 0 0 1-1.261-6.903 3.954 3.954 0 0 1-.004-1.304c-1.469-11.036-2.485-27.31 3.61-45.075a84.886 84.886 0 0 1 1.98-5.207 4.014 4.014 0 0 1 1.062-1.472c2.067-1.797 4.133-3.575 6.2-5.348a698.47 698.47 0 0 0 3.71-3.191c-4.32-9.59-6.515-26.606 9.79-38.391 3.519-3.648 34.23-33.504 88.96-28 14.371-.234 41.36 2.644 65.367 22.543 22.844 18.71 30.137 41.918 33.254 51.828 6.918 22.043 4.98 40.383 3.563 53.777l-.067.594c-1.882 17.817-6.582 35.168-13.964 51.586-.2.434-.465.824-.782 1.149-6.414 18.277-14.484 35.66-24.02 51.699-19.605 32.984-34.175 41.57-45.843 45.629-7.945 2.75-15.55 3.703-22.281 3.703zM74.44 146.785c.332 1.906.688 3.774 1.047 5.64l.211 1.243a144.603 144.603 0 0 0 3.02 13.59c7.039 28.726 18.039 55.234 32.726 78.887 20.2 32.542 35.45 40.726 45.172 44.05 4.719 1.618 21.555 6.39 39.922.004 10.305-3.578 23.3-11.386 41.594-42.156 9.758-16.426 17.945-34.309 24.336-53.145a3.989 3.989 0 0 1 1.347-1.882 160.528 160.528 0 0 0 12.004-46.16l.063-.598c1.344-12.695 3.183-30.082-3.238-50.54-2.903-9.226-9.688-30.835-30.704-48.05-22.187-18.39-47.316-20.914-60.418-20.715a4.349 4.349 0 0 1-.453-.02C127.734 21.497 98.56 52.38 98.273 52.696c-.187.203-.402.39-.625.547-17.25 12.211-6.761 30.25-6.308 31.012a4.003 4.003 0 0 1-.805 5.066c-2.043 1.782-4.082 3.532-6.125 5.285-1.808 1.56-3.625 3.114-5.437 4.692a69.264 69.264 0 0 0-1.442 3.867c-5.761 16.797-4.527 32.332-3.09 42.559.04.355.04.715 0 1.062zm0 0" data-original="#173851"></path><path fill="#ffffff" d="m210.012 290.371-15.875 5.883c-6.09 2.254-12.461 3.469-18.88 3.777-10.23.492-20.362-2.222-29.644-6.57l-8.96-4.898-15.59 28.28 18.835 14.438c9.465 5.176 25.399 8.957 36.176 8.762l.305-.004c9.582-.172 18.988-4.828 27.484-9.27l26.453-15.007zm0 0" data-original="#ffffff" class=""></path><path fill="#173851" d="M175.54 344.047c-11.767 0-27.935-3.996-37.56-9.254a5.044 5.044 0 0 1-.515-.332l-18.84-14.438a4.007 4.007 0 0 1-1.074-5.109l15.59-28.277a3.997 3.997 0 0 1 5.418-1.582l8.96 4.898c9.454 4.418 18.79 6.5 27.536 6.082 6.203-.297 12.148-1.488 17.683-3.535l15.88-5.879a4.01 4.01 0 0 1 4.515 1.25l20.3 25.387a3.989 3.989 0 0 1 .801 3.25 3.994 3.994 0 0 1-1.953 2.722l-26.453 15.008c-9.71 5.09-19.172 9.614-29.387 9.797-.293.008-.597.012-.902.012zm-33.454-16.133c8.723 4.684 23.95 8.352 33.914 8.133 8.773-.156 17.297-4.262 26.008-8.824l22.254-12.625-15.57-19.47-13.169 4.876c-6.304 2.332-13.058 3.684-20.078 4.023-10.054.489-20.66-1.851-31.535-6.941l-5.683-3.102-12.008 21.782zm0 0" data-original="#173851"></path><path fill="#d4dedd" d="m230.316 318.938-5.632.015-20.825 11.817c-8.496 4.445-17.902 9.097-27.484 9.27l-.305.003c-10.773.195-26.707-3.586-36.175-8.762l-15.743-12.07-6.164.016c-46.093 9.472-80.785 50.433-80.785 99.496v42.347h275.375v-42.347c.008-49.586-35.433-90.895-82.262-99.785zm0 0" data-original="#d4dedd" class=""></path><path fill="#173851" d="M312.586 465.074H37.207c-2.21 0-4-1.789-4-4v-42.347c0-49.918 35.316-93.414 83.977-103.414a3.88 3.88 0 0 1 .793-.086l6.164-.016c.949-.137 1.742.289 2.445.828l15.492 11.875c8.727 4.684 23.953 8.352 33.918 8.133 8.774-.156 17.297-4.262 26.008-8.824l20.707-11.75a3.968 3.968 0 0 1 1.96-.52l5.634-.015c.129-.032.507.019.754.07 49.558 9.406 85.52 53.027 85.52 103.719v42.347a3.984 3.984 0 0 1-3.993 4zm-271.379-8h267.379v-38.347c0-46.727-33.05-86.95-78.64-95.786l-4.2.008-19.914 11.293c-9.71 5.09-19.172 9.613-29.387 9.797-11.715.164-28.593-3.848-38.465-9.246a4.487 4.487 0 0 1-.515-.336L122.8 323.215l-4.399.012c-44.754 9.394-77.199 49.488-77.199 95.5zm0 0" data-original="#173851"></path><path fill="#ffffff" d="M70.293 152.883c-14.047 6.832-21.129 22.87-16.848 37.52 4.059 13.906 17.426 23.406 32.196 22.644l-13.883-58.695" data-original="#ffffff" class=""></path><path fill="#173851" d="M84.023 217.09c-15.73 0-30.023-10.504-34.414-25.563-4.816-16.488 3.325-34.648 18.934-42.238 1.906-.934 4.18-.203 5.223 1.606a4.01 4.01 0 0 1 1.882 2.539l13.887 58.691a3.998 3.998 0 0 1-.691 3.324 3.997 3.997 0 0 1-2.992 1.59 35.82 35.82 0 0 1-1.829.05zm-15.402-58.625c-9.883 6.7-14.7 19.293-11.332 30.824 3.078 10.547 12.45 18.211 23.254 19.582zm0 0" data-original="#173851"></path><path fill="#ffffff" d="M281.89 154.54c11.512 2.995 17.403 18.78 13.145 35.253-4.254 16.473-21.101 27.394-32.62 24.394zm0 0" data-original="#ffffff" class=""></path><path fill="#173851" d="M266.477 218.691a19.95 19.95 0 0 1-5.07-.632 3.995 3.995 0 0 1-2.5-1.95 3.986 3.986 0 0 1-.29-3.16l19.473-59.648a4.002 4.002 0 0 1 4.805-2.63c13.625 3.548 20.808 21.544 16.007 40.122-2.476 9.613-9.18 18.422-17.914 23.562-4.86 2.86-9.86 4.336-14.511 4.336zm17.851-58.726-16.539 50.66c2.879-.262 6.043-1.34 9.14-3.164 6.946-4.09 12.266-11.07 14.235-18.668 3.145-12.191.035-24.262-6.836-28.828zm0 0" data-original="#173851"></path><path fill="#d4dedd" d="M84.18 159.488c2.504-14.324 3.828-21.66 7.308-30.082 2.782-6.726 5.813-14.066 12.45-21.031 11.374-11.938 25.738-14.773 32.53-16.117 21.954-4.344 40.157 3.066 45.981 5.187 17.227 6.27 18.52 11.782 31.766 15.676 16.691 4.863 32.738 1.293 44.582-3.027a310.393 310.393 0 0 1 5.168 27.383c2.527 17.765 2.86 31.218 2.922 34.484.21 10.32-.219 19.078-.73 25.68 4.98-11.07 11.312-28.352 13.636-50.36 1.394-13.23 3.434-31.18-3.34-52.758-3.125-9.945-10.336-32.214-31.984-49.945-25.301-20.969-54.055-21.726-62.989-21.617-55.886-5.73-86.148 27.027-86.148 27.027-20.46 14.489-7.434 36.325-7.434 36.325-4.09 3.566-8.183 7.027-12.273 10.593a85.004 85.004 0 0 0-1.887 4.965c-7.191 20.961-4.164 39.844-1.984 52.484 1.351 7.848 3.844 18.56 8.77 30.817a411.494 411.494 0 0 1 3.656-25.684zm0 0" data-original="#d4dedd" class=""></path><path fill="#173851" d="M266.156 201.64a3.999 3.999 0 0 1-3.988-4.309c.648-8.339.89-16.847.719-25.292-.086-4.77-.555-17.637-2.883-34a305.417 305.417 0 0 0-4.121-22.726c-15.39 4.878-29.758 5.445-42.785 1.648-7.118-2.094-11.098-4.645-15.313-7.344-4.14-2.656-8.422-5.402-16.7-8.414l-1.019-.375c-6.32-2.332-23.105-8.547-42.824-4.652-6.465 1.281-19.914 3.941-30.414 14.957-6.125 6.426-8.93 13.222-11.64 19.797-3.25 7.86-4.516 14.644-7.067 29.242a410.563 410.563 0 0 0-3.621 25.43 4.002 4.002 0 0 1-3.434 3.523c-1.785.242-3.57-.77-4.25-2.473-4.125-10.265-7.152-20.91-9-31.629-2.07-12.007-5.527-32.109 2.141-54.464a84.886 84.886 0 0 1 1.98-5.207A4.014 4.014 0 0 1 73 93.879c2.066-1.8 4.133-3.574 6.2-5.348 1.241-1.058 2.472-2.125 3.71-3.191-4.32-9.594-6.515-26.606 9.79-38.39 3.519-3.65 34.23-33.505 88.96-28 14.371-.235 41.356 2.644 65.367 22.542 22.844 18.711 30.137 41.914 33.254 51.828 6.918 22.043 4.98 40.383 3.563 53.778l-.067.593c-1.882 17.817-6.582 35.168-13.964 51.586a4.024 4.024 0 0 1-3.657 2.364zm-7.355-95.546a4.06 4.06 0 0 1 1.898.476 4 4 0 0 1 1.996 2.602 316.077 316.077 0 0 1 5.239 27.738c2.39 16.805 2.867 30.055 2.957 34.973.004.293.011.586.015.875a160.192 160.192 0 0 0 4.918-25.899l.063-.597c1.343-12.696 3.183-30.082-3.239-50.54-2.902-9.226-9.687-30.835-30.703-48.05-22.187-18.39-47.316-20.914-60.418-20.715a4.348 4.348 0 0 1-.453-.02c-53.082-5.421-82.515 25.454-82.8 25.766-.188.2-.403.39-.622.543-17.25 12.211-6.761 30.25-6.308 31.012a4.002 4.002 0 0 1-.805 5.066c-2.043 1.781-4.082 3.531-6.125 5.285-1.809 1.559-3.625 3.114-5.437 4.692a69.264 69.264 0 0 0-1.442 3.867c-7.008 20.418-3.762 39.254-1.828 50.508.805 4.66 1.84 9.304 3.106 13.902.453-2.945.925-5.875 1.433-8.777 2.473-14.133 3.832-21.918 7.559-30.918 2.851-6.914 6.082-14.75 13.246-22.262 12.254-12.851 27.379-15.844 34.644-17.285 21.942-4.332 40.262 2.445 47.157 4.996l.976.356c9.113 3.316 13.984 6.44 18.281 9.195 4.043 2.59 7.235 4.637 13.246 6.406 12.54 3.66 26.704 2.668 42.086-2.95.43-.167.891-.245 1.36-.245zM84.18 159.488h.039zm0 0" data-original="#173851"></path><path fill="#ffffff" d="M271.035 342.043a75.507 75.507 0 0 1 17.285-1.992c41.797 0 75.68 34.015 75.68 75.976s-33.883 75.977-75.68 75.977c-41.797 0-75.68-34.016-75.68-75.977.005-35.992 24.93-66.136 58.395-73.984" data-original="#ffffff" class=""></path><path fill="#173851" d="M288.32 496c-43.933 0-79.68-35.875-79.68-79.977 0-37.363 25.282-69.386 61.481-77.875a79.901 79.901 0 0 1 18.2-2.097c43.933 0 79.679 35.879 79.679 79.976C368 460.13 332.258 496 288.32 496zm-16.367-150.059c-32.57 7.633-55.308 36.454-55.308 70.086 0 39.688 32.156 71.977 71.68 71.977 39.523 0 71.679-32.29 71.679-71.977s-32.16-71.976-71.684-71.976c-5.523 0-11.03.637-16.367 1.89zm-.918-3.898h.04zm0 0" data-original="#173851"></path><path fill="#45c9a5" d="M288.32 360.469c-4.285 0-8.543.488-12.656 1.453-25.137 5.894-42.687 28.14-42.687 54.101 0 30.637 24.824 55.563 55.34 55.563s55.34-24.926 55.34-55.563c.007-30.632-24.817-55.554-55.337-55.554zm0 0" data-original="#45c9a5"></path><g fill="#fff"><path d="M288.32 455.324a4 4 0 0 1-4-4v-74.898c0-2.211 1.79-4 4-4 2.211 0 4 1.789 4 4v74.898a4 4 0 0 1-4 4zm0 0" fill="#ffffff" data-original="#ffffff" class=""></path><path d="M325.629 417.875h-74.613a4 4 0 0 1 0-8h74.609a4 4 0 0 1 .004 8zm0 0" fill="#ffffff" data-original="#ffffff" class=""></path></g></g></svg>
				<?php 
				Global $current_user;
				printf(
					__('<p><strong>%s</strong> Dear Wellcome.</p>','digix'), esc_html( $current_user->display_name )
				); ?>
			</div>
			<div class="zeynep-actions">
				<a class="login" href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"><?php echo __('Myaccount','digix'); ?></a>
				<a class="register" href="<?php echo esc_url( wc_get_account_endpoint_url( 'orders' ) ); ?>"><?php echo __('Orders','digix'); ?></a>
			</div>
		<?php else: ?>
		<div class="zeynep-avatar">
			<svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="80" height="80" x="0" y="0" viewBox="0 0 496 496" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g transform="matrix(1.000000000000001,0,0,1.000000000000001,75,-1.1368683772161603e-13)"><path fill="#28a7e6" d="M343.664 172.5C343.664 77.23 266.73 0 171.832 0S0 77.23 0 172.5 76.934 345 171.832 345s171.832-77.23 171.832-172.5zm0 0" data-original="#28a7e6" class=""></path><path fill="#ffffff" d="M276.457 94.523c-3.125-9.945-10.336-32.214-31.984-49.945-25.305-20.969-54.059-21.726-62.993-21.617-55.886-5.73-86.148 27.027-86.148 27.027-20.46 14.489-7.434 36.325-7.434 36.325-4.09 3.566-8.183 7.027-12.273 10.593a82.243 82.243 0 0 0-1.887 4.965c-5.789 16.883-4.949 32.406-3.27 44.414h-.175c.39 2.344.828 4.621 1.262 6.895.07.39.136.793.203 1.172a150.241 150.241 0 0 0 3.097 13.957c8.973 36.644 22.813 63.234 33.184 79.945 21.504 34.633 37.715 42.453 47.273 45.726 4.739 1.622 22.614 6.918 42.536 0 11.879-4.125 25.39-13.054 43.718-43.89 7.493-12.602 16.77-30.543 24.692-53.903-.035.47-.067 1.004-.098 1.454 4.98-11.07 11.313-28.352 13.637-50.36 1.394-13.23 3.433-31.18-3.34-52.758zm0 0" data-original="#ffffff" class=""></path><path fill="#173851" d="M176.883 301.469c-10.414 0-18.715-2.285-22.863-3.703-10.88-3.727-27.829-12.692-49.38-47.407-15.132-24.367-26.46-51.656-33.671-81.097a152.606 152.606 0 0 1-3.156-14.23l-.204-1.18a298.36 298.36 0 0 1-1.261-6.903 3.954 3.954 0 0 1-.004-1.304c-1.469-11.036-2.485-27.31 3.61-45.075a84.886 84.886 0 0 1 1.98-5.207 4.014 4.014 0 0 1 1.062-1.472c2.067-1.797 4.133-3.575 6.2-5.348a698.47 698.47 0 0 0 3.71-3.191c-4.32-9.59-6.515-26.606 9.79-38.391 3.519-3.648 34.23-33.504 88.96-28 14.371-.234 41.36 2.644 65.367 22.543 22.844 18.71 30.137 41.918 33.254 51.828 6.918 22.043 4.98 40.383 3.563 53.777l-.067.594c-1.882 17.817-6.582 35.168-13.964 51.586-.2.434-.465.824-.782 1.149-6.414 18.277-14.484 35.66-24.02 51.699-19.605 32.984-34.175 41.57-45.843 45.629-7.945 2.75-15.55 3.703-22.281 3.703zM74.44 146.785c.332 1.906.688 3.774 1.047 5.64l.211 1.243a144.603 144.603 0 0 0 3.02 13.59c7.039 28.726 18.039 55.234 32.726 78.887 20.2 32.542 35.45 40.726 45.172 44.05 4.719 1.618 21.555 6.39 39.922.004 10.305-3.578 23.3-11.386 41.594-42.156 9.758-16.426 17.945-34.309 24.336-53.145a3.989 3.989 0 0 1 1.347-1.882 160.528 160.528 0 0 0 12.004-46.16l.063-.598c1.344-12.695 3.183-30.082-3.238-50.54-2.903-9.226-9.688-30.835-30.704-48.05-22.187-18.39-47.316-20.914-60.418-20.715a4.349 4.349 0 0 1-.453-.02C127.734 21.497 98.56 52.38 98.273 52.696c-.187.203-.402.39-.625.547-17.25 12.211-6.761 30.25-6.308 31.012a4.003 4.003 0 0 1-.805 5.066c-2.043 1.782-4.082 3.532-6.125 5.285-1.808 1.56-3.625 3.114-5.437 4.692a69.264 69.264 0 0 0-1.442 3.867c-5.761 16.797-4.527 32.332-3.09 42.559.04.355.04.715 0 1.062zm0 0" data-original="#173851"></path><path fill="#ffffff" d="m210.012 290.371-15.875 5.883c-6.09 2.254-12.461 3.469-18.88 3.777-10.23.492-20.362-2.222-29.644-6.57l-8.96-4.898-15.59 28.28 18.835 14.438c9.465 5.176 25.399 8.957 36.176 8.762l.305-.004c9.582-.172 18.988-4.828 27.484-9.27l26.453-15.007zm0 0" data-original="#ffffff" class=""></path><path fill="#173851" d="M175.54 344.047c-11.767 0-27.935-3.996-37.56-9.254a5.044 5.044 0 0 1-.515-.332l-18.84-14.438a4.007 4.007 0 0 1-1.074-5.109l15.59-28.277a3.997 3.997 0 0 1 5.418-1.582l8.96 4.898c9.454 4.418 18.79 6.5 27.536 6.082 6.203-.297 12.148-1.488 17.683-3.535l15.88-5.879a4.01 4.01 0 0 1 4.515 1.25l20.3 25.387a3.989 3.989 0 0 1 .801 3.25 3.994 3.994 0 0 1-1.953 2.722l-26.453 15.008c-9.71 5.09-19.172 9.614-29.387 9.797-.293.008-.597.012-.902.012zm-33.454-16.133c8.723 4.684 23.95 8.352 33.914 8.133 8.773-.156 17.297-4.262 26.008-8.824l22.254-12.625-15.57-19.47-13.169 4.876c-6.304 2.332-13.058 3.684-20.078 4.023-10.054.489-20.66-1.851-31.535-6.941l-5.683-3.102-12.008 21.782zm0 0" data-original="#173851"></path><path fill="#d4dedd" d="m230.316 318.938-5.632.015-20.825 11.817c-8.496 4.445-17.902 9.097-27.484 9.27l-.305.003c-10.773.195-26.707-3.586-36.175-8.762l-15.743-12.07-6.164.016c-46.093 9.472-80.785 50.433-80.785 99.496v42.347h275.375v-42.347c.008-49.586-35.433-90.895-82.262-99.785zm0 0" data-original="#d4dedd" class=""></path><path fill="#173851" d="M312.586 465.074H37.207c-2.21 0-4-1.789-4-4v-42.347c0-49.918 35.316-93.414 83.977-103.414a3.88 3.88 0 0 1 .793-.086l6.164-.016c.949-.137 1.742.289 2.445.828l15.492 11.875c8.727 4.684 23.953 8.352 33.918 8.133 8.774-.156 17.297-4.262 26.008-8.824l20.707-11.75a3.968 3.968 0 0 1 1.96-.52l5.634-.015c.129-.032.507.019.754.07 49.558 9.406 85.52 53.027 85.52 103.719v42.347a3.984 3.984 0 0 1-3.993 4zm-271.379-8h267.379v-38.347c0-46.727-33.05-86.95-78.64-95.786l-4.2.008-19.914 11.293c-9.71 5.09-19.172 9.613-29.387 9.797-11.715.164-28.593-3.848-38.465-9.246a4.487 4.487 0 0 1-.515-.336L122.8 323.215l-4.399.012c-44.754 9.394-77.199 49.488-77.199 95.5zm0 0" data-original="#173851"></path><path fill="#ffffff" d="M70.293 152.883c-14.047 6.832-21.129 22.87-16.848 37.52 4.059 13.906 17.426 23.406 32.196 22.644l-13.883-58.695" data-original="#ffffff" class=""></path><path fill="#173851" d="M84.023 217.09c-15.73 0-30.023-10.504-34.414-25.563-4.816-16.488 3.325-34.648 18.934-42.238 1.906-.934 4.18-.203 5.223 1.606a4.01 4.01 0 0 1 1.882 2.539l13.887 58.691a3.998 3.998 0 0 1-.691 3.324 3.997 3.997 0 0 1-2.992 1.59 35.82 35.82 0 0 1-1.829.05zm-15.402-58.625c-9.883 6.7-14.7 19.293-11.332 30.824 3.078 10.547 12.45 18.211 23.254 19.582zm0 0" data-original="#173851"></path><path fill="#ffffff" d="M281.89 154.54c11.512 2.995 17.403 18.78 13.145 35.253-4.254 16.473-21.101 27.394-32.62 24.394zm0 0" data-original="#ffffff" class=""></path><path fill="#173851" d="M266.477 218.691a19.95 19.95 0 0 1-5.07-.632 3.995 3.995 0 0 1-2.5-1.95 3.986 3.986 0 0 1-.29-3.16l19.473-59.648a4.002 4.002 0 0 1 4.805-2.63c13.625 3.548 20.808 21.544 16.007 40.122-2.476 9.613-9.18 18.422-17.914 23.562-4.86 2.86-9.86 4.336-14.511 4.336zm17.851-58.726-16.539 50.66c2.879-.262 6.043-1.34 9.14-3.164 6.946-4.09 12.266-11.07 14.235-18.668 3.145-12.191.035-24.262-6.836-28.828zm0 0" data-original="#173851"></path><path fill="#d4dedd" d="M84.18 159.488c2.504-14.324 3.828-21.66 7.308-30.082 2.782-6.726 5.813-14.066 12.45-21.031 11.374-11.938 25.738-14.773 32.53-16.117 21.954-4.344 40.157 3.066 45.981 5.187 17.227 6.27 18.52 11.782 31.766 15.676 16.691 4.863 32.738 1.293 44.582-3.027a310.393 310.393 0 0 1 5.168 27.383c2.527 17.765 2.86 31.218 2.922 34.484.21 10.32-.219 19.078-.73 25.68 4.98-11.07 11.312-28.352 13.636-50.36 1.394-13.23 3.434-31.18-3.34-52.758-3.125-9.945-10.336-32.214-31.984-49.945-25.301-20.969-54.055-21.726-62.989-21.617-55.886-5.73-86.148 27.027-86.148 27.027-20.46 14.489-7.434 36.325-7.434 36.325-4.09 3.566-8.183 7.027-12.273 10.593a85.004 85.004 0 0 0-1.887 4.965c-7.191 20.961-4.164 39.844-1.984 52.484 1.351 7.848 3.844 18.56 8.77 30.817a411.494 411.494 0 0 1 3.656-25.684zm0 0" data-original="#d4dedd" class=""></path><path fill="#173851" d="M266.156 201.64a3.999 3.999 0 0 1-3.988-4.309c.648-8.339.89-16.847.719-25.292-.086-4.77-.555-17.637-2.883-34a305.417 305.417 0 0 0-4.121-22.726c-15.39 4.878-29.758 5.445-42.785 1.648-7.118-2.094-11.098-4.645-15.313-7.344-4.14-2.656-8.422-5.402-16.7-8.414l-1.019-.375c-6.32-2.332-23.105-8.547-42.824-4.652-6.465 1.281-19.914 3.941-30.414 14.957-6.125 6.426-8.93 13.222-11.64 19.797-3.25 7.86-4.516 14.644-7.067 29.242a410.563 410.563 0 0 0-3.621 25.43 4.002 4.002 0 0 1-3.434 3.523c-1.785.242-3.57-.77-4.25-2.473-4.125-10.265-7.152-20.91-9-31.629-2.07-12.007-5.527-32.109 2.141-54.464a84.886 84.886 0 0 1 1.98-5.207A4.014 4.014 0 0 1 73 93.879c2.066-1.8 4.133-3.574 6.2-5.348 1.241-1.058 2.472-2.125 3.71-3.191-4.32-9.594-6.515-26.606 9.79-38.39 3.519-3.65 34.23-33.505 88.96-28 14.371-.235 41.356 2.644 65.367 22.542 22.844 18.711 30.137 41.914 33.254 51.828 6.918 22.043 4.98 40.383 3.563 53.778l-.067.593c-1.882 17.817-6.582 35.168-13.964 51.586a4.024 4.024 0 0 1-3.657 2.364zm-7.355-95.546a4.06 4.06 0 0 1 1.898.476 4 4 0 0 1 1.996 2.602 316.077 316.077 0 0 1 5.239 27.738c2.39 16.805 2.867 30.055 2.957 34.973.004.293.011.586.015.875a160.192 160.192 0 0 0 4.918-25.899l.063-.597c1.343-12.696 3.183-30.082-3.239-50.54-2.902-9.226-9.687-30.835-30.703-48.05-22.187-18.39-47.316-20.914-60.418-20.715a4.348 4.348 0 0 1-.453-.02c-53.082-5.421-82.515 25.454-82.8 25.766-.188.2-.403.39-.622.543-17.25 12.211-6.761 30.25-6.308 31.012a4.002 4.002 0 0 1-.805 5.066c-2.043 1.781-4.082 3.531-6.125 5.285-1.809 1.559-3.625 3.114-5.437 4.692a69.264 69.264 0 0 0-1.442 3.867c-7.008 20.418-3.762 39.254-1.828 50.508.805 4.66 1.84 9.304 3.106 13.902.453-2.945.925-5.875 1.433-8.777 2.473-14.133 3.832-21.918 7.559-30.918 2.851-6.914 6.082-14.75 13.246-22.262 12.254-12.851 27.379-15.844 34.644-17.285 21.942-4.332 40.262 2.445 47.157 4.996l.976.356c9.113 3.316 13.984 6.44 18.281 9.195 4.043 2.59 7.235 4.637 13.246 6.406 12.54 3.66 26.704 2.668 42.086-2.95.43-.167.891-.245 1.36-.245zM84.18 159.488h.039zm0 0" data-original="#173851"></path><path fill="#ffffff" d="M271.035 342.043a75.507 75.507 0 0 1 17.285-1.992c41.797 0 75.68 34.015 75.68 75.976s-33.883 75.977-75.68 75.977c-41.797 0-75.68-34.016-75.68-75.977.005-35.992 24.93-66.136 58.395-73.984" data-original="#ffffff" class=""></path><path fill="#173851" d="M288.32 496c-43.933 0-79.68-35.875-79.68-79.977 0-37.363 25.282-69.386 61.481-77.875a79.901 79.901 0 0 1 18.2-2.097c43.933 0 79.679 35.879 79.679 79.976C368 460.13 332.258 496 288.32 496zm-16.367-150.059c-32.57 7.633-55.308 36.454-55.308 70.086 0 39.688 32.156 71.977 71.68 71.977 39.523 0 71.679-32.29 71.679-71.977s-32.16-71.976-71.684-71.976c-5.523 0-11.03.637-16.367 1.89zm-.918-3.898h.04zm0 0" data-original="#173851"></path><path fill="#45c9a5" d="M288.32 360.469c-4.285 0-8.543.488-12.656 1.453-25.137 5.894-42.687 28.14-42.687 54.101 0 30.637 24.824 55.563 55.34 55.563s55.34-24.926 55.34-55.563c.007-30.632-24.817-55.554-55.337-55.554zm0 0" data-original="#45c9a5"></path><g fill="#fff"><path d="M288.32 455.324a4 4 0 0 1-4-4v-74.898c0-2.211 1.79-4 4-4 2.211 0 4 1.789 4 4v74.898a4 4 0 0 1-4 4zm0 0" fill="#ffffff" data-original="#ffffff" class=""></path><path d="M325.629 417.875h-74.613a4 4 0 0 1 0-8h74.609a4 4 0 0 1 .004 8zm0 0" fill="#ffffff" data-original="#ffffff" class=""></path></g></g></svg>
			<p><?php echo __('Welcome dear user.','digix'); ?></p>
		</div>
		<div class="zeynep-actions">
			<?php if( $options['woocommerce-digits'] == '1' ) { ?>
				<?php if ( $options['woocommerce-digits-type'] == 'popup' ) { ?>
					<button style="background:0;border:0;outline:0;font-size:14px;font-weight:400;box-shadow: none;" href="?login=true" onclick="jQuery('this').digits_login_modal(jQuery(this));return false;" attr-disclick="1" class="digix-digit-btn btn digits-login-modal" type="1">
						<?php echo __('Login','digix');?>
					</button>
					<button style="background:0;border:0;outline:0;font-size:14px;font-weight:400;box-shadow: none;" href="?login=true" onclick="jQuery('this').digits_login_modal(jQuery(this));return false;" attr-disclick="1" class="digix-digit-btn btn digits-login-modal" type="1">
						<?php echo __('Register','digix');?>
					</button>
				<?php }else{ ?>
					<a class="login" href="<?php echo $options['woocommerce-redirect-login']; ?>"><?php echo __('login','digix'); ?></a>
					<a class="register" href="<?php echo $options['woocommerce-redirect-register']; ?>"><?php echo __('register','digix'); ?></a>
				<?php } ?>
			<?php }else{ ?>
				<a class="login" href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"><?php echo __('login','digix'); ?></a>
				<a class="register" href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ) . '?action=register'; ?>"><?php echo __('register','digix'); ?></a>
			<?php } ?>
		</div>
		<?php endif;?>
	</div>
	<?php
		wp_nav_menu(array(  
			'theme_location'  	=> 'mobile',
			'menu' 				=> 'Main Navigation', 
			'container_id' 		=> 'digix_sidemenu', 
			'walker' 			=> new digix_sidemenu()
		));
	?>
</div>
<?php
		if( $options['contact-floating'] == 'yes'){ ?>
			<div class="modern-social">
				<ul class="list">
				<?php
					if(  $options["whatsapp-activate"] == true) : 
					echo'<li>
					   <a href="https://wa.me/' . $options["contact-whatsapp"] . '"> <i class="icon-whatsapp"></i> </a>
					 </li>';
					endif;
					if(  $options["twitter-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-twitter"] . '"> <i class="icon-twitter"></i> </a>
					 </li>';
					endif;
					if(  $options["facebook-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-facebook"] . '"> <i class="icon-facebook"></i> </a>
					 </li>';
					endif;
					if(  $options["telegram-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-telegram"] . '"> <i class="icon-telegram"></i> </a>
					 </li>';
					endif;
					if(  $options["instagram-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-instagram"] . '"> <i class="icon-instagram"></i> </a>
					 </li>';
					endif;

					if(  $options["sapp-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-sapp"] . '"> <i class="icon-sapp"></i> </a>
					 </li>';
					endif;

					if(  $options["gap-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-gap"] . '"> <i class="icon-gap"></i> </a>
					 </li>';
					endif;

					if(  $options["bale-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-bale"] . '"> <i class="icon-bale"></i> </a>
					 </li>';
					endif;

					if(  $options["rubika-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-rubika"] . '"> <i class="icon-rubika"></i> </a>
					 </li>';
					endif;

					if(  $options["eitaa-activate"] == true) : 
					echo'<li>
					   <a href="' . $options["contact-eitaa"] . '"> <i class="icon-eitaa"></i> </a>
					 </li>';
					endif;
				?>
				</ul>
			</div>
	<?php } ?>
<div class="zeynep-overlay"></div>
<?php endif; ?>
<?php if($options['woocommerce-location-mobile'] == '1'){?>
	<?php if(!is_cart() && !is_checkout() && !is_single() && !is_account_page()): ?>
		<div class="product-locator">
			<?php echo do_shortcode('[digix_location]'); ?>
		</div>
	<?php endif; ?>
<?php } ?>


