<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Digix functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Digix
 */

if ( ! class_exists( 'DIGIX_Theme_Configuration' ) ) {

    class DIGIX_Theme_Configuration {

        public function __construct() {

            add_action( 'after_setup_theme', array( $this, 'initialize' ) );
            add_action( 'wp_head', array( $this, 'head_contents') );
            add_action( 'wp_head', array( $this, 'custom_css'), 100 );
            add_action( 'wp_head', array( $this, 'analytics_code'), 100 );
            add_action( 'wp_footer', array( $this, 'custom_js'), 100 );
        }


        /**
         * Sets up theme defaults and registers support for various features
         *
         * Note: the first-loaded translation file overrides any following ones if the same translation is present.
         */
        public function initialize() {
            
            // Hide admin bar
            add_filter('show_admin_bar', '__return_false');

            // Load Localization files
            load_theme_textdomain( 'digix', trailingslashit( WP_LANG_DIR ) . 'themes/' );
            load_theme_textdomain( 'digix', get_template_directory() . '/languages' );
        
                remove_action( 'wp_head', 'rsd_link' );
                remove_action( 'wp_head', 'wp_generator' );

                remove_action( 'wp_head', 'feed_links', 2 );
                remove_action( 'wp_head', 'feed_links_extra', 3 );
                remove_action( 'wp_head', 'wp_resource_hints', 2);

                remove_action( 'wp_head', 'index_rel_link' );
                remove_action( 'wp_head', 'wlwmanifest_link' );
                remove_action( 'wp_head', 'start_post_rel_link', 10, 0 );
                remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 );
                remove_action( 'wp_head', 'adjacent_posts_rel_link', 10, 0 );
                remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );

                remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );
                remove_action( 'wp_head', 'rel_canonical' );
                remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );

                remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
                remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
                remove_action( 'wp_print_styles', 'print_emoji_styles' );
                remove_action( 'admin_print_styles', 'print_emoji_styles' );

                remove_action( 'rest_api_init', 'wp_oembed_register_route' );
                remove_filter( 'oembed_dataparse', 'wp_filter_oembed_result', 10 );
                remove_action( 'wp_head', 'wp_oembed_add_discovery_links' );
                remove_action( 'wp_head', 'wp_oembed_add_host_js' );
        }


        /**
         * Custom styling from color scheme 
         * and also custom CSS option
         */
        public function head_contents() {
            global $options;
            $favicon = $options['general-icon'];
            ?>

            <meta name="theme-color" content="<?= $options['mobile-browsercolor']; ?>">
            <meta name="msapplication-navbutton-color" content="<?= $options['mobile-browsercolor']; ?>">
            <meta name="apple-mobile-web-app-capable" content="yes">
            <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">

            <title><?= get_bloginfo('description'); ?> - <?= $options['general-title']; ?></title>

            <?php if ( $favicon ) { ?>  
            <link rel="apple-touch-icon" href="<?= $favicon; ?>">

            <link rel="icon" type="image/png" sizes="192x192" href="<?= $favicon; ?>">
            <?php } ?>

            <?php

        }


        /**
         * Hook analytics code before the closing head tag
         */
        public function analytics_code() {
            global $options;

            if ( $options['cutomize-analytics'] ) {
                echo '<script type="text/javascript">'. $options['cutomize-analytics'] .'</script>';
            }
        }


        /**
         * Hook Custom JS code to the footer
         */
        public function custom_js() {
            global $options;

            if ( $options['cutomize-mobjs'] ) {
                echo '<script type="text/javascript">'. $options['cutomize-mobjs'] .'</script>';
            }
        }


        /**
         * Custom styling from color scheme 
         * and also custom CSS option
         */
        public function custom_css() {
            global $options;
			$bodycolor = $options['general-bodycolor'];
			$footer_cosmetic_social_color = $options['footer-cosmetic-social-color'];
			$general = $options['mobile-color'];
			$complement = $options['mobile-subcolor'];
			$cartcolor = $options['mobile-cartcolor'];
			$pricecolor = $options['mobile-pricecolor'];
            ?>
            <style>
				body{
					background-color:<?php echo $bodycolor;?>;
				}
				.cosmetic-footer .sectiondown .down .right .social ul li{
					border-color:<?php echo $footer_cosmetic_social_color; ?>;
				}
				.cosmetic-footer .sectiondown .down .right .social ul li a {
					color: <?php echo $footer_cosmetic_social_color; ?>;
				}
				.header-mobile .down .hm-item .cart-user a.cart span{
					background-color:<?php echo $general;?>;
				}
				.header-mobile .down .hm-item .cart-user a.cart span::after {
					border-color:<?php echo $general;?>;
				}
				.digix-toolbar .toolbox .toolbar-list .toolbar-item .feature{
					background-color:<?php echo $general;?>;
				}
				.digix-bestselling .bestselling-list .bestselling-item .bestselling-number{
					color:<?php echo $general;?>;
				}
				.modal-body ul.catelog-list li.catelog-item.active::before {
					background-color:<?php echo $general;?>;
				}
				.woocommerce .product .mobile-product-tab .product-tab-nav .tab-list .tab-item.reviews_tab .more-review{
					background-color:<?php echo $general;?>;
				}
				.woocommerce-account .myaccount-notification header a{
					background-color:<?php echo $general;?>;
				}
				.woocommerce button.button {
					background-color:<?php echo $general;?>;
				}
				.woocommerce-account .woocommerce-MyAccount-content .order-tracking-container .digix-tracking-from form input[type=submit] {
					background-color:<?php echo $general;?>;
				}
				.woocommerce .checkout-process ul li.bar.true-bar span {
					background-color:<?php echo $general;?>;
				}
				.woocommerce .checkout-process ul li.true-bar p {
					color:<?php echo $general;?>;
				}
				.woocommerce .woo-cart-form .cart-detailes .cart_totals .wc-proceed-to-checkout a {
					background-color:<?php echo $general;?>;
				}
				.woocommerce form.checkout.woocommerce-checkout .woocommerce-checkout-review-order #payment div.form-row .fixed-cart-navbar #place_order {
					background-color:<?php echo $general;?>;
				}
				.woocommerce form.checkout.woocommerce-checkout .woocommerce-checkout-review-order .order-time .list .item input:checked+label {
					border-color:<?php echo $general;?>;
					color:<?php echo $general;?>;
				}
				
				/*** compelment ***/
				.woocommerce .order-successful {
					color:<?php echo $complement;?>;
				}
				.modal .modal-body .sidebar .widget .widget-content .price_slider_wrapper .price_slider_amount .button {
					background-color: <?php echo $complement;?>;
				}
				.woocommerce-account .myaccount-notification header h3 {
					background-color: <?php echo $complement;?>;
				}
				.digix-wc-review .review-entry .review-box .review-wrapper .comment-respond form .form-submit input[type=submit] {
					background-color: <?php echo $complement;?> !important;
				}
				
				/*** add to cart ***/
				.woocommerce .product .summary .addbox .addcart .buttons-row button {
					background-color: <?php echo $cartcolor;?>;
				}
				.digix-product .product-item .product-detailes .product-add button {
					background-color: <?php echo $cartcolor;?>;
				}
				/*** price ***/
				.digix-product .product-item .product-detailes .product-add .product-price>span, .digix-product .product-item .product-detailes .product-add .product-price ins {
					color: <?php echo $pricecolor;?>;
				}
				.woocommerce-account .woocommerce-MyAccount-content .digix-wishlist .wishlist-list .wishlist-item .wishlist-detailes .wishlist-item--price {
					color: <?php echo $pricecolor;?>;
				}
                <?php
                    if ( $options['cutomize-mobcss'] ) {
                        echo $options['cutomize-mobcss'];
                    }
                ?>
            </style>

            <?php
        }

    }
}

return new DIGIX_Theme_Configuration();