<?php
if (isset($comment)) {
    $comment_id = $comment->comment_ID;
}



$already_liked = 0;
$href = 'javascript:void(0)';

/**
 * Cookie Validation
 */
if (isset($_COOKIE['cld_' . $comment_id])) {
    $already_liked = 1;
}

$like_count = get_comment_meta($comment_id, 'cld_like_count', true);
$dislike_count = get_comment_meta($comment_id, 'cld_dislike_count', true);

    $like_count = (empty($like_count)) ? 0 : $like_count;
    $dislike_count = (empty($dislike_count)) ? 0 : $dislike_count;

/**
 * Filters like count
 *
 * @param type int $like_count
 * @param type int $comment_id
 *
 * @since 1.0.0
 */
$like_count = apply_filters('cld_like_count', $like_count, $comment_id);

/**
 * Filters dislike count
 *
 * @param type int $dislike_count
 * @param type int $comment_id
 *
 * @since 1.0.0
 */
$dislike_count = apply_filters('cld_dislike_count', $dislike_count, $comment_id);
?>
<div class="cld-like-dislike-wrap">
    <?php
    /**
     * Like Dislike Order
     */
	include(DIGIX_DIR . '/includes/classes/comment/views/frontend/like.php');
	include(DIGIX_DIR . '/includes/classes/comment/views/frontend/dislike.php');
    ?>
</div>
