<?php
/**
 * Digix functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Digix
 */
class Digix_Product_Faqs_ADMIN {

    /**
     * Constructor of class.
     */
public function __construct() {
    
    add_action( 'admin_enqueue_scripts', array( $this, 'add_script' ) );
    add_filter( 'woocommerce_product_data_tabs', array( $this, 'add_tab' ) );
    add_filter( 'woocommerce_product_data_panels', array( $this, 'add_panel' ) );
    add_action( 'woocommerce_process_product_meta', array( $this, 'save_faqs' ) );

}
/**
	 * Enqueue scripts.
	 */
	public function add_script() {

		$dependencies = array('wp-element', 'wp-polyfill');
		wp_enqueue_script( 'woo-product-faqs' , IM_URI . '/static/js/build/faq.js', $dependencies, '', true );
        


	}
/**
 * Add tab in product page.
 *
 * @param array $tabs All registered woocommerce tabs.
 * @return array
 */
public function add_tab( $tabs ) {

    $tabs['Digix_Product_Faqs'] = array(
        'label'  => 'FAQs',
        'target' => 'woo-product-faqs-panel',
    );

    return $tabs;
}

/**
 * Add content for the faqs tab.
 */
public function add_panel() {

    global $post;

    $faqs = get_post_meta( $post->ID, '_Digix_Product_Faqs', true );
    if ( ! $faqs ) {
        $faqs = array();
    }

    wp_localize_script(
        'woo-product-faqs',
        'product_faqs',
        array(
            'faqs' => $faqs,
        )
    );

    ?>
    <div id='woo-product-faqs-panel' class='panel woocommerce_options_panel'>
        <div class='options_group' id="wpf-option-group"></div>
    </div>
    <?php
}

/**
 * Save content of faqs in meta.
 */
public function save_faqs() {

    if ( ! isset( $_POST['woocommerce_meta_nonce'] ) || ! wp_verify_nonce( wp_unslash( $_POST['woocommerce_meta_nonce'] ), 'woocommerce_save_data' ) ) {  // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
        return;
    }
//if(empty($_POST['wpf_faqs']) && ! isset($_POST['wpf_faqs'])): return; endif;
    global $post;
    $faqs = array_map(
        function( $faq ) {
            return array(
                'question' => sanitize_text_field( $faq['question'] ),
                'answer'   => sanitize_text_field( $faq['answer'] ),
            );
        },
        wp_unslash( $_POST['wpf_faqs'] ) //phpcs:ignore
    );
if(empty($faqs) && ! isset($faqs)): return; endif;    
    update_post_meta( $post->ID, '_Digix_Product_Faqs', $faqs );

}
}
