<?php

class digix_elementor_amazing extends \Elementor\Widget_Base {

	public function get_name() {
		return 'amazing-slider';
	}

	public function get_title() {
		return __('digikala amazing element','digix');
	}

	public function get_icon() {
		return 'eicon-form-vertical';
	}

	public function get_categories() {
		return [ 'digix' ];
	}

	protected function _register_controls() {
		    $this->start_controls_section(
				'text',
				[
					'label' => __('amazing element','digix'),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
            $this->add_control(
                'posts_per_page',
                [
                    'label'      => __('number of products','digix'),
                    'type'       => \Elementor\Controls_Manager::NUMBER,
                    'input_type' => 'number',
                ]
            );
            $this->add_control(
                'post_in',
                [
                    'label'       => __('include product','digix'),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'input_type'  => 'text',
                    'description' => __('Separate product IDs with English commas.','digix'),
                ]
            );
		$this->add_control(
			 'add_cart',
			 [
                'label' => __( 'show add to cart button', 'digix' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',

			 ]
		);
		$this->add_control(
			'attributes',
			[
				'label'        => __('show attributes','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
		 'config',
		    [
                'label' => __( 'slider config', 'digix' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		    ]
		);

		$this->add_control(
            'navigation',
            [
                'label' => __( 'navigation', 'digix' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'yes', 'digix' ),
                'label_off' => __( 'no', 'digix' ),
                'return_value' => 'true',
                'default' => 'false',
            ]
        );
        $this->add_control(
            'view_all',
            [
                   'label' => __( 'show view all item', 'digix' ),
                   'type' => \Elementor\Controls_Manager::SWITCHER,
                   'default' => 'yes',

            ]
       );
	   $this->add_control(
           'offer-uri',
           [
               'label' => __( 'special offer url', 'digix' ),
               'type' => \Elementor\Controls_Manager::URL,
               'multiple' => true,
       				'default' => [
       		        'url' => '#',
       		        'is_external' => true,
       		        'nofollow' => true,
               ],
           ]
        );


 		$this->end_controls_section();

 		$this->start_controls_section(
 			'style',
 			[
 				'label' => __( 'style', 'digix' ),
 				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
 			]
 		);

 		$this->add_control(
 			'background_pattern',
 			[
 				'label' => __( 'background pattern', 'digix' ),
 				'type' => \Elementor\Controls_Manager::MEDIA,
 				'selectors' => [
 					'{{WRAPPER}} .mobile-amazing-list' => 'background-image: url({{URL}})',
 				],
 			]
 		);

 		$this->add_control(
 			'background_color',
 			[
 				'label' => __( 'background color', 'digix' ),
 				'type' => \Elementor\Controls_Manager::COLOR,
 				'default' => '#fc6404eb',
 				'selectors' => [
 					'{{WRAPPER}} .mobile-amazing-list' => 'background-color: {{VALUE}}',
 				],
 			]
 		);
	 	$this->add_control(
            'amazing_img',
            [
                'label' => __( 'amazing image', 'digix' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' =>  DIGIX_URI .'/static/img/amazing.png',
                ],
            ]
	   );
 		$this->add_control(
            'border_radius',
            [
                'label' => __( 'border radius element', 'digix' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'step' => 1,
                'default' => 15,
                'selectors' => [
                    '{{WRAPPER}} .mobile-amazing-list' => 'border-radius: {{VALUE}}px',
                ],
            ]
 	 	);
		  $this->add_control(
            'del_color',
            [
                'label' => __( 'sale color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'red',
                'selectors' => [
                    '{{WRAPPER}} .digix-amazing .mobile-amazing-list .product-item .product-detailes .product-add .product-price del' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'price_color',
            [
                'label' => __( 'price color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3ab54a',
                'selectors' => [
                    '{{WRAPPER}} .digix-amazing .mobile-amazing-list .product-item .product-detailes .product-add .product-price>span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .digix-amazing .mobile-amazing-list .product-item .product-detailes .product-add .product-price ins' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'discount_bgcolor',
            [
                'label' => __( 'discount background color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',
                'selectors' => [
                    '{{WRAPPER}} .discount' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
			'discount_color',
			[
				'label' => __( 'discount text color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .discount' => 'color: {{VALUE}}; border-color: {{VALUE}};',
				],
			]
			);
        $this->add_control(
            'add_to_cart_bgcolor',
            [
                'label' => __( 'add to cart background color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3ab54a',
                'selectors' => [
                    '{{WRAPPER}} .digix-amazing .mobile-amazing-list .product-item .product-detailes .product-add button' => 'background-color: {{VALUE}}',
                ],
            ]
        );
 	  $this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();
		
		$add_cart   	= ! empty( $settings['add_cart'] ) ? 1 : 0;
		$attributes   	= ! empty( $settings['attributes'] ) ? 1 : 0;
		$post_in        = ! empty( $settings['post_in'] ) ? trim( $settings['post_in'] ) : '';
		$posts_per_page = ! empty( $settings['posts_per_page'] ) ? $settings['posts_per_page'] : 10;
		$view_all		= ! empty( $settings['view_all'] ) ? $settings['view_all'] : 'yes';
	    $args = array(
			'post_type'      => 'product',
			'posts_per_page' => $posts_per_page,
		);
		if ( ! empty( $post_in ) ) {
			if ( preg_match( '/^\d+(?:,?\d+,?)+$/', $post_in ) ) {
				$array                     = explode( ',', $post_in );
				$post__in                  = array_filter( $array, function ( $value ) {
					return $value !== '';
				} );
				$args['post__in'] = $post__in;
			}
		}else{
			$args['meta_query']     = array(
				'relation' => 'AND',
				array(
					'key'     => 'digix_special_slider_active',
					'value'   => 'yes',
					'compare' => '=',
				),
				array(
					'key'     => 'digix_special_slider_date_start',
					'value'   => '',
					'compare' => '!=',
				),
				array(
					'key'     => 'digix_special_slider_date_start',
					'value'   => time(),
					'compare' => '<',
				),
				array(
					'key'     => 'digix_special_slider_date_end',
					'value'   => '',
					'compare' => '!=',
				),
			);
		}
	if(isset($_COOKIE['digixproductlocation']) && !empty(($_COOKIE['digixproductlocation']))){
			$product_city=explode(',', $_COOKIE['digixproductlocation']);
			if (!empty($product_city) && $product_city !== 0) {
				if (is_array($args["tax_query"])) {
					$args["tax_query"][] = ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city];
				} else {
					$args["tax_query"] = ["relation" => "AND", ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city]];
				}
			}
		}
		$products = new WP_Query( $args );
		if ( $products->have_posts() ) :
		?>
        <section class="digix-amazing">
            <div class="mobile-amazing-list">
				<div class="amazing-image">
					<figure>
						<img class="img-fluid" src="<?php echo $settings['amazing_img']['url'];?>">
					</figure>
					<div class="amazing-more">
						<a href="<?php // echo $settings['s-off-link']['url'];?>">
							<?php echo __('view all' , 'digix');?>
						</a>
						<i class="far fa-chevron-left owl-next"></i>
					</div>
				</div>
				<?php while ( $products->have_posts() ) : $products->the_post(); ?>
				<?php $product = wc_get_product( $products->post->ID ); ?>
					<div class="product-item">
						<?php if($product->is_on_sale()){ ?>
								<div class="discount <?php if($attributes){echo'left-auto right-10';}?>">
									٪<?php echo digix_wooocmmerce_discount(get_the_ID()) ?>
								</div>
							<?php } ?>
							<?php if($attributes):?>
							<?php if ( function_exists( 'wpcvs_init' ) ) {?>
								<div class="product-attribute">
									<?php echo do_shortcode('[dx_attributes]');do_action('digix_woocommerce_before_thumbnails');?>
								</div>
							<?php } ?>
							<?php endif; ?>
						<figure class="product-thumbnails">
							<a href="<?php echo $product->get_permalink(); ?>">
								<?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(),'', array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) );?>
							</a>
						</figure>
						<div class="product-detailes">
							<h2>
								<a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a>
							</h2>
							<div class="product-add <?php if(! $add_cart){echo'justify-content-center';}?>">
								<div class="product-price">
									<?php if ( ! $product->is_in_stock() ) {
											echo'<div class="OutStock">' . __( "Out Of Stock", "digix" ) . '</div>';
									}else{
											echo $product->get_price_html();
											
									} ?>
								</div>
								<?php if ( $product->is_in_stock() ) { ?>
								<?php if($add_cart):?>
									<button class="add-to-cart-wrap" data-toggle="tooltip" data-original-title="<?php echo esc_html( $product->add_to_cart_text() );?>">
										<a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" data-quantity="1" class="<?php echo esc_attr( implode( ' ', array_filter( array( 'button', 'product_type_' . $product->get_type(), $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '', $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '', ) ) ) );?>" <?php echo wc_implode_html_attributes( array( 'data-product_id'  => $product->get_id(), 'data-product_sku' => $product->get_sku(), 'aria-label'       => $product->add_to_cart_description(), 'rel'              => 'nofollow',) );?>><i class="icon-shopping-basket"></i></a>
									</button>
								<?php endif; ?>
								<?php } ?>
							</div>
						</div>
					</div>
				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
				<?php if( $view_all === 'yes'): ?>
					<div class="product-item">
						<div class="slide-more">
							<a href="<?php echo $settings['offer-uri']['url'];?>">
								<i class="icon-arrow-left"></i>
								<span><?php echo __('view all','digix'); ?></span>
							</a>
						</div>
					</div>
				<?php endif; ?>
            </div>
        </section>


	<?php endif;
  }

}
