<?php

class digix_elementor_item extends \Elementor\Widget_Base {

	public function get_name() 
    {
		return 'business-item';
	}

	public function get_title() 
    {
		return __('commercial items','digix');
	}

	public function get_icon() 
    {
		return 'eicon-slider-device';
	}

	public function get_categories() 
    {
		return [ 'digix' ];
	}

	protected function _register_controls() 
    {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('commercial items','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'ms_important_note',
			[
				'label'           => '',
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __('commercial items','digix'),
				'content_classes' => '',
			]
		);
		
		
		#
		##
		# Number One
		
		$this->add_control(
			'number-one',
			[
				'label'           => '',
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __('number one','digix'),
				'content_classes' => '',
			]
		);
		$this->add_control(
			'one-title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'default'	  => __('safe and secure payment','digix'),
			]
		);
		$this->add_control(
			'one-subtitle',
			[
				'label'       => __('subtitle','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'default' 	  => __('Secure and E-namad licensed payment gateway','digix'),
			]
		);
		$this->add_control(
			'one-img',
			[
				'label'	 	 => __( 'Choose Image', 'digix' ),
				'type'		 => \Elementor\Controls_Manager::MEDIA,
				'dynamic'	 => ['active' => true,],
				'default' 	 => ['url' =>DIGIX_IMG . 'secured.svg'],
			]
		);
		

		#
		##
		# Number Two
		
		$this->add_control(
			'number-two',
			[
				'label'           => '',
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __('number two','digix'),
				'content_classes' => '',
			]
		);
		$this->add_control(
			'two-title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'default'	  => __('free shipping','digix'),
			]
		);
		$this->add_control(
			'two-subtitle',
			[
				'label'       => __('subtitle','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'default' 	  => __('Free shipping on bulk purchases','digix'),
			]
		);
		$this->add_control(
			'two-img',
			[
				'label'	 	 => __( 'Choose Image', 'digix' ),
				'type'		 => \Elementor\Controls_Manager::MEDIA,
				'dynamic'	 => ['active' => true,],
				'default' 	 => ['url' =>DIGIX_IMG . 'protection.svg'],
			]
		);

		#
		##
		# Number Three
		
		$this->add_control(
			'number-three',
			[
				'label'           => '',
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __('number three','digix'),
				'content_classes' => '',
			]
		);
		$this->add_control(
			'three-title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'default'	  => __('Product health guarantee','digix'),
			]
		);
		$this->add_control(
			'three-subtitle',
			[
				'label'       => __('subtitle','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'default' 	  => __('Check the physical health before sending','digix'),
			]
		);
		$this->add_control(
			'three-img',
			[
				'label'	 	 => __( 'Choose Image', 'digix' ),
				'type'		 => \Elementor\Controls_Manager::MEDIA,
				'dynamic'	 => ['active' => true,],
				'default' 	 => ['url' =>DIGIX_IMG . 'shield.svg'],
			]
		);

		#
		##
		# Number Four
		
		$this->add_control(
			'number-four',
			[
				'label'           => '',
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __('number four','digix'),
				'content_classes' => '',
			]
		);
		$this->add_control(
			'four-title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'default'	  => __('7 days money back guarantee','digix'),
			]
		);
		$this->add_control(
			'four-subtitle',
			[
				'label'       => __('subtitle','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'default' 	  => __('If the product is defective','digix'),
			]
		);
		$this->add_control(
			'four-img',
			[
				'label'	 	 => __( 'Choose Image', 'digix' ),
				'type'		 => \Elementor\Controls_Manager::MEDIA,
				'dynamic'	 => ['active' => true,],
				'default' 	 => ['url' =>DIGIX_IMG . 'insurance.svg'],
			]
		);

		#
		##
		# Number Five
		
		$this->add_control(
			'number-five',
			[
				'label'           => '',
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __('number five','digix'),
				'content_classes' => '',
			]
		);
		$this->add_control(
			'five-title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'default'	  => __('Online and telephone support','digix'),
			]
		);
		$this->add_control(
			'five-subtitle',
			[
				'label'       => __('subtitle','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'default' 	  => __('For product purchase advice and questions','digix'),
			]
		);
		$this->add_control(
			'five-img',
			[
				'label'	 	 => __( 'Choose Image', 'digix' ),
				'type'		 => \Elementor\Controls_Manager::MEDIA,
				'dynamic'	 => ['active' => true,],
				'default' 	 => ['url' =>DIGIX_IMG . 'service.svg'],
			]
		);

		
		

		$this->end_controls_section();
	}

	protected function render() 
    {
		$settings 		= $this->get_settings_for_display();
		
		$one_title  		= $settings['one-title'];
		$one_subtitle  		= $settings['one-subtitle'];
		$one_img 			= $settings['one-img'];
			
		$two_title  		= $settings['two-title'];
		$two_subtitle  		= $settings['two-subtitle'];
		$two_img  			= $settings['two-img'];

		$three_title  		= $settings['three-title'];
		$three_subtitle  	= $settings['three-subtitle'];
		$three_img		 	= $settings['three-img'];

		$four_title  		= $settings['four-title'];
		$four_subtitle  	= $settings['four-subtitle'];
		$four_img		  	= $settings['four-img'];

		$five_title  		= $settings['five-title'];
		$five_subtitle  	= $settings['five-subtitle'];
		$five_img		  	= $settings['five-img'];

	?>

        <section class="digix-business">
            <div class="business-list">
				<?php if(isset($one_title) && !empty($one_title)):?>
                <div class="col">
                    <div class="business-item">
					<?php if(isset($one_img['url']) && !empty($one_img['url'])):?>
                        <img src="<?php echo $one_img['url']; ?>" class="business-img img-fluid"/>
						<?php endif;?>
                        <strong><?php echo $one_title; ?></strong>
                        <span><?php echo $one_subtitle; ?></span>
                    </div>
                </div>
				<?php endif;?>
				<?php if(isset($two_title) && !empty($two_title)):?>
                <div class="col">
                    <div class="business-item">
					<?php if(isset($two_img['url']) && !empty($two_img['url'])):?>
                        <img src="<?php echo $two_img['url']; ?>" class="business-img img-fluid"/>
						<?php endif;?>
                        <strong><?php echo $two_title; ?></strong>
                        <span><?php echo $two_subtitle; ?></span>
                    </div>
                </div>
				<?php endif;?>
				<?php if(isset($three_title) && !empty($three_title)):?>
                <div class="col">
                    <div class="business-item">
					<?php if(isset($three_img['url']) && !empty($three_img['url'])):?>
                        <img src="<?php echo $three_img['url']; ?>" class="business-img img-fluid"/>
						<?php endif;?>
                        <strong><?php echo $three_title; ?></strong>
                        <span><?php echo $three_subtitle; ?></span>
                    </div>
                </div>
				<?php endif;?>
				<?php if(isset($four_title) && !empty($four_title)):?>
                <div class="col">
                    <div class="business-item">
					<?php if(isset($four_img['url']) && !empty($four_img['url'])):?>
                        <img src="<?php echo $four_img['url']; ?>" class="business-img img-fluid"/>
						<?php endif;?>
                        <strong><?php echo $four_title; ?></strong>
                        <span><?php echo $four_subtitle; ?></span>
                    </div>
                </div>
				<?php endif;?>
				<?php if(isset($five_title) && !empty($five_title)):?>
                <div class="col">
                    <div class="business-item">
					<?php if(isset($five_img['url']) && !empty($five_img['url'])):?>
                        <img src="<?php echo $five_img['url']; ?>" class="business-img img-fluid"/>
						<?php endif;?>
                        <strong><?php echo $five_title; ?></strong>
                        <span><?php echo $five_subtitle; ?></span>
                    </div>
                </div>
				<?php endif;?>
            </div>
		</section>
	<?php
	}

}