<?php

class digix_elementor_post extends \Elementor\Widget_Base 
{
	public function get_name() 
    {
		return 'post-element';
	}

	public function get_title() 
    {
		return __('post element','digix');
	}

	public function get_icon() 
    {
		return 'eicon-post-slider';
	}

	public function get_categories()
    {
		return [ 'digix' ];
	}

	protected function _register_controls() 
    {

		$this->start_controls_section(
			'content_section',
			[
				'label'       => __('post element','digix'),
				'tab'         => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'placeholder' => '',
			]
		);

		$this->add_control(
			'cat',
			[
				'label'   => __('category','digix'),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'all',
				'options' => $this->get_cats(),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'      => __('number of posts','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
                'default'    => '3',
				'input_type' => 'number',
			]
		);


		$this->end_controls_section();
	}

	private function get_cats() 
    {
		$output_categories = [ 'all' => __('all','digix') ];

		$args       = [
			'taxonomy'     => 'category',
			'orderby'      => 'id',
			'order'        => 'ASC',
			'hide_empty'   => false,
			'hierarchical' => true,
		];
		$categories = get_categories( $args );
		foreach ( $categories as $category ) 
        {
			$output_categories[ $category->cat_ID ] = $category->name;
		}

		return $output_categories;
	}

	protected function render() 
    {

		$settings = $this->get_settings_for_display();
		$title          = $settings['title'];
		$cat            = $settings['cat'];
		$posts_per_page = $settings['posts_per_page'];
		$posts_args = array(
			'post_type'      => 'post',
			'posts_per_page' => $posts_per_page,
			'cat'            => $cat,
		);

		$posts = new WP_Query( $posts_args );

		if ( $posts->have_posts() ) : ?>
            <section class="digix-post">
				<h3><?php echo '<a href="' . get_category_link( $cat ) . '">' . $title . '</a>';?></h3>
				<div class="post-box">
                    <?php while ($posts->have_posts()) : $posts->the_post(); global $post; ?>
						<a href="<?php the_permalink(); ?>" class="post-uri">
							<div class="masonry highlight post-thumb" style="background-image: url(<?php the_post_thumbnail_url('post');?>);">
								<div class="post-info">
									<h2 class="post-title"><?php the_title(); ?></h2>
								</div>
							</div>
						</a>
                    <?php endwhile; wp_reset_postdata(); ?>
				</div>
			</section>
		<?php endif;
	}

}