<?php

class digix_elementor_special extends \Elementor\Widget_Base {

	public function get_name() 
    {
		return 'special-slider';
	}

	public function get_title() 
    {
		return __('special element','digix');
	}

	public function get_icon() 
    {
		return 'eicon-slider-device';
	}

	public function get_categories() 
    {
		return [ 'digix' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('special element','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'ms_important_note',
			[
				'label'           => '',
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __('special element','digix'),
				'content_classes' => '',
			]
		);
        
		$this->add_control(
			'title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'placeholder' => __('special products today','digix'),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'      => __('number of products','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
                'default'     => '10',
			]
		);

        $this->add_control(
            'special_timer',
            [
              'label' => __( 'Select Time', 'digix' ),
              'type' => \Elementor\Controls_Manager::DATE_TIME
            ]
        );
		$this->add_control(
			'attributes',
			[
				'label'        => __('show attributes','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
        $this->add_control(
			'special_bgcolor',
			[
				'label'       => __( 'special background color', 'digix' ),
				'type'        => \Elementor\Controls_Manager::COLOR,
				'default' => '#9172fb',
				'selectors' => [
                    '{{WRAPPER}} .im-special .special-box:before' => 'background-color: {{VALUE}} !important',
                    '{{WRAPPER}} .im-special .special-box:after' => 'background-color: {{VALUE}} !important',
                ],
			]
		);
		$this->add_control(
			'item_bgcolor',
			[
				'label'       => __( 'item active background color', 'digix' ),
				'type'        => \Elementor\Controls_Manager::COLOR,
				'default' => '#9172fb',
				'selectors' => [
                    '{{WRAPPER}} .im-special .special-box .special-content .special-list .special-list-container .swiper-wrapper .swiper-slide-active' => 'background-color: {{VALUE}} !important',
                    '{{WRAPPER}} .im-special .special-box .special-content .special-list .special-list-container .swiper-wrapper .special-item:hover' => 'background-color: {{VALUE}} !important',
                ],
			]
		);
		$this->add_control(
            'price_color',
            [
                'label' => __( 'price color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3ab54a',
                'selectors' => [
                    '{{WRAPPER}} .im-special .special-box .special-content .special-detailes .special-main .special-product-uri .special-product-content .special-product-price' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .im-special .special-box .special-content .special-detailes .special-main .special-product-uri .special-product-content .special-product-price ins' => 'color: {{VALUE}} !important',
                ],
            ]
        );
		$this->add_control(
            'discount_color',
            [
                'label' => __( 'discount text color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .digix-product .product-item .discount' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                ],
            ]
            );
        $this->add_control(
            'discount_bgcolor',
            [
                'label' => __( 'discount background color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff0000',
                'selectors' => [
                    '{{WRAPPER}} .digix-product .product-item .discount' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
		$this->add_control(
            'more_bgcolor',
            [
                'label' => __( 'discount background color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3ab54a',
                'selectors' => [
                    '{{WRAPPER}} .im-special .special-box .special-content .special-detailes .special-main .special-product-uri .special-product-content .more-timer .special-product-more' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'timer_bgcolor',
            [
                'label' => __( 'timer background color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#9172fb',
                'selectors' => [
                    '{{WRAPPER}} .im-special .special-box .special-timer .timer-box .timer-amount' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
		$this->end_controls_section();
	}

	protected function render() 
    { 
        $settings = $this->get_settings_for_display();

		$title          = $settings['title'];
		$attributes   	= ! empty( $settings['attributes'] ) ? 1 : 0;
		$posts_per_page = ! empty( $settings['posts_per_page'] ) ? $settings['posts_per_page'] : 10;
        $timer          = $settings['special_timer'];
		$sale = wc_get_product_ids_on_sale();
		$products_args = array(
		    'posts_per_page' => $posts_per_page,
			'no_found_rows' => 1,
			'post_status' => 'publish',
			'post_type' => 'product',
			'meta_query' => WC()->query->get_meta_query(),
			'post__in' => array_merge(array(0), wc_get_product_ids_on_sale()),
		);
		if(isset($_COOKIE['digixproductlocation']) && !empty(($_COOKIE['digixproductlocation']))){
			$product_city=explode(',', $_COOKIE['digixproductlocation']);
			if (!empty($product_city) && $product_city !== 0) {
				if (is_array($products_args["tax_query"])) {
					$products_args["tax_query"][] = ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city];
				} else {
					$products_args["tax_query"] = ["relation" => "AND", ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city]];
				}
			}
		}
        global $product;
		$products = new WP_Query( $products_args );
        $regular_price 	= get_post_meta( get_the_id(), '_sale_price_dates_to', true );
        if ( $products->have_posts() ) : ?>
            <section class="digix-product">
				<h3><?php echo __('amazing product','digix'); ?></h3>
				<div class="mobile-product">
					<?php while ( $products->have_posts() ) : $products->the_post(); ?>
					<?php 
					$product = wc_get_product( $products->post->ID );
					$regular_price 	= get_post_meta(get_the_id(), '_sale_price_dates_to', true );
					$deprecated = $regular_price < time() ? true : false;
					?>
					<div class="product-item">
					<?php if($product->is_on_sale()){ ?>
								<div class="discount <?php if($attributes){echo'left-auto right-10';}?>">
									٪<?php echo digix_wooocmmerce_discount(get_the_ID()) ?>
								</div>
							<?php } ?>
							<?php if($attributes):?>
							<?php if ( function_exists( 'wpcvs_init' ) ) {?>
								<div class="product-attribute">
									<?php echo do_shortcode('[dx_attributes]');do_action('digix_woocommerce_before_thumbnails');?>
								</div>
							<?php } ?>
							<?php endif; ?>
				<figure class="product-thumbnails">
					<a href="<?php echo $product->get_permalink(); ?>">
						<?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(), '', array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) );do_action('wc_secondary_thumbnails'); ?>
					</a>
				</figure>
				<div class="product-detailes">
					<h2>
						<a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a>
					</h2>
					<div class="offer-add product-add">
						<div class="product-price">
							<?php echo $product->get_price_html(); ?>
						</div>
					</div>
					<div class="offer-timer">
						<?php if ( ! $deprecated ){ ?>
							<div class="timer">
								<div class="countdown timer-countdown-<?php $gshoprand=rand(); echo($gshoprand);?>"></div>
							</div>
							<script>
							
							jQuery(function($) {
								var dayz = new Date('<?php  echo date( 'Y/m/d', (int)$regular_price ); ?> 00:00:00');
								jQuery('.timer-countdown-<?php echo($gshoprand);?>').countdown({ 
									until: dayz, 
									layout: '<span class="day"><b>{dn}</b></span>:<span class="hour"><b>{hn}</b></span>:<span class="min"><b>{mn}</b></span>:<span class="sec"><b>{sn}</b></span> '
								});
							});
							
							</script>
						<?php }else{?>
							<div class="offer-end">
								<?php echo __('This offer has expired','digix'); ?>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
					<?php endwhile;wp_reset_postdata(); ?>
				</div>
			</section>
    <?php
        endif;
	}

}