<?php

class digix_elementor_special2 extends \Elementor\Widget_Base {

	public function get_name() 
    {
		return 'special2-slider';
	}

	public function get_title() 
    {
		return __('special element','digix');
	}

	public function get_icon() 
    {
		return 'eicon-slider-device';
	}

	public function get_categories() 
    {
		return [ 'digix' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('special element','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'ms_important_note',
			[
				'label'           => '',
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __('special element','digix'),
				'content_classes' => '',
			]
		);
        
		$this->add_control(
			'title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'placeholder' => __('special products today','digix'),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'      => __('number of products','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
                'default'     => '10',
			]
		);
        $this->add_control(
			'attributes',
			[
				'label'        => __('show attributes','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'style',
			[
				'label' => __( 'style', 'digix' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => __( 'Pattern background color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#094aef',
				'selectors' => [
					'{{WRAPPER}} .digix-offer .offer-list:before' => 'background-color: {{VALUE}} !important',
				],
			]
		);
	   $this->add_control(
		   'item_color',
		   [
			   'label' => __( 'amazing item color', 'digix' ),
			   'type' => \Elementor\Controls_Manager::COLOR,
			   'default' => '#094aef',
			   'selectors' => [
				   '{{WRAPPER}} .digix-offer .offer-list .swiper-offer-item .swiper-wrapper .swiper-slide.swiper-slide-thumb-active .offer-item-title' => 'color: {{VALUE}} !important',
			   ],
		   ]
	   );
	   $this->add_control(
		'discount_color',
		[
			'label' => __( 'discount text color', 'digix' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#fff',
			'selectors' => [
				'{{WRAPPER}} .digix-product .product-item .discount' => 'color: {{VALUE}}; border-color: {{VALUE}};',
			],
		]
		);
	   $this->add_control(
		'discount_bgcolor',
		[
			'label' => __( 'discount background color', 'digix' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#ff0000',
			'selectors' => [
				'{{WRAPPER}} .digix-product .product-item .discount' => 'background-color: {{VALUE}}',
			],
		]
		);
		$this->add_control(
            'price_color',
            [
                'label' => __( 'price color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3ab54a',
                'selectors' => [
                    '{{WRAPPER}} .digix-offer .offer-list .swiper-offer .offer-url .offer-detailes .offer-information .offer-price>span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .digix-offer .offer-list .swiper-offer .offer-url .offer-detailes .offer-information .offer-price ins' => 'color: {{VALUE}}',
                ],
            ]
        );
	  $this->end_controls_section();
	}

	protected function render() 
    { 
        $settings = $this->get_settings_for_display();

		$title          = $settings['title'];
		$attributes   	= ! empty( $settings['attributes'] ) ? 1 : 0;
		$posts_per_page = ! empty( $settings['posts_per_page'] ) ? $settings['posts_per_page'] : 10;
	    $args = array(
		'post_type'      => 'product',
		'posts_per_page' => $posts_per_page,
		'meta_query'     => array(
			'relation' => 'AND',
			array(
				'key'     => 'digix_special_slider_active',
				'value'   => 'yes',
				'compare' => '=',
			),
			array(
				'key'     => 'digix_special_slider_date_start',
				'value'   => '',
				'compare' => '!=',
			),
			array(
				'key'     => 'digix_special_slider_date_start',
				'value'   => time(),
				'compare' => '<',
			),
			array(
				'key'     => 'digix_special_slider_date_end',
				'value'   => '',
				'compare' => '!=',
			),
		),
	);
	if(isset($_COOKIE['digixproductlocation']) && !empty(($_COOKIE['digixproductlocation']))){
			$product_city=explode(',', $_COOKIE['digixproductlocation']);
			if (!empty($product_city) && $product_city !== 0) {
				if (is_array($args["tax_query"])) {
					$args["tax_query"][] = ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city];
				} else {
					$args["tax_query"] = ["relation" => "AND", ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city]];
				}
			}
		}

	$special = new WP_Query( $args );
	if ( $special->have_posts() ) { ?>
<section class="digix-product">
	<h3><?php echo __('special product','digix'); ?></h3>
	<div class="mobile-product">
	<?php
	
		while ( $special->have_posts() ) {
			$special->the_post();
			$product    = wc_get_product( $special->post->ID );
			$date_start = get_post_meta( $special->post->ID, 'digix_special_slider_date_start', true );
			$date_end   = get_post_meta( $special->post->ID, 'digix_special_slider_date_end', true );
			$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
			//$active     = $i == 0 ? 'active' : '';
			$deprecated = $date_end < time() ? true : false;
			?>
			<div class="product-item">
				<?php if($product->is_on_sale()){ ?>
					<div class="discount <?php if($attributes){echo'left-auto right-10';}?>">
						٪<?php echo digix_wooocmmerce_discount(get_the_ID()) ?>
					</div>
				<?php } ?>
				<?php if($attributes):?>
				<?php if ( function_exists( 'wpcvs_init' ) ) {?>
					<div class="product-attribute">
						<?php echo do_shortcode('[dx_attributes]');do_action('digix_woocommerce_before_thumbnails');?>
					</div>
				<?php } ?>
				<?php endif; ?>
				<figure class="product-thumbnails">
					<a href="<?php echo $product->get_permalink(); ?>">
						<?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(), '', array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) );do_action('wc_secondary_thumbnails'); ?>
					</a>
				</figure>
				<div class="product-detailes">
					<h2>
						<a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a>
					</h2>
					<div class="offer-add product-add">
						<div class="product-price">
							<?php echo $product->get_price_html(); ?>
						</div>
					</div>
					<div class="offer-timer">
						<?php if ( ! $deprecated ){ ?>
							<div class="timer">
								<div class="countdown timer-countdown-<?php $gshoprand=rand(); echo($gshoprand);?>" data-date="<?php echo date( 'Y-m-d', esc_attr( $date_end ) ); ?>"></div>
							</div>
							<script>
							
							jQuery(function($) {
								var dayz = new Date('<?php echo date( 'Y/m/d', esc_attr( $date_end ) ); ?> 23:59:59');
								jQuery('.timer-countdown-<?php echo($gshoprand);?>').countdown({ 
									until: dayz, 
									layout: '<span class="day"><b>{dn}</b></span>:<span class="hour"><b>{hn}</b></span>:<span class="min"><b>{mn}</b></span>:<span class="sec"><b>{sn}</b></span> '
								});
							});
							
							</script>
						<?php }else{?>
							<div class="offer-end">
								<?php echo __('This offer has expired','digix'); ?>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
			<?php
	}
	wp_reset_postdata();
?>
	</div>
</section>
    <?php
	}
}

}