<?php


#
##
# Main Elementor Extension Class

final class digix_elementor_extension 
{
	private static $_instance = null;
	public static function instance() 
    {
		if ( is_null( self::$_instance ) ) 
        {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
	public function __construct()
    {
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );
	}
	public function init()
     {
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}
	}
	public function admin_notice_missing_main_plugin() 
    {
		if ( isset( $_GET['activate'] ) ) 
        {
			unset( $_GET['activate'] );
		}
		$message = sprintf();
		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
	}
	public function init_widgets() 
    {
		require_once( DIGIX_DIR . '/includes/element/post.php' );
		if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) 
		{
			require_once( DIGIX_DIR . '/includes/element/product.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/gamingProduct.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/gamingProductTwo.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/bestselling.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/brand.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/story.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/special.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/amazing.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/special2.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/category.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/seen.php' ); //woo
			require_once( DIGIX_DIR . '/includes/element/product-search.php' ); //woo
		}
		require_once( DIGIX_DIR . '/includes/element/item.php' );
		if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) 
		{
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_product() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_gamingproduct() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_gamingproduct_two() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_bestselling() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_brand() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_story() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_special() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_amazing() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_special2() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_category() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_seen() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_product_search() );
		}
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_item() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \digix_elementor_post() );
    }

}
digix_elementor_extension::instance();
function digix_elementor_category( $elements_manager ) 
{
    $elements_manager->add_category(
        'digix',
        [
            'title' => __('DIGIX','digix'),
            'icon'  => 'fa fa-star',
        ]
    );
}
add_action( 'elementor/elements/categories_registered', 'digix_elementor_category' );