<?php
/**
 * WP Bootstrap Navwalker
 *
 * @package WP-Bootstrap-Navwalker
 *
 * @wordpress-plugin
 * Plugin Name: WP Bootstrap Navwalker
 * Plugin URI:  https://github.com/wp-bootstrap/wp-bootstrap-navwalker
 * Description: A custom WordPress nav walker class to implement the Bootstrap 4 navigation style in a custom theme using the WordPress built in menu manager.
 * Author: Edward McIntyre - @twittem, WP Bootstrap, William Patton - @pattonwebz, IanDelMar - @IanDelMar
 * Version: 4.3.0
 * Author URI: https://github.com/wp-bootstrap
 * GitHub Plugin URI: https://github.com/wp-bootstrap/wp-bootstrap-navwalker
 * GitHub Branch: master
 * License: GPL-3.0+
 * License URI: http://www.gnu.org/licenses/gpl-3.0.txt
 */
// Get menu description as global variable
function add_menu_desireid( $item_output, $item, $depth, $args ) {
    global $desireid;
    $desireid = $item->ID;
    return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'add_menu_desireid', 10, 4);
class digix_sidemenu extends Walker {
	private $tie_megamenu_type 			= '';
	private $tie_megamenu_icon 			= '';
	private $tie_megamenu_cicon 		= '';
	private $tie_megamenu_image 		= '';
	private $tie_megamenu_position 		= '';
	private $tie_megamenu_position_y 	= '';
	private $tie_megamenu_repeat 		= '';
	private $tie_megamenu_min_height 	= '';
	private $tie_megamenu_padding_left	= '';
	private $tie_megamenu_padding_right = '';
	private $tie_has_children 			= '';

  var $db_fields = array( 'parent' => 'menu_item_parent', 'id' => 'db_id' );
 //$i = 'mi-' . rand();

  function start_lvl( &$output, $depth = 0, $args = array() ) {
	 global $desireid;
    $indent = str_repeat("\t", $depth);
    $output .= "\n$indent<div class='submenu' id='dxmenu-". $desireid ."'><div class='submenu-header'><a href='#' data-submenu-close='dxmenu-". $desireid ."'>" . __('back','digix') . "</a></div><ul>\n";
  }

  function end_lvl( &$output, $depth = 0, $args = array() ) {
    $indent = str_repeat("\t", $depth);
    $output .= "$indent</ul></div>\n";
  }

  function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {

    global $wp_query;
    $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
    $class_names = $value = '';        
    $classes = empty( $item->classes ) ? array() : (array) $item->classes;
	$this->tie_megamenu_icon = get_post_meta( $item->ID, 'tie_megamenu_icon', true);
		$this->tie_megamenu_cicon = get_post_meta( $item->ID, 'tie_megamenu_cicon', true);
    /* Add active class */
    if(in_array('current-menu-item', $classes)) {
      $classes[] = 'active';
      unset($classes['current-menu-item']);
    }

    /* Check for children */
    $children = get_posts(array('post_type' => 'nav_menu_item', 'nopaging' => true, 'numberposts' => 1, 'meta_key' => '_menu_item_menu_item_parent', 'meta_value' => $item->ID));
    if (!empty($children)) {
      $classes[] = 'has-sub';
    }

    $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
    $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

    $id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
    $id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

    $output .= $indent . '<li' . $id . $value . $class_names .'>';

    $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
    $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
    $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
    $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

    $item_output = $args->before;
    $item_output .= '<a'. $attributes .'>';
	$item_output .= '<span>';
	if (!empty( $this->tie_megamenu_cicon ) ){
		$item_output .= '<img src="'.$this->tie_megamenu_cicon.'" class="cicon"/>';
	}else if( !empty( $this->tie_megamenu_cicon && !empty( $this->tie_megamenu_icon ) ) ){
		$item_output .= '<img src="'.$this->tie_megamenu_cicon.'" class="cicon"/>';
	}else if( !empty( $this->tie_megamenu_icon ) &&  empty( $this->tie_megamenu_cicon  )){
		 $item_output .= '<i class="'.$this->tie_megamenu_icon.'"></i>';
	}
	
    $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
	$iattribute   = ' data-submenu="dxmenu-'  . esc_attr( $item->ID ) .'"';
    $item_output .= '</span><i ' . $iattribute . ' class="icon-arrow-left"></i></a>';
    $item_output .= $args->after;

    $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
  }

  function end_el( &$output, $item, $depth = 0, $args = array() ) {
    $output .= "</li>\n";
  }
  
	function display_element( $element, &$children_elements, $max_depth, $depth=0, $args = array() , &$output ) {
		$id_field = $this->db_fields['id'];
		if ( is_object( $args[0] ) ) {
			$args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
		}
		return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	}
} 
add_filter( 'wp_edit_nav_menu_walker', 'tie_custom_nav_edit_walker',10,2 );
function tie_custom_nav_edit_walker($walker,$menu_id) {
    return 'tie_mega_menu_edit_walker';
}

add_action( 'wp_nav_menu_item_custom_fields', 'tie_add_megamenu_fields', 10, 4 );
function tie_add_megamenu_fields( $item_id, $item, $depth, $args ) { ?>

	<div class="clear"></div>
	<div class="tie-mega-menu-type">


		<p class="field-megamenu-type description description-wide">
			<label for="edit-menu-item-megamenu-type-<?php echo $item_id; ?>">
				مگامنو فعال شود؟
				<select id="edit-menu-item-megamenu-type-<?php echo $item_id; ?>" class="widefat code edit-menu-item-megamenu-type" name="menu-item-tie-megamenu-type[<?php echo $item_id; ?>]">
					<option value="disable" <?php selected( $item->tie_megamenu_type, 'disable' ); ?>>غیر فعال</option>
					<option value="links" <?php selected( $item->tie_megamenu_type, 'links' ); ?>>فعال</option>
				</select>
			</label>
		</p>

		<p class="field-megamenu-columns description description-wide">
			<label for="edit-menu-item-megamenu-columns-<?php echo $item_id; ?>">
				تعداد ستون
				<select id="edit-menu-item-megamenu-columns-<?php echo $item_id; ?>" class="widefat code edit-menu-item-megamenu-columns" name="menu-item-tie-megamenu-columns[<?php echo $item_id; ?>]">
					<option value="4" <?php selected( $item->tie_megamenu_columns, '4' ); ?>>4</option>
					<option value="5" <?php selected( $item->tie_megamenu_columns, '5' ); ?>>5</option>
				</select>
			</label>
		</p>
		<p class="field-megamenu-image description description-wide">
			<label for="edit-menu-item-tie-megamenu-icon-<?php echo $item_id; ?>">
				آیکون
			</label>
			<input type="text" id="edit-menu-item-tie-megamenu-icon-<?php echo $item_id; ?>" class="widefat code edit-menu-item-tie-megamenu-icon" name="menu-item-tie-megamenu-icon[<?php echo $item_id; ?>]" value="<?php echo $item->tie_megamenu_icon; ?>" />
			<span class="description">میتوانید از اینجا آیکون را انتخابئ کنید</span>
		</p>
		<p class="field-megamenu-image description description-wide">
			<label for="edit-menu-item-tie-megamenu-cicon-<?php echo $item_id; ?>">
				آیکون دلخواه ( اندازه طول و عرض تصویر 22 پیکسل در 22 پیکسل باشد)
			</label>
			<input type="text" id="edit-menu-item-tie-megamenu-cicon-<?php echo $item_id; ?>" class="widefat code edit-menu-item-tie-megamenu-cicon" name="menu-item-tie-megamenu-cicon[<?php echo $item_id; ?>]" value="<?php echo $item->tie_megamenu_cicon; ?>" />
			<span class="description">توجه کنید در صورتی که هر دو مقدار ورودی آیکون را وارد نمایید , آیکون دلخواه اولویت نمایش را داراست</span>
		</p>
		<p class="field-megamenu-image description description-wide">
			<label for="edit-menu-item-megamenu-image-<?php echo $item_id; ?>">
				پس زمینه مگامنو
			</label>
			<input type="text" id="edit-menu-item-megamenu-image-<?php echo $item_id; ?>" class="widefat code edit-menu-item-megamenu-image" name="menu-item-tie-megamenu-image[<?php echo $item_id; ?>]" value="<?php echo $item->tie_megamenu_image; ?>" />
		</p>


	</div>
<?php }


// Save The custom Fields
add_action('wp_update_nav_menu_item', 'tie_custom_nav_update', 10, 3);
function tie_custom_nav_update($menu_id, $menu_item_db_id, $args ) {

	$custom_meta_fields = array(
		'menu-item-tie-megamenu-type',
		'menu-item-tie-megamenu-columns',
		'menu-item-tie-megamenu-icon',
		'menu-item-tie-megamenu-cicon',
		'menu-item-tie-megamenu-image',
		'menu-item-tie-megamenu-position',
		'menu-item-tie-megamenu-position-y',
		'menu-item-tie-megamenu-min-height',
		'menu-item-tie-megamenu-repeat',
		'menu-item-tie-megamenu-padding-left',
		'menu-item-tie-megamenu-padding-right'
	);

	foreach( $custom_meta_fields as $custom_meta_field ){
		$save_option_name		= str_replace( 'menu-item-', '', $custom_meta_field);
		$save_option_name		= str_replace( '-', '_', $save_option_name);

		if ( !empty($_REQUEST[ $custom_meta_field ][ $menu_item_db_id ] ) ) {
			$custom_value = $_REQUEST[ $custom_meta_field ][ $menu_item_db_id ];
			update_post_meta( $menu_item_db_id, $save_option_name, $custom_value );
		}else{
			delete_post_meta( $menu_item_db_id, $save_option_name );
		}
	}
}

/*
 * Adds value of new field to $item object that will be passed to     Walker_Nav_Menu_Edit_Custom
 */
add_filter( 'wp_setup_nav_menu_item','tie_custom_nav_item' );
function tie_custom_nav_item($menu_item) {
    $menu_item->tie_megamenu_type			= get_post_meta( $menu_item->ID, 'tie_megamenu_type',			true );
    $menu_item->tie_megamenu_icon			= get_post_meta( $menu_item->ID, 'tie_megamenu_icon',			true );
	$menu_item->tie_megamenu_cicon			= get_post_meta( $menu_item->ID, 'tie_megamenu_cicon',			true );
    $menu_item->tie_megamenu_image			= get_post_meta( $menu_item->ID, 'tie_megamenu_image',			true );
    $menu_item->tie_megamenu_position 		= get_post_meta( $menu_item->ID, 'tie_megamenu_position',		true );
    $menu_item->tie_megamenu_position_y		= get_post_meta( $menu_item->ID, 'tie_megamenu_position_y',		true );
    $menu_item->tie_megamenu_repeat			= get_post_meta( $menu_item->ID, 'tie_megamenu_repeat',			true );
    $menu_item->tie_megamenu_min_height		= get_post_meta( $menu_item->ID, 'tie_megamenu_min_height',		true );
    $menu_item->tie_megamenu_padding_left	= get_post_meta( $menu_item->ID, 'tie_megamenu_padding_left',	true );
    $menu_item->tie_megamenu_padding_right	= get_post_meta( $menu_item->ID, 'tie_megamenu_padding_right',	true );
    return $menu_item;
}


/**
 * Navigation Menu template functions
 */
class tie_mega_menu_edit_walker extends Walker_Nav_Menu {
		/**
	 * Starts the list before the elements are added.
	 *
	 * @see Walker_Nav_Menu::start_lvl()
	 *
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args   Not used.
	 */
	public function start_lvl( &$output, $depth = 0, $args = array() ) {}

	/**
	 * Ends the list of after the elements are added.
	 *
	 * @see Walker_Nav_Menu::end_lvl()
	 *
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args   Not used.
	 */
	public function end_lvl( &$output, $depth = 0, $args = array() ) {}

	/**
	 * Start the element output.
	 *
	 * @see Walker_Nav_Menu::start_el()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item   Menu item data object.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args   Not used.
	 * @param int    $id     Not used.
	 */
	public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		global $_wp_nav_menu_max_depth;
		$_wp_nav_menu_max_depth = $depth > $_wp_nav_menu_max_depth ? $depth : $_wp_nav_menu_max_depth;

		ob_start();
		$item_id = esc_attr( $item->ID );
		$removed_args = array(
			'action',
			'customlink-tab',
			'edit-menu-item',
			'menu-item',
			'page-tab',
			'_wpnonce',
		);

		$original_title = '';
		if ( 'taxonomy' == $item->type ) {
			$original_title = get_term_field( 'name', $item->object_id, $item->object, 'raw' );
			if ( is_wp_error( $original_title ) )
				$original_title = false;
		} elseif ( 'post_type' == $item->type ) {
			$original_object = get_post( $item->object_id );
			$original_title = get_the_title( $original_object->ID );
		}

		$classes = array(
			'menu-item menu-item-depth-' . $depth,
			'menu-item-' . esc_attr( $item->object ),
			'menu-item-edit-' . ( ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? 'active' : 'inactive'),
		);

		$title = $item->title;

		if ( ! empty( $item->_invalid ) ) {
			$classes[] = 'menu-item-invalid';
			/* translators: %s: title of menu item which is invalid */
			$title = sprintf( __( '%s (Invalid)' ), $item->title );
		} elseif ( isset( $item->post_status ) && 'draft' == $item->post_status ) {
			$classes[] = 'pending';
			/* translators: %s: title of menu item in draft status */
			$title = sprintf( __('%s (Pending)'), $item->title );
		}

		$title = ( ! isset( $item->label ) || '' == $item->label ) ? $title : $item->label;

		$submenu_text = '';
		if ( 0 == $depth )
			$submenu_text = 'style="display: none;"';

		?>
		<li id="menu-item-<?php echo $item_id; ?>" class="<?php echo implode(' ', $classes ); ?>">
			<dl class="menu-item-bar">
				<dt class="menu-item-handle">
					<span class="item-title"><span class="menu-item-title"><?php echo esc_html( $title ); ?></span> <span class="is-submenu" <?php echo $submenu_text; ?>><?php _e( 'sub item' ); ?></span></span>
					<span class="item-controls">
						<span class="item-type"><?php echo esc_html( $item->type_label ); ?></span>
						<span class="item-order hide-if-js">
							<a href="<?php
								echo wp_nonce_url(
									add_query_arg(
										array(
											'action' => 'move-up-menu-item',
											'menu-item' => $item_id,
										),
										remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
									),
									'move-menu_item'
								);
							?>" class="item-move-up"><abbr title="<?php esc_attr_e('Move up'); ?>">&#8593;</abbr></a>
							|
							<a href="<?php
								echo wp_nonce_url(
									add_query_arg(
										array(
											'action' => 'move-down-menu-item',
											'menu-item' => $item_id,
										),
										remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
									),
									'move-menu_item'
								);
							?>" class="item-move-down"><abbr title="<?php esc_attr_e('Move down'); ?>">&#8595;</abbr></a>
						</span>
						<a class="item-edit" id="edit-<?php echo $item_id; ?>" title="<?php esc_attr_e('Edit Menu Item'); ?>" href="<?php
							echo ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? admin_url( 'nav-menus.php' ) : add_query_arg( 'edit-menu-item', $item_id, remove_query_arg( $removed_args, admin_url( 'nav-menus.php#menu-item-settings-' . $item_id ) ) );
						?>"><?php _e( 'Edit Menu Item' ); ?></a>
					</span>
				</dt>
			</dl>

			<div class="menu-item-settings wp-clearfix" id="menu-item-settings-<?php echo $item_id; ?>">
				<?php if( 'custom' == $item->type ) : ?>
					<p class="field-url description description-wide">
						<label for="edit-menu-item-url-<?php echo $item_id; ?>">
							<?php _e( 'URL' ); ?><br />
							<input type="text" id="edit-menu-item-url-<?php echo $item_id; ?>" class="widefat code edit-menu-item-url" name="menu-item-url[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->url ); ?>" />
						</label>
					</p>
				<?php endif; ?>
				<p class="description description-thin">
					<label for="edit-menu-item-title-<?php echo $item_id; ?>">
						<?php _e( 'Navigation Label' ); ?><br />
						<input type="text" id="edit-menu-item-title-<?php echo $item_id; ?>" class="widefat edit-menu-item-title" name="menu-item-title[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->title ); ?>" />
					</label>
				</p>
				<p class="field-link-target description">
					<label for="edit-menu-item-target-<?php echo $item_id; ?>">
						<input type="checkbox" id="edit-menu-item-target-<?php echo $item_id; ?>" value="_blank" name="menu-item-target[<?php echo $item_id; ?>]"<?php checked( $item->target, '_blank' ); ?> />
						<?php _e( 'Open link in a new window/tab' ); ?>
					</label>
				</p>
				<p class="field-css-classes description description-thin">
					<label for="edit-menu-item-classes-<?php echo $item_id; ?>">
						<?php _e( 'CSS Classes (optional)' ); ?><br />
						<input type="text" id="edit-menu-item-classes-<?php echo $item_id; ?>" class="widefat code edit-menu-item-classes" name="menu-item-classes[<?php echo $item_id; ?>]" value="<?php echo esc_attr( implode(' ', $item->classes ) ); ?>" />
					</label>
				</p>
				<p class="field-xfn description description-thin">
					<label for="edit-menu-item-xfn-<?php echo $item_id; ?>">
						<?php _e( 'Link Relationship (XFN)' ); ?><br />
						<input type="text" id="edit-menu-item-xfn-<?php echo $item_id; ?>" class="widefat code edit-menu-item-xfn" name="menu-item-xfn[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->xfn ); ?>" />
					</label>
				</p>
				<p class="field-description description description-wide">
					<label for="edit-menu-item-description-<?php echo $item_id; ?>">
						<?php _e( 'Description' ); ?><br />
						<textarea id="edit-menu-item-description-<?php echo $item_id; ?>" class="widefat edit-menu-item-description" rows="3" cols="20" name="menu-item-description[<?php echo $item_id; ?>]"><?php echo esc_html( $item->description ); // textarea_escaped ?></textarea>
						<span class="description"><?php _e('The description will be displayed in the menu if the current theme supports it.'); ?></span>
					</label>
				</p>


				<?php
					//By Tielabs **************************************************

						do_action( 'wp_nav_menu_item_custom_fields', $item_id, $item, $depth, $args );

					// END ********************************************************
				?>

				<p class="field-move hide-if-no-js description description-wide">
					<label>
						<span><?php _e( 'Move' ); ?></span>
						<a href="#" class="menus-move-up"><?php _e( 'Up one' ); ?></a>
						<a href="#" class="menus-move-down"><?php _e( 'Down one' ); ?></a>
						<a href="#" class="menus-move-left"></a>
						<a href="#" class="menus-move-right"></a>
						<a href="#" class="menus-move-top"><?php _e( 'To the top' ); ?></a>
					</label>
				</p>

				<div class="menu-item-actions description-wide submitbox">
					<?php if( 'custom' != $item->type && $original_title !== false ) : ?>
						<p class="link-to-original">
							<?php printf( __('Original: %s'), '<a href="' . esc_attr( $item->url ) . '">' . esc_html( $original_title ) . '</a>' ); ?>
						</p>
					<?php endif; ?>
					<a class="item-delete submitdelete deletion" id="delete-<?php echo $item_id; ?>" href="<?php
					echo wp_nonce_url(
						add_query_arg(
							array(
								'action' => 'delete-menu-item',
								'menu-item' => $item_id,
							),
							admin_url( 'nav-menus.php' )
						),
						'delete-menu_item_' . $item_id
					); ?>">حذف</a> <span class="meta-sep hide-if-no-js"> | </span> <a class="item-cancel submitcancel hide-if-no-js" id="cancel-<?php echo $item_id; ?>" href="<?php echo esc_url( add_query_arg( array( 'edit-menu-item' => $item_id, 'cancel' => time() ), admin_url( 'nav-menus.php' ) ) );
						?>#menu-item-settings-<?php echo $item_id; ?>">کنسل</a>
				</div>

				<input class="menu-item-data-db-id" type="hidden" name="menu-item-db-id[<?php echo $item_id; ?>]" value="<?php echo $item_id; ?>" />
				<input class="menu-item-data-object-id" type="hidden" name="menu-item-object-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->object_id ); ?>" />
				<input class="menu-item-data-object" type="hidden" name="menu-item-object[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->object ); ?>" />
				<input class="menu-item-data-parent-id" type="hidden" name="menu-item-parent-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->menu_item_parent ); ?>" />
				<input class="menu-item-data-position" type="hidden" name="menu-item-position[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->menu_order ); ?>" />
				<input class="menu-item-data-type" type="hidden" name="menu-item-type[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->type ); ?>" />
			</div>
			<ul class="menu-item-transport"></ul>
		<?php
		$output .= ob_get_clean();
	}
}