<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Digix
 */

get_header();
Global $post;
$post_id = get_the_id();
?>

<main class="main" role="main" itemscope itemprop="mainContentOfPage">
	<div class="mobtainer">
        <?php 
        if( function_exists('digix_breadcrumb')):
            echo digix_breadcrumb(); 
        endif;
        ?>
        <?php if ( have_posts() ): ?>
            <?php while ( have_posts() ):the_post(); ?>
                <section class="site-single">
                    <article id="post-<?php the_ID(); ?>" <?php post_class('content-post-single'); ?>>
                        <header class="entry-header">
                            <?php the_title('<h1 class="entry-title">', '</h1>'); ?>
                        </header><!-- .entry-header -->

                        <div class="entry-meta">
                            <span class="meta-item">
                                <i class="icon-calendar"></i>
                                <?php $i = get_post_time(); $timestamp2 = strtotime(get_post_time()); echo dx_jdate('Y/m/d', $i); ?>
                            </span>
                            <span class="meta-item">
                                <i class="icon-movies-app"></i>
                                <?php the_category(' , ') ?>
                            </span>
                            <span class="meta-item">
                                <?php echo get_avatar( get_the_author_meta( 'ID' ), 25 ); ?>
                                <?php echo get_the_author_meta( 'display_name', get_the_author_meta('ID')  ); ?>
                            </span>
                            <span class="meta-item">
                                <?php echo get_simple_likes_button( get_the_ID() ); ?>
                            </span>
                            <span class="meta-item">
                                <i class="icon-tinder"></i>
                                <?php echo digix_wp_get_views($post_id); ?>
                            </span>
                            <span class="meta-item">
                                <?php if ( function_exists('rmp_get_visual_rating') && rmp_get_visual_rating($post_id) ) { ?>
                                    <span class="average-stars"><?php echo rmp_get_visual_rating($post_id); ?></span>
                                    <span class="average-rate"><span class="average-rate"><?php echo str_replace('/',',',rmp_get_avg_rating($post_id)); ?></span>/5</span>
                                <?php } ?>
                            </span>
                        </div>
                        
                        <div class="entry-content clearfix">
                        <?php if ( has_post_thumbnail()) : ?>
                            <figure class="single-thumbnail">
                                <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php  the_title_attribute(); ?>" class="img-fluid thumbnail-img">
                            </figure>
                        <?php endif; ?>
                            <?php the_content();digix_wp_set_views(get_the_ID()); ?>
                        </div>

                        <footer class="entry-footer">
                            <strong><?php echo __('Tags: ','digix') . '</strong>';
                                if(has_tag())
                                { 
                                    the_tags(' ','    ');
                                }else{
                                    echo '<p>' . __('This article is unlabeled.','digix') . '</p>';
                                }
                            ?>
                        </footer>
                    </article><!-- #post-<?php the_ID(); ?> -->
                </section>
            <?php endwhile; ?>
        <?php endif; ?>   
        <section class="related-post moblog">
            <header class="page-header">
                <h3 class="page-title">
                    <?php
                    echo __( 'Related post', 'digix' );
                    ?>
                </h3>
            </header>
            <div class="list">
            <?php
            $post_id = get_the_ID();
            $cat_ids = array();
            $categories = get_the_category( $post_id );
        
            if(!empty($categories) && !is_wp_error($categories)):
                foreach ($categories as $category):
                    array_push($cat_ids, $category->term_id);
                endforeach;
            endif;
        
            $current_post_type = get_post_type($post_id);
        
            $query_args = array( 
                'category__in'    => $cat_ids,
                'post_type'       => $current_post_type,
                'post__not_in'    => array($post_id),
                'orderby'         => 'rand',
                'posts_per_page'  => '4',
             );
        
            $related = new WP_Query( $query_args );
        
            if($related->have_posts()):
                 while($related->have_posts()): $related->the_post(); ?>
					<div class="item">
						<a href="<?php the_permalink();?>" class="thumbnail">
							<?php if ( has_post_thumbnail()) { the_post_thumbnail(array(100,100),array('class' => 'img-fluid')); }else{ ?>
									<img class="thumb" src="<?php bloginfo('template_url'); ?>/assets/img/noimg.png" width="150" height="150" alt="<?php the_title_attribute(); ?>" title="<?php the_title_attribute(); ?>"/>
							<?php } ?>
						</a>
						<div class="title">
							<a href="<?php the_permalink();?>">
								<?php the_title(); ?>
							</a>   
						</div>
					</div>
            <?php endwhile; wp_reset_postdata();endif; ?> 
            </div>
        </section>
        <?php if (comments_open() || get_comments_number()) : ?>
            <section class="single-comment" id="comments">
                <?php comments_template(); ?>
            </section>
		<?php endif; ?>
    </div>
</main>

<?php get_footer(); ?>