<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.9.0
 */
GLOBAL $product, $post;
$post_id = get_the_id();
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $options;
$attributes = $options['woocommerce-archive-attributes'];
$pitem_boxshadow = $options['woocommerce-pitem-boxshadow'];
if ( $related_products ) : ?>

	<section class="related digix-product">
		<?php
		$heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Related products', 'woocommerce' ) );

		if ( $heading ) :
			?>
			<h3><strong><?php echo esc_html( $heading ); ?></strong></h3>
		<?php endif; ?>	
            <div class="mobile-product">
                    <?php 
                        $terms = wp_get_post_terms( $post_id, 'product_cat' );
                        $term_ids = array();
                        foreach ($terms as $key => $value) 
                        {
                            $term_ids[] = $value->term_id;
                        }
                        $args = array(
                          'post_type'            => 'product',
                          'ignore_sticky_posts'  => 1,
                          'no_found_rows'        => 1,
                          'orderby'              => 'date',
                          'meta_query' => array(
                                array(
                                    'key' => '_stock_status',
                                    'value' => 'instock'
                                ),
                            ),
                          'tax_query' => array(
                            array(
                              'taxonomy' => 'product_cat',
                              'field'    => 'term_id',
                              'terms'    => $term_ids,
                            ),
                          ),
                          'post__not_in'         => array( $post_id )
                        );
                        
                        $digix_related = new WP_Query($args);
                        while ($digix_related->have_posts()):  $digix_related->the_post();GLOBAL $product; ?>
							<div class="product-item">
								<?php if($product->is_on_sale()){ ?>
									<div class="discount">
										٪<?php echo digix_wooocmmerce_discount(get_the_ID()) ?>
									</div>
								<?php } ?>
								<figure class="product-thumbnails">
									<a href="<?php echo $product->get_permalink(); ?>">
										<?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(), 'woocommerce_thumbnail', array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) );do_action('wc_secondary_thumbnails'); ?>
									</a>
								</figure>
								<div class="product-detailes">
									<h2>
										<a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a>
									</h2>
									<div class="product-add <?php if( $options['woocommerce-addcart'] != 'yes' ){echo'justify-content-center text-center';}?>">
										<div class="product-price">
											<?php echo $product->get_price_html(); ?>
										</div>
										<?php if ( $options['woocommerce-addcart'] == 'yes' ) : ?>
											<button class="add-to-cart-wrap" data-toggle="tooltip" data-original-title="<?php echo esc_html( $product->add_to_cart_text() );?>">
												<a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" data-quantity="1" class="<?php echo esc_attr( implode( ' ', array_filter( array( 'button', 'product_type_' . $product->get_type(), $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '', $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '', ) ) ) );?>" <?php echo wc_implode_html_attributes( array( 'data-product_id'  => $product->get_id(), 'data-product_sku' => $product->get_sku(), 'aria-label'       => $product->add_to_cart_description(), 'rel'              => 'nofollow',) );?>><i class="icon-shopping-basket"></i></a>
											</button>
										<?php endif; ?>
									</div>
								</div>
							</div>
                    <?php endwhile; wp_reset_postdata(); ?>
            </div>	
    </section>
	<?php
endif;

wp_reset_postdata();