<?php
/**
 * Plugin Name: LifterLMS Theme Switcher (WoodMart to BuddyBoss)
 * Description: نسخه ۵.۰.۰ - بهینه‌سازی شده برای امنیت بالا، سرعت حداکثری و چیدمان دقیق گرید.
 * Version: 5.0.0
 * Author: امین خسروی
 * License: GPL2
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// تعریف ثابت‌ها برای جلوگیری از تکرار پردازش
define( 'LLMS_SWITCH_THEME_SLUG', 'buddyboss' );
define( 'LLMS_SWITCHER_VER', '5.0.0' );

/**
 * تشخیص هوشمند و سریع صفحات LifterLMS
 */
function is_lifterlms_content_active(): bool {
    if ( ! class_exists( 'LifterLMS' ) ) return false;

    // اولویت اول: توابع شرطی داخلی LifterLMS (بسیار سریع)
    if ( is_singular( array( 'course', 'lesson', 'llms_membership', 'llms_quiz' ) ) ) return true;
    if ( is_post_type_archive( 'course' ) || is_tax( array( 'course_cat', 'course_tag' ) ) ) return true;
    
    if ( function_exists( 'is_courses' ) && is_courses() ) return true;
    if ( function_exists( 'is_memberships' ) && is_memberships() ) return true;
    
    // اولویت دوم: بررسی URL برای اطمینان در ساختارهای سفارشی
    if ( isset( $_SERVER['REQUEST_URI'] ) ) {
        $url = $_SERVER['REQUEST_URI'];
        if ( preg_match( '/\/(course|lesson|courses|membership|course-cat)\//i', $url ) ) {
            return true;
        }
    }

    return false;
}

/**
 * مدیریت تعویض قالب و حذف هشدارها
 */
add_action( 'setup_theme', 'llms_switcher_core_init', 1 );
function llms_switcher_core_init() {
    // ۱. حذف هشدارهای قرمز (حتی در ادمین) برای پایداری و زیبایی پیشخوان
    add_filter( 'llms_is_theme_supported', '__return_true', 999 );
    remove_action( 'admin_notices', 'llms_show_theme_support_notice' );

    // جلوگیری از اجرای کدهای اضافی در پنل مدیریت یا درخواست‌های AJAX
    if ( is_admin() || wp_doing_ajax() ) return;

    if ( is_lifterlms_content_active() ) {
        // ۲. تعویض قالب به روش استاندارد وردپرس
        add_filter( 'template', 'llms_get_target_theme_slug', 999 );
        add_filter( 'stylesheet', 'llms_get_target_theme_slug', 999 );
        
        $target_path = trailingslashit( WP_CONTENT_DIR ) . 'themes/' . LLMS_SWITCH_THEME_SLUG;
        add_filter( 'template_directory', function() use ( $target_path ) { return $target_path; }, 999 );
        add_filter( 'stylesheet_directory', function() use ( $target_path ) { return $target_path; }, 999 );

        // ۳. اصلاح کلاس‌های بادی برای هماهنگی با BuddyBoss
        add_filter( 'body_class', 'llms_switcher_body_class_fix', 999 );
        
        // ۴. لود فایل‌های مورد نیاز
        add_action( 'wp_enqueue_scripts', 'llms_switcher_enqueue_assets', 9999 );
    }
}

function llms_get_target_theme_slug() { return LLMS_SWITCH_THEME_SLUG; }

/**
 * اصلاح کلاس‌های Body
 */
function llms_switcher_body_class_fix( $classes ) {
    $classes[] = 'theme-' . LLMS_SWITCH_THEME_SLUG;
    $classes[] = 'buddyboss-active';
    $classes[] = 'buddyboss-theme';
    $classes[] = 'bb-lifterlms-active';

    if ( is_post_type_archive( 'course' ) || ( function_exists( 'is_courses' ) && is_courses() ) ) {
        $classes[] = 'post-type-archive-course';
        $classes[] = 'bb-course-archive';
    }
    
    // حذف کلاس‌های وودمارت برای جلوگیری از تداخل CSS
    return array_unique( array_diff( $classes, array( 'woodmart-light', 'woodmart-dark', 'woodmart-archive-shop' ) ) );
}

/**
 * بارگذاری بهینه فایل‌های CSS و JS
 */
function llms_switcher_enqueue_assets() {
    $uri = trailingslashit( content_url( 'themes/' . LLMS_SWITCH_THEME_SLUG ) );
    $path = trailingslashit( WP_CONTENT_DIR . '/themes/' . LLMS_SWITCH_THEME_SLUG );

    wp_enqueue_style( 'bb-main', $uri . 'style.css', array(), LLMS_SWITCHER_VER );
    
    if ( file_exists( $path . 'assets/css/theme.min.css' ) ) {
        wp_enqueue_style( 'bb-theme', $uri . 'assets/css/theme.min.css', array(), LLMS_SWITCHER_VER );
    }
    
    if ( is_rtl() && file_exists( $path . 'assets/css/rtl.min.css' ) ) {
        wp_enqueue_style( 'bb-rtl', $uri . 'assets/css/rtl.min.css', array('bb-theme'), LLMS_SWITCHER_VER );
    }

    if ( file_exists( $path . 'assets/js/theme.min.js' ) ) {
        wp_enqueue_script( 'bb-js', $uri . 'assets/js/theme.min.js', array('jquery'), LLMS_SWITCHER_VER, true );
    }
}

/**
 * استایل‌های نهایی برای گرید کاتالوگ و مخفی‌سازی خطاها
 */
add_action('wp_head', function() {
    if ( is_lifterlms_content_active() ) {
        ?>
        <style>
            .llms-notice, .llms-alert-error { display: none !important; }
            
            /* گرید کاتالوگ منعطف و استاندارد */
            .post-type-archive-course .llms-loop-list, 
            .bb-course-archive .llms-loop-list,
            .llms-course-list {
                display: flex !important;
                flex-wrap: wrap !important;
                margin: 0 -15px !important;
                padding: 0 !important;
                list-style: none !important;
            }

            .llms-loop-item {
                flex: 0 0 calc(33.333% - 30px) !important;
                width: calc(33.333% - 30px) !important;
                margin: 15px !important;
                background: #fff;
                border-radius: 12px;
                overflow: hidden;
                box-shadow: 0 4px 15px rgba(0,0,0,0.08);
                transition: transform 0.3s ease;
            }

            .llms-loop-item:hover { transform: translateY(-5px); }

            @media (max-width: 992px) { .llms-loop-item { flex: 0 0 calc(50% - 30px) !important; width: calc(50% - 30px) !important; } }
            @media (max-width: 600px) { .llms-loop-item { flex: 0 0 calc(100% - 30px) !important; width: calc(100% - 30px) !important; } }

            .main-page-wrapper { width: 100% !important; max-width: none !important; }
        </style>
        <?php
    }
}, 30);