(function($){
    jQuery(document).ready(function($) {

    
        // مرحله 1: کلیک روی دکمه شروع
        $('#ragStartButton').on('click', function() {
            chatbotSettings.currentStep = 2;
            showStep(2);
        });
    
        // مرحله 2: انتخاب پست تایپ‌ها
        $('.rag-post-type-checkbox').on('change', function() {
            updateSelectedPostTypes();
            updateContinueButton();
        });
    
        // دکمه انصراف
        $('#ragCancelButton').on('click', function() {
            resetToStep1();
        });
    
    
        // دکمه شروع مجدد
        $('#ragStartAgainButton').on('click', function() {
            resetToStep1();
        });
    
        // تابع به‌روزرسانی پست تایپ‌های انتخاب شده
        function updateSelectedPostTypes() {
            chatbotSettings.selectedPostTypes = [];
            $('.rag-post-type-checkbox:checked').each(function() {
                chatbotSettings.selectedPostTypes.push($(this).val());
            });
        }
    
        // تابع به‌روزرسانی وضعیت دکمه ادامه
        function updateContinueButton() {
            const continueBtn = $('#ragContinueButton');
            if (chatbotSettings.selectedPostTypes.length > 0) {
                continueBtn.prop('disabled', false);
            } else {
                continueBtn.prop('disabled', true);
            }
        }
    
        // تابع نمایش مرحله
        function showStep(stepNumber) {
            $('.rag-step').removeClass('active');
            $('#ragStep' + stepNumber).addClass('active');
            chatbotSettings.currentStep = stepNumber;
        }
    
    
        // تابع نمایش نتایج
        function displayResults(data) {
            const resultsContent = $('#ragResultsContent');
            let html = '';
    
            // تعداد کل نوشته‌های RAG شده
            if (data.total_processed !== undefined) {
                html += '<div class="rag-result-item">';
                html += '<h4 class="rag-result-item-title">';
                html += '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
                html += '<path d="M9 11l3 3L22 4M21 12v7a2 2 0 01-2 2H5a2 2 0 01-2-2V5a2 2 0 012-2h11"/>';
                html += '</svg>';
                html += 'تعداد کل نوشته‌های RAG شده';
                html += '</h4>';
                html += '<p class="rag-result-item-value">' + (data.total_processed || 0) + '</p>';
                html += '<p class="rag-result-item-description">تعداد کل نوشته‌هایی که با موفقیت پردازش شدند</p>';
                html += '</div>';
            }
    
            // آمار به تفکیک پست تایپ
            if (data.post_types_stats && Object.keys(data.post_types_stats).length > 0) {
                html += '<div class="rag-result-stats">';
                for (const [postType, count] of Object.entries(data.post_types_stats)) {
                    html += '<div class="rag-stat-card">';
                    html += '<p class="rag-stat-label">' + postType + '</p>';
                    html += '<p class="rag-stat-value">' + count + '</p>';
                    html += '</div>';
                }
                html += '</div>';
            }
    
            // اگر داده‌ای وجود نداشت
            if (html === '') {
                html = '<div class="rag-result-item">';
                html += '<p class="rag-result-item-description">اطلاعات در حال آماده‌سازی است...</p>';
                html += '</div>';
            }
    
            resultsContent.html(html);
        }
    
        
        function resetToStep1() {
            chatbotSettings.currentStep = 1;
            chatbotSettings.selectedPostTypes = [];
            $('.rag-post-type-checkbox').prop('checked', false);
            updateContinueButton();
            showStep(1);
        }
    });
})(jQuery);
