(function($){

        $(document).ready(function(){


            $('body').on('click','.export_csv',function(e){
                e.preventDefault();


               $('#export-popup').css({
                    'display':'flex'
               });

            });

            $('body').on('click','.start_export',function(e){
                e.preventDefault();
                var $this = $(this);
                var parent = $this.parents('#export-fields-form');
                var lentgth_input = [];
                    parent.find('input[type="checkbox"]').each(function(){
                        if($(this).is(':checked')){
                            
                            lentgth_input.push($(this).val());
                        }
                    });

                if( !lentgth_input.length )
                {
                    return alert( 'لطفا یک فیلد را برای خروجی گرفتن انتخاب کنید' )
                }
                
                parent.submit();
            });
            
            $('body').on('click','.close_popup',function(e){
                e.preventDefault();

               $('#export-popup').css({
                    'display':'none'
               });

            });


            $('body').on('click','.start_action',function(e){
                e.preventDefault();
                
            });

            var $ajax_loaded = false;


            sessionStorage.removeItem('ajaxCache');

            $('.start_action').on('click', function() {
                
                const $this = $(this);
                const cartHash = $(this).data('cart_hash');
                const row = $(this).closest('tr');
                const user_id = row.find('.column-user_id a').data('user_id');

                const name = row.find('td:eq(1)').clone().children().remove().end().text().trim();
                const lastName = !row.find('td:eq(2)').children().length ? row.find('td:eq(2)').text() : '';

                const customerName = name + ' ' + lastName;
                const customerPhone = row.find('td:eq(4)').text();
                const ajaxCache = JSON.parse(sessionStorage.getItem('ajaxCache')) || {};
                
                const customDetial =  $this.parents('body').find('.customer-details-sms button');
                // const customerObjectKey = Object.keys(cartHash) + customerPhone;
                const customerCartHashName = Object.keys(cartHash) + customerPhone + 'cr';

                $('.customer-name').text(customerName);
                $('.customer-phone').text(customerPhone);
                $('.customer-name').attr('data-user_id', user_id);

                $('#cart-details-popup').fadeIn();
                
                if( ajaxCache[customerCartHashName] )
                {
                    $('.products-list').html(ajaxCache[customerCartHashName]);
                    customDetial.attr('data-user_id', user_id);

                    $('.price_totalcart').html( $('.trick_totalcart').html() );
                    $('.trick_totalcart').remove(); 
                    return;
                }

                $('.cart-products-section').addClass('loading');
                $('.products-list').empty();
                customDetial.attr('data-user_id', user_id);

                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'get_cart_products',
                        cart_hash: cartHash,
                        customer_phone : customerPhone,
                        user_id : user_id,
                        // nonce: woodmartplus.nonce
                    },
                    success: function(response) {
                        $('.cart-products-section').removeClass('loading');
                        $('.products-list').html(response.template);
                        customDetial.html(response.customer_detial);

                        const $html = $('.trick_totalcart').html();
                        $('.trick_totalcart').remove(); 

                        $('.price_totalcart').html( $html );
                        
                        ajaxCache[customerCartHashName] = response.template;
                        // ajaxCache[customerObjectKey] = response.customer_detial;
                        
                        sessionStorage.setItem('ajaxCache', JSON.stringify(ajaxCache));
                        $ajax_loaded = true;
                    },
                    error:function(error)
                    {
                        console.log(error);
                        $('.cart-products-section').removeClass('loading');
                    }
                });

                
            });
            
            $('.close-popup').on('click', function() {
                $('#cart-details-popup').fadeOut();
            });
            
            $('.send-sms').on('click', function() {
                
                if( !$ajax_loaded ) return;

                const btn = $(this);
                const parentPopup = btn.parents('.cart-popup-content');
                const smsContent = $('#sms-content').val();
                const phone = parentPopup.find('.customer-phone').text();
                const customerName = parentPopup.find('.customer-name').text();
                const totalCart = parentPopup.find('.price_totalcart .woocommerce-Price-amount').text().trim();
                const productList = parentPopup.find('.products-list .product-info h5>a');
                const productName = [];
                let quantityCart = 0;
                const parent = $('.sms-section');
                const notic = $('.nit');
                const user_id = parentPopup.find('.customer-name').data('user_id');

                productList.each(function(index,html){
                    productName.push($(html).text());
                    quantityCart++
                });

                const all_data = {
                    'phone' : phone,
                    'customerName' : customerName,
                    'totalCart' : totalCart,
                    'productName' : productName,
                    'quantityCart' : quantityCart,
                    'user_id' : user_id
                };

                btn.css({
                    'pointer-events' : 'none'
                });


                parent.addClass('loading');
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'send_cart_sms',
                        all_data : all_data,
                        // nonce: woodmartplus.nonce
                    },
                    success: function(response) {
                        btn.css({
                            'pointer-events' : 'unset'
                        });
    
                        // alert('پیامک با موفقیت ارسال شد');
                        // $('#cart-details-popup').fadeOut();
                        parent.removeClass('loading');
                        notic.addClass('notic-succ');
                        notic.text(response.msg);
                        
                        setTimeout(() => {
                            notic.empty();
                            notic.removeClass('notic-succ');
                        }, 3000);
                    },
                    error:function(error){
                        
                        btn.css({
                            'pointer-events' : 'unset'
                        });
                        parent.removeClass('loading');
                        notic.addClass('notic-war');
                        notic.text(error.responseJSON.msg);

                        setTimeout(() => {
                            notic.empty();
                            notic.removeClass('notic-war');
                        }, 3000);
                    }
                });
            });

            $('body').on('click', '.check-log-sms', function() {
                $('#sms-log-popup').fadeIn();
                const $this = $(this);
                const user_id = $(this).attr('data-user_id');
                const $log_popup = $this.parents('body').find('#sms-log-popup');
                
                // Get cached data if available
                const ajaxCache = JSON.parse(sessionStorage.getItem('ajaxCache')) || {};
                const logCacheKey = 'sms_log_' + user_id;
                
                if (ajaxCache[logCacheKey]) {
                    $log_popup.find('.sms-log-entries').html(ajaxCache[logCacheKey].sms_log);
                    $log_popup.find('.email-log-entries').html(ajaxCache[logCacheKey].email_log);
                    return;
                }
                
                $log_popup.find('.sms-log-entries').html('');
                $log_popup.find('.email-log-entries').html('');
                $log_popup.find('.sms-log-popup-body').addClass('loading');
                const $loadingHtml = '<div class="sms-log-loading"><div class="lds-ripple"><div></div><div></div></div></div>';
                $log_popup.find('.sms-log-popup-body').append($loadingHtml);
                
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'get_log_sms',
                        user_id : user_id,
                        // nonce: woodmartplus.nonce
                    },
                    success: function(response) {
                        $log_popup.find('.sms-log-popup-body').removeClass('loading');
                        $log_popup.find('.sms-log-loading').remove();
                        $log_popup.find('.sms-log-entries').html(response.sms_log);
                        $log_popup.find('.email-log-entries').html(response.email_log);
                        
                        // Cache the response
                        ajaxCache[logCacheKey] = {
                            sms_log: response.sms_log,
                            email_log: response.email_log
                        };
                        sessionStorage.setItem('ajaxCache', JSON.stringify(ajaxCache));
                    },
                    error: function(error){
                        $log_popup.find('.sms-log-popup-body').removeClass('loading');
                        $log_popup.find('.sms-log-loading').remove();
                        $log_popup.find('.sms-log-entries').html('<p>خطا در بارگذاری اطلاعات</p>');
                    }
                });
            });
           
            $('.close-sms-log, .close-sms-log-btn').on('click', function() {
                $('#sms-log-popup').fadeOut();
            });
            
        });

        $(document).ready(function() {
            let selectedUserId = null;
            let searchTimeout = null;
            // باز کردن پاپ آپ
            $('#charge-wallet-btn').on('click', function() {
                $('#wallet-charge-popup').fadeIn(300);
                $('#user-search').focus();
            });

            // بستن پاپ آپ
            $('.wallet-popup-close, #cancel-charge-btn').on('click', function() {
                closePopup();
            });

            // بستن پاپ آپ با کلیک روی overlay
            $('.wallet-popup-overlay').on('click', function(e) {
                if (e.target === this) {
                    closePopup();
                }
            });

            // بستن پاپ آپ با کلید ESC
            $(document).on('keydown', function(e) {
                if (e.key === 'Escape' && $('#wallet-charge-popup').is(':visible')) {
                    closePopup();
                }
            });

            // جستجوی کاربر
            $('#user-search').on('input', function() {
                const query = $(this).val().trim();
                
                clearTimeout(searchTimeout);
                
                if (query.length < 2) {
                    $('#user-search-results').hide();
                    return;
                }

                searchTimeout = setTimeout(function() {
                    searchUsers(query);
                }, 300);
            });

            // انتخاب کاربر از نتایج جستجو
            $(document).on('click', '.search-result-item', function() {
                const userId = $(this).data('user-id');
                const username = $(this).find('.user-info').text();
                const firstname = $(this).data('firstname');
                const lastname = $(this).data('lastname');
                const phone = $(this).data('phone');
                const currentWallet = $(this).data('wallet');

                selectedUserId = userId;
                
                $('#wallet_user_id').val(userId);
                $('#user-search').val(username);
                $('#user-search-results').hide();
                
                $('#selected-username').text(username);
                $('#selected-firstname').text(firstname || 'تعریف نشده');
                $('#selected-lastname').text(lastname || 'تعریف نشده');
                $('#selected-phone').text(phone || 'تعریف نشده');
                // $('#selected-current-wallet').text(currentWallet || '0 تومان');
                $('#selected-user-info').show();
            });


            function searchUsers(query) {

                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'search_users',
                        query: query,
                        nonce: woodmartplusTab.nonce
                    },
                    success: function(response) {
                        displaySearchResults(response.data);
                    },
                    error: function(error) {
                        console.log(error);
                    }
                });
            }

            function displaySearchResults(results) {
                
                const resultsContainer = $('#user-search-results');
                resultsContainer.empty();

                if (results.length === 0) {
                    resultsContainer.html('<div class="search-result-item">کاربری یافت نشد</div>');
                } else {
                    console.log( results.username );
                    const resultHtml = `
                        <div class="search-result-item" data-user-id="${results.id}" 
                            data-firstname="${results.firstname || ''}" 
                            data-lastname="${results.lastname || ''}" 
                            data-phone="${results.phone || ''}" >
                            <div class="user-info">${results.username}</div>
                            <div class="user-details">
                                ${results.firstname || ''} ${results.lastname || ''} - ${results.phone || ''}
                            </div>
                        </div>
                    `;
                    resultsContainer.append(resultHtml);
                }

                resultsContainer.show();
            }

            function closePopup() {
                $('#wallet-charge-popup').fadeOut(300);
                resetForm();
            }

            function resetForm() {
                selectedUserId = null;
                $('#user-search').val('');
                $('#charge-amount').val('');
                $('#user-search-results').hide();
                $('#selected-user-info').hide();
            }
        });

})( jQuery );