(function($){

    $(document).ready(function() {
        let countdownTimer;
        let countdownSeconds = confirmPhoneScript.resend_time;
        let phoneNumber = '';
        let otpVerified = false;
        let countDownTimeLeft = '';
        // Initialize OTP popup
        function initOTPPopup() {
            let tryFirst = $('#otp-code').attr('data-user');
            
            $('#otp-confirmation-popup').fadeIn(300);
            
            $('#otp-loading').show();
            $('#otp-form').hide();
            $('#otp-error').hide();
            $('#otp-success').hide();
            
            phoneNumber = $('input[name="billing_phone"]').val() || 
                         $('input[name="shipping_phone"]').val() || 
                         $('input[type="tel"]').val();
            
            if (!phoneNumber) {
                showError('شماره موبایل یافت نشد. لطفاً شماره موبایل خود را وارد کنید.');
                return;
            }

            if( tryFirst !== undefined &&  tryFirst.length )
            {
                $('#otp-loading').hide();
                $('#otp-form').fadeIn(300);
                startCountdown(countdownSeconds);
                return;
            }
            
            $.ajax({
                type:'POST', dataType:'json' , url:confirmPhoneScript.ajaxUrl,
                data:{
                    action :'send_phone_to_confirm',
                    nonce : confirmPhoneScript.nonce,
                    phoneNumber : phoneNumber,
                },
                success:function(response){

                    $('#otp-code').attr('data-user',response.user);
                    $('#otp-loading').hide();
                    $('#otp-form').fadeIn(300);

                    if( response.time_remaining )
                    {
                        return startCountdown(response.time_remaining);
                    }
                    
                    if( response.confirmed )
                    {
                        showSuccess();
                        otpVerified = true;
                        setTimeout(function() {
                            closePopup();
                            $('form.checkout').submit();
                        }, 2000);
                        return;
                    }
                   
                    startCountdown();
                },
                error:function(error){
                    showError(error.responseJSON.message)
                }
            });
        }
        
        // Start countdown timer
        function startCountdown( $time = '' ) {
            
            countdownSeconds = $time ? $time : confirmPhoneScript.resend_time;
            $('#otp-resend-btn').hide();
            $('#otp-timer').show();
            
            countdownTimer = setInterval(function() {
                countdownSeconds--;
                $('#countdown_confirm').text(countdownSeconds);
                if (countdownSeconds <= 0) {
                    clearInterval(countdownTimer);
                    $('#otp-timer').hide();
                    $('#otp-resend-btn').fadeIn(300);
                }
            }, 1000);
        }
        
        // Show error message
        function showError(message) {
            $('#otp-loading').hide();
            // $('#otp-form').hide();
            $('#otp-error').show();
            $('#error-message').text(message);
        }
        
        // Show success message
        function showSuccess() {
            $('#otp-form').hide();
            $('#otp-error').hide();
            $('#otp-success').fadeIn(300);
        }
        
        // Close popup
        function closePopup() {
            $('#otp-confirmation-popup').fadeOut(300);
            if (countdownTimer) {
                clearInterval(countdownTimer);
            }
        }
        
        // OTP Input formatting
        $('#otp-code').on('input', function() {
            let value = $(this).val().replace(/\D/g, ''); // Remove non-digits
            let numberDigits = $(this).attr('maxlength');
            $(this).val(value);
            
            // Enable submit button when 6 digits entered
            if (value.length == numberDigits) {
                $('#otp-submit-btn').prop('disabled', false);
            } else {
                $('#otp-submit-btn').prop('disabled', true);
            }
        });
        
        // Prevent non-numeric input
        $('#otp-code').on('keypress', function(e) {
            if (!/[0-9]/.test(e.key) && !['Backspace', 'Delete', 'Tab', 'Enter'].includes(e.key)) {
                e.preventDefault();
            }
        });
        
        // Auto-focus next digit (visual effect)
        $('#otp-code').on('input', function() {
            let value = $(this).val();
            if (value.length === 6) {
                $(this).blur();
            }
        });
        
        // Submit OTP form
        $('#otp-verification-form').on('submit', function(e) {
            e.preventDefault();
            
            let otpCode = $('#otp-code').val();
            let user = $('#otp-code').attr('data-user');
            let maxLength = $('#otp-code').attr('maxlength');
            
            
            if (otpCode.length != maxLength ) {
                showError( confirmPhoneScript.number_digits_error );
                return;
            }

            $('#otp-submit-btn').prop('disabled', true).text('در حال تأیید...');

            $.ajax({
                type: 'POST', dataTye : 'json', url:confirmPhoneScript.ajaxUrl,
                data:{
                    action : 'confirm_phone',
                    nonce : confirmPhoneScript.nonce,
                    user : user,
                    otpCode : otpCode
                },
                success:function(response){
                    showSuccess();
                    otpVerified = true;
                    setTimeout(function() {
                        closePopup();
                        $('form.checkout').submit();
                    }, 2000);
                },
                error: function(error){
                    $('#otp-submit-btn').prop('disabled', false).text('تأیید و پرداخت');
                    showError(error.responseJSON.message);
                    $('#otp-code').val('').focus();
                }
            });
            
        });
        
        // Resend OTP
        $('#otp-resend-btn').on('click', function() {
            $(this).prop('disabled', true).text('در حال ارسال...');
            let user = $('#otp-code').attr('data-user');
            // Simulate resending SMS
            $.ajax({
                dataTye: 'json', type : 'post' , url : confirmPhoneScript.ajaxUrl,
                data : {
                    action : 'resend_confirm_otp',
                    user : user,
                    nonce : confirmPhoneScript.nonce
                },
                success : function(response){
                    $('#otp-resend-btn').prop('disabled', false).text('ارسال مجدد کد');
                    startCountdown();
                    $('#otp-code').val('').focus();
                    $('#otp-error').hide();
                },
                error : function(error){
                    showError(error.responseJSON.message);
                }
            });
        });
        
        // Close popup events
        $('.otp-close-btn').on('click', closePopup);
        
        $(document).on('click', '.otp-popup-overlay', function(e) {
            if (e.target === this) {
                closePopup();
            }
        });
        
        // ESC key to close
        $(document).on('keydown', function(e) {
            if (e.key === 'Escape' && $('#otp-confirmation-popup').is(':visible')) {
                closePopup();
            }
        });
        
        // Expose init function globally
        window.showOTPPopup = initOTPPopup;
        // $('form.checkout').off('submit');
        // // Auto-trigger when checkout button is clicked (optional)
        // $('form.checkout').on('submit', function(e) {
        //     // Uncomment the line below to auto-trigger OTP popup
        //     e.preventDefault();
        //     initOTPPopup();
        // });
    
        $('form.checkout').on('checkout_place_order', function() {

            var cheked = false;

            if( $('#createaccount').length )
            {
                cheked = $('#createaccount').is(":checked");
            }

            if( !otpVerified && cheked )
            {
                initOTPPopup();
                return false;
            }
            
            return true;
        });
    });
})( jQuery );
