(function($){

    $(document).ready(function(){

        $('.btn_send_review').click(function(e){
            
            e.preventDefault();
            var $this = $(this);
            var $product_id = $this.data('product_id');
            var $parent = $this.parents('.feedback_page');
            var $loader = $parent.find('.lds-ring-feedback');
            

            $loader.show();

            $parent.find('.popup-overlay').addClass('show');
            $parent.find('.popup-feedback').addClass('show');

            $.ajax({
                dataType: 'json' , type : 'POST',url : feedbackDev.ajaxUrl,
                data : {
                    'action' : 'process_load_popup_review',
                    'product_id' : $product_id,
                },
                success: function(response)
                {
                    $parent.find('.product_show').html( response.template );
                    $loader.hide();
                },
                error : function( response )
                {

                }
            });
        });

        $('.feedback_page').on('submit','.product_show',function(e){
            e.preventDefault();
            var $this = $(this);
            var $parent = $this.parents('.feedback_page');
            var $button = $this.find('button.btn_feedback');
            var $nonce = $this.find('#nonce_feedback').val()
            var $rating = $('input[name="rating_feedback"]:checked').val();
            var $comment = $this.find('textarea[name="comment_feedback"]').val();
            var $product_id = $this.find('input[name="product_id"]').val();
            var $notic = $parent.find('.notic-feedback');

            var $txt_btn = $button.find('span').text();
            $button.find('span').empty();

            $button.find('.lds-ellipsis-feedback').show();

            $.ajax({
                type: 'POST', dataType:'json' , url : feedbackDev.ajaxUrl,
                data: {
                    'action' : 'product_add_feedback',
                    'nonce' : $nonce,
                    'product_id' : $product_id,
                    'rating' : $rating,
                    'comment' : $comment 
                },
                success: function(response)
                {
                    if( $notic.hasClass('feedback-error') ) $notic.removeClass('feedback-error');

                    $notic.addClass('feedback-success');
                    $notic.find('span').html( response.msg );

                    $button.find('span').text( $txt_btn );
                    $button.find('.lds-ellipsis-feedback').hide();   
                    setTimeout(() => {
                        location.reload();
                    }, 1500);                 
                },
                error: function( response )
                {
                    $notic.find('span').html( response.responseJSON.msg );

                    if( $notic.hasClass('feedback-success') ) $notic.removeClass('feedback-success');
                    $notic.addClass('feedback-error');
                    
                    $button.find('span').text( $txt_btn );
                    $button.find('.lds-ellipsis-feedback').hide();                    
                }
            });
        });

        $('.feedback-popup-close button').click( function(e){

            e.preventDefault();
            var $this = $(this);
            
            var $parent = $this.parents('.feedback_page');
            
            $parent.find('.popup-overlay').removeClass('show');
            $parent.find('.popup-feedback').removeClass('show');
            $parent.find('.product_show').empty();
            $parent.find('.notic-feedback').removeClass('feedback-error');
            $parent.find('.notic-feedback').removeClass('feedback-success');
            $parent.find('.notic-feedback span').empty();
        } )


        $(document).ready(function($) {
            $('.tab-btn').on('click', function() {
                $('.tab-btn').removeClass('active');
                $('.tab-content').removeClass('active');
                
                $(this).addClass('active');
                
                var tabId = $(this).data('tab');
                $('#' + tabId + '-tab').addClass('active');
            });
            
        });

        $(document).ready(function($) {
            $('.read-more-btn').on('click', function() {
                var commentText = $(this).siblings('.comment-text');
                
                commentText.toggleClass('expanded');
                
                if (commentText.hasClass('expanded')) {
                    $(this).addClass('less');
                    $(this).text(feedbackDev.btn_read_more.less);
                } else {
                    $(this).removeClass('less');
                    $(this).text(feedbackDev.btn_read_more.more);
                }
            });
        });
    });

})( jQuery );