(function ($) {

    $(document).ready(function () {
        
        var $html = '';

        $("#track-order").click(function () {
         
            const orderNumber = $("#order-number").val();
            const phoneNumber = $("#phone-number").val();

            if (!orderNumber || !phoneNumber) {
                alert("لطفاً شماره سفارش و شماره موبایل را وارد کنید.");
                return;
            }


            $("#tracking-loader").fadeIn(300);

            $.ajax({
                url: orderTracking.ajax_url, dataType: 'json', type: 'POST',
                data: {
                    action: 'order_tracking_front',
                    ordernumber: orderNumber,
                    phonenumber: phoneNumber,
                    nonce: orderTracking.nonce_tracking
                },
                success: function (response) {
                    if( $html )
                    {
                        $('#result-container').html( $html );
                    }

                    $("#tracking-loader").fadeOut(300);
                    showOrderDetails(response);

                },
                error: function (error) {
                    $("#tracking-loader").fadeOut(300);
                    $html = $("#result-container").html();
                    $(".order-items").hide();
                    if( error.responseJSON && error.responseJSON.template )
                    {
                        $("#result-container").html(error.responseJSON.template).fadeIn();
                    }
                }
            });

        });

        function showOrderDetails(orderData) {
            $("#order-id").text(orderData.orderId);
            $("#customer-name").text(orderData.customerName);
            $("#order-date").text(orderData.orderDate);
            $("#payment-method").text(orderData.paymentMethod);
            $("#destination-city").text(orderData.destinationCity);
            $("#shipping-method").text(orderData.shippingMethod);
            $("#total-amount").html(orderData.totalAmount);
            
            updateOrderStatus(orderData.status);

            showOrderItems(orderData.items);

            $("#result-container").fadeIn(500);

            $('html, body').animate({
                scrollTop: $("#result-container").offset().top - 20
            }, 800);
        }

        function updateOrderStatus(currentStatus) {
            
            const $statusSteps = $(".status-step");
            
            $statusSteps.removeClass("active completed");
            
            let foundStatus = false;
            
            $statusSteps.each(function (index) {
                const $step = $(this);
                const stepData = $step.attr('data-step');
                
                if (stepData !== undefined) {
                    const stepsArray = stepData.split(',').map(item => item.trim());
                    
                    if (stepsArray.includes(currentStatus)) {
                        foundStatus = true;
                        
                        $statusSteps.slice(0, index).addClass("completed");
                        
                        $step.addClass("active");
                        
                        if (index === $statusSteps.length - 1) {
                            $step.addClass("completed");
                        }
                    } else if (!foundStatus) {
                        if( index === 0 )
                        {
                            $step.addClass("active");
                        }
                        
                    }
                }
            });
            
            $statusSteps.each(function (index) {
                const $step = $(this);
                setTimeout(function () {
                    $step.addClass("animated");
                }, 200 * index);
            });
        }

        var $status_time_line = $('.status-timeline').data('status');
        updateOrderStatus($status_time_line);


        function showOrderItems(items) {
            const $conter_items = $('.order-items');
            const $container = $("#items-container");
            $container.empty();
            $conter_items.show();

            items.forEach(function (item) {
                const itemHtml = `
                    <div class="item-card">
                        <div class="item-image">
                            <img src="${item.image}" alt="${item.name}">
                        </div>
                        <div class="item-details">
                            <div class="item-name">${item.name}</div>
                            <div class="item-meta">
                                <div class="item-price">${item.price}</div>
                                <div class="item-quantity">تعداد: ${item.quantity}</div>
                            </div>
                        </div>
                    </div>
                `;

                $container.append(itemHtml);
            });

            $(".item-card").each(function (index) {
                const $card = $(this);
                setTimeout(function () {
                    $card.addClass("animated");
                }, 150 * index);
            });

        }

        $("#order-number, #phone-number").keypress(function (e) {
            if (e.which === 13) {
                $("#track-order").click();
            }
        });

        function addAnimationEffects() {
            $(".search-box").addClass("animated");
            $("header").addClass("animated");

            $(".btn-track").on("mousedown", function () {
                $(this).addClass("pulse");
                setTimeout(() => {
                    $(this).removeClass("pulse");
                }, 500);
            });
        }

        addAnimationEffects();

    });
})(jQuery);