(function($, window){

    if (typeof $ === 'undefined') {
        return;
    }

    var defaults = {
        type: 'info',
        message: '',
        duration: 4000
    };

    var containerId = 'woodmart-toast-container';
    var styleId = 'woodmart-toast-style';

    function ensureStyle() {
        if ($('#' + styleId).length) {
            return;
        }

        var styles = '' +
            '#' + containerId + '{position:fixed;bottom:28px;left:50%;transform:translateX(-50%);z-index:99999;display:flex;flex-direction:column;gap:14px;align-items:center;pointer-events:none}' +
            '.woodmart-toast{min-width:260px;max-width:420px;background:rgba(15,23,42,.92);color:#f8fafc;padding:16px 20px;border-radius:14px;box-shadow:0 18px 36px rgba(15,23,42,.28);display:flex;align-items:flex-start;gap:14px;opacity:0;transform:translateY(18px);transition:opacity .28s ease,transform .28s ease;pointer-events:auto;position:relative;font-size:14px;line-height:1.6;border:1px solid rgba(148,163,184,.15);backdrop-filter:blur(10px);-webkit-backdrop-filter:blur(10px)}' +
            '.woodmart-toast.is-visible{opacity:1;transform:translateY(0)}' +
            '.woodmart-toast__icon{width:22px;height:22px;margin-top:2px;flex-shrink:0;border-radius:50%;display:inline-flex;align-items:center;justify-content:center;font-size:12px;font-weight:600}' +
            '.woodmart-toast__content{flex:1}' +
            '.woodmart-toast__close{background:transparent;border:0;color:inherit;font-size:18px;line-height:1;cursor:pointer;opacity:.65;padding:0;margin:-2px 0 0;flex-shrink:0;transition:opacity .2s ease}' +
            '.woodmart-toast__close:hover{opacity:1}' +
            '.woodmart-toast--success{background:linear-gradient(135deg,rgba(22,101,52,.94),rgba(34,197,94,.85));color:#f0fdf4}' +
            '.woodmart-toast--success .woodmart-toast__icon{background:rgba(134,239,172,.25);color:#bbf7d0}' +
            '.woodmart-toast--error{background:linear-gradient(135deg,rgba(127,29,29,.94),rgba(248,113,113,.85));color:#fee2e2}' +
            '.woodmart-toast--error .woodmart-toast__icon{background:rgba(254,202,202,.25);color:#fee2e2}' +
            '.woodmart-toast--info{background:linear-gradient(135deg,rgba(30,64,175,.94),rgba(96,165,250,.85))}' +
            '.woodmart-toast--info .woodmart-toast__icon{background:rgba(191,219,254,.25);color:#eff6ff}' +
            '.woodmart-toast a{color:#e0f2fe;text-decoration:underline;font-weight:500}' +
            '@media(max-width:640px){#' + containerId + '{left:50%;right:auto;bottom:16px;width:calc(100% - 32px)} .woodmart-toast{min-width:auto;max-width:100%;width:100%;transform:translateY(18px)}.woodmart-toast.is-visible{transform:translateY(0)}}';

        $('head').append('<style id="'+styleId+'">'+styles+'</style>');
    }

    function ensureContainer() {
        var $container = $('#' + containerId);

        if (!$container.length) {
            $container = $('<div>', {
                id: containerId,
                'aria-live': 'polite',
                'aria-atomic': 'true'
            });
            $('body').append($container);
        }

        return $container;
    }

    function removeToast($toast) {
        if (!$toast || !$toast.length) {
            return;
        }

        $toast.removeClass('is-visible');

        setTimeout(function(){
            $toast.remove();
        }, 250);
    }

    function buildToast(settings) {
        var typeClass = 'woodmart-toast--' + settings.type;
        var iconChar = {
            success: '✓',
            error: '!',
            info: 'i'
        }[settings.type] || 'i';

        var $toast = $('<div>', {
            'class': 'woodmart-toast ' + typeClass,
            'role': 'status'
        });

        var $icon = $('<span>', {
            'class': 'woodmart-toast__icon',
            'text': iconChar
        });

        var $content = $('<div>', {
            'class': 'woodmart-toast__content'
        }).html(settings.message);

        var $close = $('<button>', {
            'class': 'woodmart-toast__close',
            'type': 'button',
            'aria-label': 'Close notification',
            'html': '&times;'
        });

        $close.on('click', function(){
            removeToast($toast);
        });

        $toast.append($icon, $content, $close);

        setTimeout(function(){
            $toast.addClass('is-visible');
        }, 20);

        if (settings.duration && settings.duration > 0) {
            setTimeout(function(){
                removeToast($toast);
            }, settings.duration);
        }

        return $toast;
    }

    var Toast = {
        show: function(options) {
            var settings = $.extend({}, defaults, options || {});

            if (!settings.message) {
                return null;
            }

            ensureStyle();

            var $container = ensureContainer();
            var $toast = buildToast(settings);

            $container.append($toast);

            return $toast;
        },
        hide: function($toast) {
            removeToast($toast);
        }
    };

    window.WoodmartToast = Toast;

})(window.jQuery, window);

