(function($){

    $(document).ready(function(){

        $(document).on('click','.subscribe_waitlist',function(e){
            
            e.preventDefault();

            if ( ! $('#waitlist-inline-style').length ) {
                $('head').append('<style id="waitlist-inline-style">.subscribe_waitlist.waitlist-loading{position:relative;padding-right:42px;pointer-events:none;opacity:.7}.subscribe_waitlist.waitlist-loading .waitlist-loader{position:absolute;top:50%;right:16px;width:18px;height:18px;margin-top:-9px;border:2px solid rgba(255,255,255,.6);border-top-color:#fff;border-radius:50%;animation:waitlist-spin .8s linear infinite}@keyframes waitlist-spin{to{transform:rotate(360deg)}}</style>');
            }

            var $this = $(this);

            if ( ! $this.hasClass('waitlist-loading') ) {
                $this.addClass('waitlist-loading');
                if ( $this.find('.waitlist-loader').length === 0 ) {
                    $this.append('<span class="waitlist-loader"></span>');
                }
            }

            var product_id = $this.data('product_id');
            var variation_id = $this.attr('variation_id');

            $.ajax({
                type : 'post' , dataType : 'json' , url : waitlistObject.ajaxUrl,
                data :{
                    action : 'subscribe_waitlist',
                    product_id : product_id,
                    variation_id : variation_id,
                    nonce : waitlistObject.nonce
                },
                success:function(response){
                    
                    WoodmartToast.show({
                        type: 'success',
                        message: response.msg,
                        duration: 6000
                    });
                },
                error : function(error){
                    if (window.WoodmartToast) {
                        
                        WoodmartToast.show({
                            type: 'error',
                            message: error.responseJSON.msg,
                            duration: 6000
                        });
                    }
                },
                complete:function(){
                    $this.removeClass('waitlist-loading');
                    $this.find('.waitlist-loader').remove();
                }
            });
    });

    $(document).ready(function() {
        $('.variations_form').on('show_variation', function(event, variation) {
                var product_id = $(this).data('product_id') || $(this).find('input[name="product_id"]').val();
            
            if (!variation.is_in_stock) {

                if ($('.subscribe_waitlist').length === 0) {
                    $('.single_variation_wrap').append('<button class="button alt subscribe_waitlist" data-product_id="'+product_id+'" variation_id="'+variation.variation_id+'" style="margin-top:30px">'+waitlistObject.btn_title+'</button>');
                }else {
                    $('.subscribe_waitlist').remove();
                    $('.single_variation_wrap').append('<button class="button alt subscribe_waitlist" data-product_id="'+product_id+'" variation_id="'+variation.variation_id+'" style="margin-top:30px">'+waitlistObject.btn_title+'</button>');
                }
            }else{
                $('.subscribe_waitlist').remove();
            }
        });
    });

     $(document).ready(function() {
        // Initialize waitlist functionality
        var WaitlistTable = {
            init: function() {
                this.bindEvents();
            },

            bindEvents: function() {
                var self = this;

                // Remove item from waitlist
                $(document).on('click', '.btn-remove', function(e) {
                    e.preventDefault();
                    
                    var $btn = $(this);
                    var itemId = $btn.data('item-id');
                    var nonce = $btn.data('nonce');

                    if (!itemId) {
                        console.error('Item ID not found');
                        return;
                    }

                    self.removeItem($btn, itemId, nonce);
                });
            },

            removeItem: function($btn, itemId, nonce) {
                var self = this;
                var $row = $btn.closest('.waitlist-row');
                var $overlay = $('#waitlist-loader-overlay');

                // Show loader on button
                $btn.addClass('loading');

                // Show overlay loader
                $overlay.fadeIn(200);

                // AJAX request
                $.ajax({
                    type: 'POST',
                    url: typeof waitlistObject !== 'undefined' ? waitlistObject.ajaxUrl : ajaxurl || '/wp-admin/admin-ajax.php',
                    dataType: 'json',
                    data: {
                        action: 'remove_waitlist_item',
                        item_id: itemId,
                        nonce: waitlistObject.nonce 
                    },
                    success: function(response) {
                        // Remove row with animation
                        $row.fadeOut(300, function() {
                            $(this).remove();
                            
                            // Check if table is empty
                            var $tbody = $('#waitlist-tbody');
                            if ($tbody.find('.waitlist-row').length === 0) {
                                $('#waitlist-table').hide();
                                $('#waitlist-empty').fadeIn(300);
                            }

                            // Show success message
                            if (typeof WoodmartToast !== 'undefined') {
                                WoodmartToast.show({
                                    type: 'success',
                                    message: response.msg ,
                                    duration: 4000
                                });
                            } else {
                                alert(response.msg || 'محصول با موفقیت از لیست انتظار حذف شد');
                            }
                        });
                    },
                    error: function(xhr) {
                        var errorMsg = 'خطایی در حذف محصول رخ داد. لطفا مجددا تلاش کنید.';
                        
                        if (xhr.responseJSON && xhr.responseJSON.msg) {
                            errorMsg = xhr.responseJSON.msg;
                        }

                        // Show error message
                        if (typeof WoodmartToast !== 'undefined') {
                            WoodmartToast.show({
                                type: 'error',
                                message: errorMsg,
                                duration: 6000
                            });
                        } else {
                            alert(errorMsg);
                        }

                        // Remove loading state
                        $btn.removeClass('loading');
                        $overlay.fadeOut(200);
                    },
                    complete: function() {
                        // Remove loading state
                        $btn.removeClass('loading');
                        $overlay.fadeOut(200);
                    }
                });
            }
        };

        // Initialize waitlist table
        WaitlistTable.init();

        // Check if table is empty on load
        var $tbody = $('#waitlist-tbody');
        if ($tbody.find('.waitlist-row').length === 0) {
            $('#waitlist-table').hide();
            $('#waitlist-empty').show();
        }
    });
    });
})(jQuery);