<?php
add_action( 'product_cat_add_form_fields', 'woodapp_wc_api_taxonomy_add_new_meta_field', 40, 2 );
add_action( 'product_cat_edit_form_fields', 'woodapp_wc_api_taxonomy_edit_new_meta_field',40,2 );

add_action( 'create_product_cat', 'save_custom_tax_field' );
add_action( 'edited_product_cat', 'save_custom_tax_field' );

// Add term page
function woodapp_wc_api_taxonomy_add_new_meta_field($term) {
	// this will add the custom meta field to the add new term page
    $vsrc = array();$app_cat='';
    if(isset($term->term_id) && !empty($term->term_id)){
        $termID = $term->term_id;
    	$app_cat = $termMeta['product_app_cat_thumbnail_id'];
        $vsrc = wp_get_attachment_image_src($app_cat, 'thumbnail' );

    }
    ob_start();
    ?>
	<div class="form-field term-thumbnail-wrap">
        <label><?php esc_html_e('تصویر کوچک دسته برنامه','woodapp-api')?></label>
        <div id="product_app_cat_thumbnail" class="upload_image" style="float: left; margin-right: 10px;">
            <?php
            $display = "none;";
            if(!empty($vsrc)){
                $display = "inline-block;";
                ?>
                <img src="<?php echo esc_url($vsrc[0])?>" width="60px" height="60px">
            <?php
            }else{?>
                <img src="<?php echo WOODAPP_API_URL.'/img/woodapp_app_cat_placeholder.jpg'?>" width="60px" height="60px">
            <?php }
            ?>
        </div>
        <div style="line-height: 60px;">

            <input type="hidden" id="product_app_cat_thumbnail_id" class="upload_image_id" name="product_app_cat_thumbnail_id" value="<?php echo esc_attr($app_cat)?>">
        	<button type="button" id="upload-image-button" class="upload_app_image_button button"><?php esc_html_e('آپلود/افزودن تصویر دسته بندی برنامه','woodapp-api')?></button>
        	<button type="button" id="remove-image-button" class="remove_app_image_button button" style="display: <?php echo esc_attr($display);?>;"><?php esc_html_e('حذف تصویر','woodapp-api')?></button>
        </div>
        <div class="clear"></div>
        <p class="description"><?php _e( 'تصویر نماد دسته برنامه تلفن همراه را اضافه کنید','woodapp-api' ); ?></p>
    </div>
    <?php
    $output = ob_get_contents();
    ob_end_clean();
    echo $output;

}


function woodapp_wc_api_taxonomy_edit_new_meta_field($term) {

    // this will add the custom meta field to the add new term page
    $vsrc = array();
    if(isset($term->term_id) && !empty($term->term_id)){
        $termID = $term->term_id;
    	$product_app_cat_thumbnail_id = get_term_meta($termID, 'product_app_cat_thumbnail_id', true);
        $vsrc = wp_get_attachment_image_src($product_app_cat_thumbnail_id, 'thumbnail' );
    }
    ob_start();
    ?>
	<tr class="form-field">
    	<th scope="row" valign="top"><label><?php esc_html_e('تصویر کوچک دسته برنامه','woodapp-api')?></label></th>
    	<td>
    		<div class="upload_image" id="product_app_cat_thumbnail" style="float: left; margin-right: 10px;">
                <?php
                $display = "none;";
                if(!empty($vsrc)){
                    $display = "inline-block;";
                    ?>
                    <img src="<?php echo esc_url($vsrc[0])?>" width="60px" height="60px">
                <?php
                }else{?>
                    <img src="<?php echo WOODAPP_API_URL.'/img/woodapp_app_cat_placeholder.jpg'?>" width="60px" height="60px">
                <?php }
                ?>
    		</div>
            <div style="line-height: 60px;">
    			<input type="hidden" id="product_app_cat_thumbnail_id" class="upload_image_id" name="product_app_cat_thumbnail_id" value="<?php echo esc_attr($product_app_cat_thumbnail_id)?>">
    			<button type="button" id="upload-image-button" class="upload_app_image_button button"><?php esc_html_e('آپلود/افزودن تصویر دسته بندی برنامه','woodapp-api')?></button>
    			<button type="button" id="remove-image-button" class="remove_app_image_button button" style="display: <?php echo esc_attr($display);?>"><?php esc_html_e('حذف تصویر','woodapp-api')?></button>
    		</div>
    	    <p class="description"><?php esc_html_e( 'تصویر دسته برنامه موبایل را اضافه کنید','woodapp-api' ); ?></p>
    		<div class="clear"></div>
    	</td>
    </tr>
    <?php
    $output = ob_get_contents();
    ob_end_clean();
    echo $output;

}

function save_custom_tax_field( $termID ) {
    if ( isset( $_POST['product_app_cat_thumbnail_id'] ) ) {
		$product_app_cat_thumbnail_id = isset( $_POST['product_app_cat_thumbnail_id'] ) ? $_POST['product_app_cat_thumbnail_id'] : '';
        update_term_meta($termID, 'product_app_cat_thumbnail_id', $product_app_cat_thumbnail_id);
	}
}



/* ---------------------------------------------------------------------------
 * Edit columns
 * --------------------------------------------------------------------------- */
function woodapp_wc_api_product_cat_edit_columns($columns)
{
	$newcolumns = array(
		"cb" => "<input type='checkbox' />",
		"app_image" => esc_html__( 'تصویر اپلیکیشن', 'woodapp-api' ),
	);
	$columns = array_merge($newcolumns, $columns);

	return $columns;
}
add_filter("manage_edit-product_cat_columns", "woodapp_wc_api_product_cat_edit_columns",10,1);
/* ---------------------------------------------------------------------------
 * Custom columns
 * --------------------------------------------------------------------------- */
function woodapp_wc_api_product_cat_add_columns($content, $column_name, $term_id) {

    $vsrc = array();
    if($column_name == "app_image"){
        if(isset($term_id) && !empty($term_id)){
            $termID = $term_id;
        	$product_app_cat_thumbnail_id = get_term_meta($termID, 'product_app_cat_thumbnail_id', true);
            $vsrc = wp_get_attachment_image_src($product_app_cat_thumbnail_id, 'thumbnail' );

            if(!empty($vsrc)){
                $img = '<img src="'.esc_url($vsrc[0]).'" width="40px" height="40px">';

            }else{
                $img = '<img src="'.WOODAPP_API_URL.'/img/woodapp_app_cat_placeholder.jpg" width="40px" height="40px">';
            }
            return $img;
        }
    }
}
add_filter( 'manage_product_cat_custom_column', 'woodapp_wc_api_product_cat_add_columns', 10, 3 );

add_action( 'product_cat_edit_form_fields', 'woodapp_wc_api_add_excerpt_for_mobile_menu_category',40,2 );
function woodapp_wc_api_add_excerpt_for_mobile_menu_category($term)
{
    $category_excerpt = get_term_meta($term->term_id,'excerpt_category_mobile_app',true) ? get_term_meta($term->term_id,'excerpt_category_mobile_app',true) : '';
    
    ob_start();
    ?>
	<tr class="form-field">
    	<th scope="row" valign="top"><label>متن دسته بندی اپلیکیشن موبایل</label></th>
    	<td>
    		<div class="excerpt_category_mobile">
                <p>
                    <textarea name="excerpt_category_mobile_app" id="" cols="30" rows="5" placeholder="متن خود را بنویسید"><?php echo $category_excerpt ?></textarea>
                </p>
            </div>
    	</td>
    </tr>
    <?php
    $output = ob_get_contents();
    ob_end_clean();
    echo $output;
}

add_action( 'edited_product_cat', 'save_custome_text_category_mobile' );
function save_custome_text_category_mobile($termID)
{
   
    if ( isset( $_POST['excerpt_category_mobile_app'] ) ) {
		$excerpt_category_mobile_app = isset( $_POST['excerpt_category_mobile_app'] ) ? $_POST['excerpt_category_mobile_app'] : '';
        update_term_meta($termID, 'excerpt_category_mobile_app', $excerpt_category_mobile_app);
	}
}

function add_thumbnail_for_category_post($term){
    wp_enqueue_media();
    $vsrc = array();
    if(isset($term->term_id) && !empty($term->term_id)){
        $termID = $term->term_id;

    	$post_app_cat_thumbnail_id = get_term_meta($termID, 'post_app_cat_thumbnail_id', true);

        $vsrc = wp_get_attachment_image_src($post_app_cat_thumbnail_id, 'thumbnail' );
    }
    ob_start();
    ?>
	<tr class="form-field">
    	<th scope="row" valign="top"><label><?php esc_html_e('تصویر کوچک دسته بندی پست برنامه','woodapp-api')?></label></th>
    	<td>
    		<div class="upload_image" id="product_app_cat_thumbnail" style="float: left; margin-right: 10px;">
                <?php
                $display = "none;";
                if(!empty($vsrc)){
                    $display = "inline-block;";
                    ?>
                    <img src="<?php echo esc_url($vsrc[0])?>" width="60px" height="60px">
                <?php
                }else{?>
                    <img src="<?php echo WOODAPP_API_URL.'/img/woodapp_app_cat_placeholder.jpg'?>" width="60px" height="60px">
                <?php }
                ?>
    		</div>
            <div style="line-height: 60px;">
    			<input type="hidden" id="post_app_cat_thumbnail_id" class="upload_image_id" name="post_app_cat_thumbnail_id" value="<?php echo esc_attr($post_app_cat_thumbnail_id)?>">
    			<button type="button" id="upload-image-button" class="upload_app_image_button button"><?php esc_html_e('آپلود تصویر دسته بندی اپلیکیشن','woodapp-api')?></button>
    			<button type="button" id="remove-image-button" class="remove_app_image_button button" style="display: <?php echo esc_attr($display);?>"><?php esc_html_e('Remove image','woodapp-api')?></button>
    		</div>
    	    <p class="description"><?php esc_html_e( 'تصویر دسته پست برنامه تلفن همراه را اضافه کنید','woodapp-api' ); ?></p>
    		<div class="clear"></div>
    	</td>
    </tr>
    <?php
    $output = ob_get_contents();
    ob_end_clean();
    echo $output;
    wp_enqueue_script( 'woodapp-wc-api-js' );

}

function save_category_thumbnail_post($termID) {

    if ( isset( $_POST['post_app_cat_thumbnail_id'] ) ) {
        update_term_meta($termID,'post_app_cat_thumbnail_id',$_POST['post_app_cat_thumbnail_id']);
    }
}

function add_excerpt_for_category_post($term)
{
    if(isset($term))
    {
        $term_id = $term->term_id;
        $excerpt = get_term_meta( $term_id,'post_app_cat_textexcerpt',true ) ? get_term_meta( $term_id,'post_app_cat_textexcerpt',true ) : '';
    }
    ob_start();
    ?>
    <tr class="form-field">
    	<th scope="row" valign="top"><label>متن دسته بندی پست های اپلیکیشن موبایل</label></th>
    	<td>
            <div class="excerpt_category_mobile">
                <p>
                    <textarea name="post_app_cat_textexcerpt"  cols="30" rows="5" placeholder="متن خود را وارد کنید"><?php echo $excerpt ?></textarea>
                </p>
            </div>
        </td>
    </tr>        
    <?php
    $output = ob_get_contents();
    ob_end_clean();
    echo $output;
}

function save_category_excerpt_post($termID)
{
    if(isset($_POST['post_app_cat_textexcerpt']) && !empty($_POST['post_app_cat_textexcerpt']))
    {
        $value = sanitize_text_field( $_POST['post_app_cat_textexcerpt'] );
        update_term_meta($termID, 'post_app_cat_textexcerpt',$value);
    }
}
// {$taxonomy}_edit_form_fields
add_action ( 'category_edit_form_fields', 'add_thumbnail_for_category_post');
add_action ( 'category_edit_form_fields', 'add_excerpt_for_category_post');
add_action ( 'edited_category', 'save_category_thumbnail_post');
add_action ( 'edited_category', 'save_category_excerpt_post');