<?php $setting_status = woodplus_wc_api::get_app_setting('story_status'); ?>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('سیستم استوری','woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('فعال کردن سیستم استوری','woodmartplus') ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo woodplus_wc_api::generate_option_app('[story_status]'); ?>"  <?php echo isset( $setting_status ) && !empty( $setting_status ) ? 'checked' : '' ?> >
   </div>
</div>

<div >
    <h1><?php echo esc_html__('مدیریت استوری‌ها', 'woodmartplus'); ?></h1>
        
        <div class="stories-admin-container">
            <!-- دکمه افزودن استوری جدید -->
            <div class="add-story-section">
                <button type="button" id="add-new-story" class="button button-primary">
                    <span class="dashicons dashicons-plus-alt"></span>
                    <?php echo esc_html__('افزودن استوری جدید', 'woodmartplus'); ?>
                </button>
            </div>

            <!-- لیست استوری‌ها -->
            <div id="stories-list" class="stories-list">
                <!-- استوری‌ها اینجا نمایش داده می‌شوند -->
            </div>
        
        </div>
</div>

<!-- قالب استوری -->
<script type="text/template" id="story-template">
    <div class="story-item" data-story-id="{{storyId}}">
        <div class="story-header">
            <h3 class="story-title">
                <span class="dashicons dashicons-format-image"></span>
                استوری #{{storyId}}
            </h3>
            <div class="story-actions">
                <button type="button" class="button add-subitem-btn" data-story-id="{{storyId}}">
                    <span class="dashicons dashicons-plus"></span>
                    افزودن زیرمجموعه
                </button>
                <button type="button" class="button button-secondary remove-story-btn" data-story-id="{{storyId}}">
                    <span class="dashicons dashicons-trash"></span>
                    حذف استوری
                </button>
            </div>
        </div>
        
        <div class="story-content">
            <!-- عنوان استوری -->
            <div class="story-title-field">
                <label><?php echo esc_html__('عنوان استوری:', 'woodmartplus'); ?></label>
                <input type="text" name="<?php echo woodplus_wc_api::generate_option_app('[stories][{{storyId}}][story_title]') ?>" value="{{storyTitle}}" class="story-title-input" placeholder="<?php echo esc_attr__('عنوان استوری را وارد کنید...', 'woodmartplus'); ?>">
            </div>

            <!-- تصویر اصلی استوری -->
            <div class="story-main-image">
                <label><?php echo esc_html__('تصویر اصلی استوری:', 'woodmartplus'); ?></label>
                <div class="image-upload-container">
                    <div class="image-preview">
                        <img src="{{mainImageUrl}}" alt="تصویر اصلی" style="display: {{mainImageDisplay}};">
                        <div class="no-image-placeholder" style="display: {{noImageDisplay}};">
                            <span class="dashicons dashicons-format-image"></span>
                            <p><?php echo esc_html__('تصویری انتخاب نشده', 'woodmartplus'); ?></p>
                        </div>
                    </div>
                    <div class="image-upload-actions">
                        <button type="button" class="button upload-image-btn" data-story-id="{{storyId}}" data-type="main">
                            <?php echo esc_html__('انتخاب تصویر', 'woodmartplus'); ?>
                        </button>
                        <button type="button" class="button remove-image-btn" data-story-id="{{storyId}}" data-type="main" style="display: {{removeBtnDisplay}};">
                            <?php echo esc_html__('حذف تصویر', 'woodmartplus'); ?>
                        </button>
                    </div>
                    <input type="hidden" name="<?php echo woodplus_wc_api::generate_option_app('[stories][{{storyId}}][story_main_image]') ?>" value="{{mainImageId}}" class="main-image-input">
                    <input type="hidden" name="<?php echo woodplus_wc_api::generate_option_app('[stories][{{storyId}}][story_id]') ?>" value="{{storyUnqieId}}">
                </div>
            </div>

            <!-- زیرمجموعه‌های استوری -->
            <div class="story-subitems">
                <h4><?php echo esc_html__('زیرمجموعه‌های استوری:', 'woodmartplus'); ?></h4>
                <div class="subitems-list" data-story-id="{{storyId}}">
                    <!-- زیرمجموعه‌ها اینجا نمایش داده می‌شوند -->
                </div>
            </div>
        </div>
    </div>
</script>

<!-- قالب زیرمجموعه -->
<script type="text/template" id="subitem-template">
    <div class="subitem-item" data-subitem-id="{{subitemId}}">
        <div class="subitem-header">
            <h5>زیرمجموعه #{{subitemId}}</h5>
            <button type="button" class="button button-secondary remove-subitem-btn" data-subitem-id="{{subitemId}}">
                <span class="dashicons dashicons-trash"></span>
                حذف
            </button>
        </div>
        
        <div class="subitem-content">
            <!-- آپلود تصویر زیرمجموعه -->
            <div class="subitem-image">
                <label><?php echo esc_html__('تصویر زیرمجموعه:', 'woodmartplus'); ?></label>
                <div class="image-upload-container">
                    <div class="image-preview">
                        <img src="{{subitemImageUrl}}" alt="تصویر زیرمجموعه" style="display: {{subitemImageDisplay}};">
                        <div class="no-image-placeholder" style="display: {{subitemNoImageDisplay}};">
                            <span class="dashicons dashicons-format-image"></span>
                            <p><?php echo esc_html__('تصویری انتخاب نشده', 'woodmartplus'); ?></p>
                        </div>
                    </div>
                    <div class="image-upload-actions">
                        <button type="button" class="button upload-image-btn" data-subitem-id="{{subitemId}}" data-type="subitem">
                            <?php echo esc_html__('انتخاب تصویر', 'woodmartplus'); ?>
                        </button>
                        <button type="button" class="button remove-image-btn" data-subitem-id="{{subitemId}}" data-type="subitem" style="display: {{subitemRemoveBtnDisplay}};">
                            <?php echo esc_html__('حذف تصویر', 'woodmartplus'); ?>
                        </button>
                    </div>
                    <input type="hidden" name="<?php echo woodplus_wc_api::generate_option_app('[stories][{{storyId}}][subitems][{{subitemId}}][subitem_image]') ?>" value="{{subitemImageId}}" class="subitem-image-input">
                </div>
            </div>
            <div class="subitem-title">
                <div class="story-title-field">
                    <label><?php echo esc_html__('عنوان زیرمجموعه:', 'woodmartplus'); ?></label>
                    <input type="text" name="<?php echo woodplus_wc_api::generate_option_app('[stories][{{storyId}}][subitems][{{subitemId}}][story_subtitle]') ?>" value="{{storySubTitle}}" class="story-title-input" placeholder="<?php echo esc_attr__('عنوان زیرمجموعه را وارد کنید...', 'woodmartplus'); ?>">
                </div>
            </div>
            <!-- تنظیمات لینک -->
            <div class="subitem-link-settings">
                <label><?php echo esc_html__('نوع لینک:', 'woodmartplus'); ?></label>
                <select name="<?php echo woodplus_wc_api::generate_option_app('[stories][{{storyId}}][subitems][{{subitemId}}][link_type]') ?>" class="link-type-select" data-subitem-id="{{subitemId}}">
                    <option value=""><?php echo esc_html__('انتخاب کنید...', 'woodmartplus'); ?></option>
                    <option value="product"><?php echo esc_html__('محصول', 'woodmartplus'); ?></option>
                    <option value="category"><?php echo esc_html__('دسته‌بندی', 'woodmartplus'); ?></option>
                </select>

                <!-- انتخاب محصول -->
                <div class="product-selection" data-subitem-id="{{subitemId}}" style="display: none;">
                    <label><?php echo esc_html__('انتخاب محصول:', 'woodmartplus'); ?></label>
                    <select name="<?php echo woodplus_wc_api::generate_option_app('[stories][{{storyId}}][subitems][{{subitemId}}][product_id]') ?>" class="product-select2" data-subitem-id="{{subitemId}}">
                        <option value=""><?php echo esc_html__('جستجو و انتخاب محصول...', 'woodmartplus'); ?></option>
                    </select>
                </div>

                <!-- انتخاب دسته‌بندی -->
                <div class="category-selection" data-subitem-id="{{subitemId}}" style="display: none;">
                    <label><?php echo esc_html__('انتخاب دسته‌بندی:', 'woodmartplus'); ?></label>
                    <select name="<?php echo woodplus_wc_api::generate_option_app('[stories][{{storyId}}][subitems][{{subitemId}}][category_id]') ?>" class="category-select2" data-subitem-id="{{subitemId}}">
                        <option value=""><?php echo esc_html__('جستجو و انتخاب دسته‌بندی...', 'woodmartplus'); ?></option>
                    </select>
                </div>
            </div>
        </div>
    </div>
</script>


