<?php
    if( !defined('ABSPATH') ) exit;

    $first_description = wplus_helper::get_setting('ai_chatbot_description','');
?>
<div class="chat-bot-toggle" id="chatBotToggle" aria-label="<?php esc_html_e('باز کردن چت','woodmartplus') ?>">
    <svg class="chat-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M20 2H4C2.9 2 2 2.9 2 4V22L6 18H20C21.1 18 22 17.1 22 16V4C22 2.9 21.1 2 20 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        <path d="M7 9H17M7 13H13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
    </svg>
    <svg class="close-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
</div>

<div class="chat-bot-container" id="chatBotContainer">
    <div class="chat-bot-header">
        <div class="chat-bot-header-content">
            <div class="chat-bot-avatar">
                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M20 21V19C20 17.9391 19.5786 16.9217 18.8284 16.1716C18.0783 15.4214 17.0609 15 16 15H8C6.93913 15 5.92172 15.4214 5.17157 16.1716C4.42143 16.9217 4 17.9391 4 19V21" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <circle cx="12" cy="7" r="4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>
            <div class="chat-bot-header-info">
                <h3 class="chat-bot-title"><?php echo wplus_helper::get_setting('ai_chatbot_title','پشتیبانی آنلاین') ?></h3>
                <span class="chat-bot-status">
                    <span class="status-dot"></span>
                    <?php esc_html_e('آنلاین','woodmartplus'); ?>
                </span>
            </div>
        </div>
        <div class="chat-bot-reset-btn" id="chatBotReset"  aria-label="<?php esc_html_e('شروع گفتگوی جدید','woodamrtplus'); ?>">
            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M2 12C2 6.47715 6.47715 2 12 2C15.3137 2 18.3137 3.53043 20.2981 6H17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M22 12C22 17.5228 17.5228 22 12 22C8.68629 22 5.68629 20.4696 3.70199 18H7" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        </div>
    </div>

    <?php if( $first_description ): ?>
    <div class="chat-bot-messages" id="chatBotMessages">
        <div class="message bot-message chat-initial-message">
            <div class="message-content">
                <div class="message-text">
                    <?php echo $first_description; ?>
                </div>
            </div>
            <div class="message-footer">
                <div class="message-footer-left">
                    <div class="message-avatar">
                        <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M20 21V19C20 17.9391 19.5786 16.9217 18.8284 16.1716C18.0783 15.4214 17.0609 15 16 15H8C6.93913 15 5.92172 15.4214 5.17157 16.1716C4.42143 16.9217 4 17.9391 4 19V21" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <circle cx="12" cy="7" r="4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <span class="message-sender"><?php echo wplus_helper::get_setting('ai_chatbot_name','دستیار سایت'); ?></span>
                    <span class="message-time-header"><?php esc_html_e('همین الان','woodmartplus'); ?></span>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if( !empty( $questions ) ): ?>
    <div class="chat-bot-quick-questions" id="chatBotQuickQuestions">
        <div class="quick-questions-scroll">
            <?php foreach( $questions as $question ):?>
                <div class="quick-question-btn">
                    <?php echo esc_html( $question ); ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>

    <div class="chat-bot-input-container">
        <div class="chat-bot-input-wrapper">
            <textarea
                class="chat-bot-input"
                id="chatBotInput"
                placeholder="<?php echo wplus_helper::get_setting('ai_chatbot_input','پیام خود را بنویسید...'); ?>"
                autocomplete="off"
                rows="1"
                style="border:unset;padding: 6px;"
            ></textarea>
            <div class="chat-bot-send" id="chatBotSend" aria-label="<?php esc_html_e('ارسال پیام','woodmartplus'); ?>">
                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M22 2L11 13M22 2L15 22L11 13M22 2L2 9L11 13" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>
        </div>
    </div>
</div>