<?php
if( !defined('ABSPATH') ) exit;

?>

<div class="chatbot-rag-settings-wrapper">
    <?php Chatbot_Notice_Ai::get_instance()->show_response(); ?>

    <div class="rag-explanation">
        <div class="rag-explanation-header">
            <h4><?php esc_html_e('RAG چیست؟','woodmartplus'); ?></h4>
        </div>
        <div class="rag-explanation-content">
            <p>
                <?php esc_html_e('                RAG (Retrieval-Augmented Generation) تکنیکی است که به هوش مصنوعی امکان می‌دهد 
                از اطلاعات موجود در دیتابیس شما برای تولید پاسخ‌های دقیق‌تر و مرتبط‌تر استفاده کند.','woodmartplus'); ?>
            </p>
            <div class="rag-benefits">
                <span class="rag-benefit"><?php esc_html_e('پاسخ‌های دقیق‌تر','woodmartplus'); ?></span>
                <span class="rag-benefit"><?php esc_html_e('اطلاعات به‌روز','woodmartplus'); ?></span>
                <span class="rag-benefit"><?php esc_html_e('کاهش خطا','woodmartplus'); ?></span>
            </div>
        </div>
    </div>

    <div class="rag-info-box">
        <div class="rag-info-header">
            <div class="rag-info-icon">
                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="currentColor" stroke-width="2"/>
                    <path d="M12 16V12" stroke="currentColor" stroke-width="2"/>
                    <path d="M12 8H12.01" stroke="currentColor" stroke-width="2"/>
                </svg>
            </div>
            <h3><?php esc_html_e('راهنمای شروع فرآیند RAG','woodmartplus') ?></h3>
        </div>
        
        <div class="rag-info-content">

            <div class="rag-info-item">
                <div class="rag-info-number">1</div>
                <div class="rag-info-text">
                    <?php esc_html_e('زمان ایجاد RAG بسته به اطلاعات دیتابیس شما ممکن است زمان بر باشد','woodmartplus') ?>
                </div>
            </div>
            
            <div class="rag-info-item">
                <div class="rag-info-number">2</div>
                <div class="rag-info-text">
                    <?php esc_html_e('این موضوع باعث افزایش حجم دیتابیس شما میشود ، پس در انتخاب پست تایپ دقت کنید و پست تایپ های مهم که تاثییر بسازیی در پاسخگویی دارد را انتخاب کنید','woodmartplus') ?>
                </div>
            </div>
            
           <div class="rag-info-item">
                <div class="rag-info-number">3</div>
                <div class="rag-info-text">
                    <?php esc_html_e('بعد از انجام پروسه دریافت رگ شما میتوانید مجددا از این قسمت اقدام به گرفتن رگ برای موارد جدید کنید ، اما برای بروزرسانی موارد قبلی از قسمت جزئیات هر پست تایپ اقدام کنید','woodmartplus') ?>
                </div>
            </div>

            <div class="rag-info-item">
                <div class="rag-info-number">4</div>
                <div class="rag-info-text">
                    <?php esc_html_e('API هوش مصنوعی به علت رایگان بودن ممکن است با مشکل مواجه شود.','woodmartplus') ?>
                </div>
            </div>
            
        </div>
    </div>
    <?php if( $is_work ): ?>
    <div class="rag-cron-notice">
        <div class="rag-cron-pulse"></div>
        <div class="rag-cron-content">
            <svg class="rag-cron-spinner" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 2V6M12 18V22M4.93 4.93L7.76 7.76M16.24 16.24L19.07 19.07M2 12H6M18 12H22M4.93 19.07L7.76 16.24M16.24 7.76L19.07 4.93" stroke="currentColor" stroke-width="2"/>
            </svg>
            <div class="rag-cron-text">
                <strong><?php esc_html_e('Cron Job در حال اجرا است','woodmartplus'); ?></strong>
                <span><?php esc_html_e('فرآیند RAG در حال پردازش می‌باشد','woodmartplus'); ?></span>
            </div>
        </div>
    </div>
    <div class="rag-no-logs-section">
        <div class="rag-no-logs-content">
            <div class="rag-no-logs-icon">
                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="2"/>
                </svg>
            </div>
            <h3><?php esc_html_e('در انتظار ثبت لاگ‌ها','woodmartplus') ?></h3>
            <p><?php esc_html_e('فرآیند RAG شروع شده است. لاگ‌ها و نتایج به زودی نمایش داده خواهند شد.','woodmartplus') ?></p>
            <div class="rag-no-logs-progress">
                <div class="rag-progress-bar">
                    <div class="rag-progress-fill" id="ragProgressFill"></div>
                </div>
                <div class="rag-progress-text"><?php esc_html_e('در حال راه‌اندازی...','woodmartplus'); ?></div>
            </div>
        </div>
    </div>

    <?php else: ?>

    <div class="rag-minimal-form">
        <div class="rag-form-header">
            <div class="rag-form-icon">
                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2"/>
                    <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2"/>
                    <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2"/>
                </svg>
            </div>
            <h2><?php esc_html_e('شروع فرآیند RAG','woodmartplus') ?></h2>
            <p><?php esc_html_e('پست تایپ‌های مورد نظر برای پردازش را انتخاب کنید','woodmartplus'); ?></p>
        </div>

        <form id="form_start_rag" method="POST">
            <div class="rag-post-types-grid">

                <?php foreach ($available_post_types as $post_type_name => $post_type_label): ?>
                <label class="rag-post-type-card">
                    <input type="checkbox" name="post_types[]" value="<?php echo esc_attr($post_type_name); ?>">
                    <div class="rag-card-content">
                        <div class="rag-card-icon">
                            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" stroke="currentColor" stroke-width="2"/>
                            </svg>
                        </div>
                        <span class="rag-card-title"><?php echo esc_html($post_type_label); ?></span>
                        <span class="rag-card-slug"><?php echo esc_html($post_type_name); ?></span>
                    </div>
                </label>
                <?php endforeach; ?>
            </div>

            <div class="rag-form-actions">
                <button type="submit" class="rag-submit-btn" name="rag_submited" value="1">
                    <span><?php esc_html_e('شروع پردازش RAG','woodmartplus'); ?></span>
                    <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2"/>
                    </svg>
                </button>
            </div>

        </form>
    </div>
    
  
    <?php endif; ?>
    

    <?php if( !empty( $post_type_embeded ) || !empty( $errors ) ) :?>

        <?php if( !empty( $post_type_embeded ) ): ?>
            <div class="rag-posttypes-section" style="margin-top:30px">
                <h3 class="rag-section-title"><?php esc_html_e('پست تایپ‌های پردازش شده','woodmartplus'); ?></h3>
                <div class="rag-posttypes-grid">
                    <?php foreach ($post_type_embeded as  $post_type => $count ): 
                        $post_type_label = $available_post_types[$post_type] ?? $post_type;
                    ?>
                    <div class="rag-posttype-item">
                        <div class="rag-posttype-icon">
                            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12L11 14L15 10M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="2"/>
                            </svg>
                        </div>
                        <div class="rag-posttype-info">
                            <span class="rag-posttype-name"><?php echo esc_html($post_type_label); ?></span>
                            <span class="rag-posttype-status"><?php esc_html_e('پردازش شده','woodmartplus'); ?></span>
                            <p class="rag-posttype-status"><?php printf(__('%s تعداد پردازش شده','woodmartplus'),$count); ?></p>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif ?>

        <!-- بخش خطاها -->
        <?php if( !empty( $errors ) ): ?>
            <div class="rag-errors-section" style="margin-top:30px">
                <div class="header__erros_section">
                    <h3 class="rag-section-title"><?php esc_html_e('خطاهای پردازش','woodmartplus') ?></h3>
                    <a href="<?php echo add_query_arg('rrl','1',admin_url('admin.php?page=chatbot_setting')) ?>" class="rag-submit-btn" name="remove_rag_logs" value="1" >
                        <span><?php esc_html_e('حذف خطاها','woodmartplus'); ?></span>
                        <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2"></path>
                        </svg>
                    </a>
                </div>
                
                <div class="rag-errors-list">
                    <?php foreach( $errors as $error ): ?>
                    <div class="rag-error-item">
                        <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="2"/>
                        </svg>
                        <span><?php echo esc_html( $error ); ?></span>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>