<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php esc_html_e('صفحه فاکتور','woodmartplus'); ?></title>
    <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/pre-factor.css">
    <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/all.css">
    <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/global-fonts.css">
    <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/hint.min.css">
    <?php wp_head(); ?>

    <style>
        :root {
            --color-factor: <?php echo wplus_helper::get_setting('color_factor'); ?>;
            --factor-width: <?php echo wplus_helper::get_setting('width_factor') . 'px'; ?>;
        }
        body {
            font-family: <?php echo wplus_helper::get_setting('font_dashboard','iranyekan');  ?> !important;
        }
        .wd-sticky-nav-enabled{
            --wd-sticky-nav-w : 0px;
        }
    </style>
</head>
<body <?php body_class(); ?>>
    <!-- SVG Definitions (hidden) -->
    <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
        <symbol id="icon-invoice" viewBox="0 0 24 24">
            <path d="M14 2H6C4.9 2 4 2.9 4 4V20C4 21.1 4.9 22 6 22H18C19.1 22 20 21.1 20 20V8L14 2ZM18 20H6V4H13V9H18V20ZM8 14H16V16H8V14ZM8 10H16V12H8V10Z"/>
        </symbol>
        <symbol id="icon-calendar" viewBox="0 0 24 24">
            <path d="M20 3H19V1H17V3H7V1H5V3H4C2.9 3 2 3.9 2 5V21C2 22.1 2.9 23 4 23H20C21.1 23 22 22.1 22 21V5C22 3.9 21.1 3 20 3ZM20 21H4V8H20V21Z"/>
        </symbol>
        <symbol id="fullname" viewBox="0 0 24 24">
            <path d="M12 12C14.21 12 16 10.21 16 8C16 5.79 14.21 4 12 4C9.79 4 8 5.79 8 8C8 10.21 9.79 12 12 12ZM12 14C9.33 14 4 15.34 4 18V20H20V18C20 15.34 14.67 14 12 14Z"/>
        </symbol>
        <symbol id="seller" viewBox="0 0 24 24">
            <path d="M12 12C14.21 12 16 10.21 16 8C16 5.79 14.21 4 12 4C9.79 4 8 5.79 8 8C8 10.21 9.79 12 12 12ZM12 14C9.33 14 4 15.34 4 18V20H20V18C20 15.34 14.67 14 12 14Z"/>
        </symbol>
        <symbol id="icon-qrcode" viewBox="0 0 24 24">
            <path d="M3 11H11V3H3V11ZM5 5H9V9H5V5ZM3 21H11V13H3V21ZM5 15H9V19H5V15ZM13 3V11H21V3H13ZM19 9H15V5H19V9ZM13 13H15V15H13V13ZM17 13H19V15H17V13ZM19 17H17V19H19V17ZM15 17H13V21H15V19H17V17H15Z"/>
        </symbol>
        <symbol id="icon-store" viewBox="0 0 24 24">
            <path d="M20 4H4V6H20V4ZM21 14V12L20 7H4L3 12V14H4V20H14V14H18V20H20V14H21ZM12 18H6V14H12V18Z"/>
        </symbol>
        <symbol id="icon-location" viewBox="0 0 24 24">
            <path d="M12 2C8.13 2 5 5.13 5 9C5 14.25 12 22 12 22C12 22 19 14.25 19 9C19 5.13 15.87 2 12 2ZM12 11.5C10.62 11.5 9.5 10.38 9.5 9C9.5 7.62 10.62 6.5 12 6.5C13.38 6.5 14.5 7.62 14.5 9C14.5 10.38 13.38 11.5 12 11.5Z"/>
        </symbol>
        <symbol id="icon-phone" viewBox="0 0 24 24">
            <path d="M6.62 10.79C8.06 13.62 10.38 15.94 13.21 17.38L15.41 15.18C15.69 14.9 16.08 14.82 16.43 14.94C17.55 15.31 18.76 15.51 20 15.51C20.55 15.51 21 15.96 21 16.51V20C21 20.55 20.55 21 20 21C10.61 21 3 13.39 3 4C3 3.45 3.45 3 4 3H7.5C8.05 3 8.5 3.45 8.5 4C8.5 5.24 8.7 6.45 9.07 7.57C9.18 7.92 9.1 8.31 8.82 8.59L6.62 10.79Z"/>
        </symbol>
        <symbol id="icon-email" viewBox="0 0 24 24">
            <path d="M20 4H4C2.9 4 2.01 4.9 2.01 6L2 18C2 19.1 2.9 20 4 20H20C21.1 20 22 19.1 22 18V6C22 4.9 21.1 4 20 4ZM20 8L12 13L4 8V6L12 11L20 6V8Z"/>
        </symbol>
        <symbol id="icon-info" viewBox="0 0 24 24">
            <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM13 17H11V11H13V17ZM13 9H11V7H13V9Z"/>
        </symbol>
        <symbol id="icon-stamp" viewBox="0 0 24 24">
            <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM12 20C7.59 20 4 16.41 4 12C4 7.59 7.59 4 12 4C16.41 4 20 7.59 20 12C20 16.41 16.41 20 12 20ZM16.59 7.58L10 14.17L7.41 11.59L6 13L10 17L18 9L16.59 7.58Z"/>
        </symbol>
        <symbol id="icon-print" viewBox="0 0 24 24">
            <path d="M19 8H5C3.34 8 2 9.34 2 11V17H6V21H18V17H22V11C22 9.34 20.66 8 19 8ZM16 19H8V14H16V19ZM19 12C18.45 12 18 11.55 18 11C18 10.45 18.45 10 19 10C19.55 10 20 10.45 20 11C20 11.55 19.55 12 19 12ZM18 3H6V7H18V3Z"/>
        </symbol>
        <symbol id="icon-save" viewBox="0 0 24 24">
            <path d="M17 3H5C3.89 3 3 3.9 3 5V19C3 20.1 3.89 21 5 21H19C20.1 21 21 20.1 21 19V7L17 3ZM19 19H5V5H16.17L19 7.83V19ZM12 12C10.34 12 9 13.34 9 15C9 16.66 10.34 18 12 18C13.66 18 15 16.66 15 15C15 13.34 13.66 12 12 12ZM7 7H15V9H7V7Z"/>
        </symbol>
        
        <symbol id="country" viewBox="0 0 24 24">
            <path d="M20.5 3L20.34 3.03L15 5.1L9 3L3.36 4.9C3.15 4.97 3 5.15 3 5.38V20.5C3 20.78 3.22 21 3.5 21L3.66 20.97L9 18.9L15 21L20.64 19.1C20.85 19.03 21 18.85 21 18.62V3.5C21 3.22 20.78 3 20.5 3ZM15 19L9 16.89V5L15 7.11V19Z"/>
        </symbol>
        <symbol id="city" viewBox="0 0 24 24">
            <path d="M15 11V5L12 2L9 5V7H3V21H21V11H15ZM7 19H5V17H7V19ZM7 15H5V13H7V15ZM7 11H5V9H7V11ZM13 19H11V17H13V19ZM13 15H11V13H13V15ZM13 11H11V9H13V11ZM13 7H11V5H13V7ZM19 19H17V17H19V19ZM19 15H17V13H19V15Z"/>
        </symbol>
        <symbol id="receiver" viewBox="0 0 24 24">
            <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM12 5C13.66 5 15 6.34 15 8C15 9.66 13.66 11 12 11C10.34 11 9 9.66 9 8C9 6.34 10.34 5 12 5ZM12 19.2C9.5 19.2 7.29 17.92 6 15.98C6.03 13.99 10 12.9 12 12.9C13.99 12.9 17.97 13.99 18 15.98C16.71 17.92 14.5 19.2 12 19.2Z"/>
        </symbol>
        <symbol id="companyadd" viewBox="0 0 24 24">
            <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM12 5C13.66 5 15 6.34 15 8C15 9.66 13.66 11 12 11C10.34 11 9 9.66 9 8C9 6.34 10.34 5 12 5ZM12 19.2C9.5 19.2 7.29 17.92 6 15.98C6.03 13.99 10 12.9 12 12.9C13.99 12.9 17.97 13.99 18 15.98C16.71 17.92 14.5 19.2 12 19.2Z"/>
        </symbol>
        <symbol id="postalcode" viewBox="0 0 24 24">
            <path d="M20 4H4C2.9 4 2.01 4.9 2.01 6L2 18C2 19.1 2.9 20 4 20H20C21.1 20 22 19.1 22 18V6C22 4.9 21.1 4 20 4ZM20 18H4V8L12 13L20 8V18ZM12 11L4 6H20L12 11Z"/>
        </symbol>
        <symbol id="phonenummber" viewBox="0 0 24 24">
            <path d="M17 1.01L7 1C5.9 1 5 1.9 5 3V21C5 22.1 5.9 23 7 23H17C18.1 23 19 22.1 19 21V3C19 1.9 18.1 1.01 17 1.01ZM17 19H7V5H17V19ZM12 18C12.83 18 13.5 17.33 13.5 16.5C13.5 15.67 12.83 15 12 15C11.17 15 10.5 15.67 10.5 16.5C10.5 17.33 11.17 18 12 18Z"/>
        </symbol>
        <symbol id="phonfax" viewBox="0 0 24 24">
            <path d="M17 1.01L7 1C5.9 1 5 1.9 5 3V21C5 22.1 5.9 23 7 23H17C18.1 23 19 22.1 19 21V3C19 1.9 18.1 1.01 17 1.01ZM17 19H7V5H17V19ZM12 18C12.83 18 13.5 17.33 13.5 16.5C13.5 15.67 12.83 15 12 15C11.17 15 10.5 15.67 10.5 16.5C10.5 17.33 11.17 18 12 18Z"/>
        </symbol>
        <symbol id="email" viewBox="0 0 24 24">
            <path d="M20 4H4C2.9 4 2.01 4.9 2.01 6L2 18C2 19.1 2.9 20 4 20H20C21.1 20 22 19.1 22 18V6C22 4.9 21.1 4 20 4ZM20 8L12 13L4 8V6L12 11L20 6V8Z"/>
        </symbol>
        <symbol id="order_date" viewBox="0 0 24 24">
            <path d="M19 3H18V1H16V3H8V1H6V3H5C3.89 3 3.01 3.9 3.01 5L3 19C3 20.1 3.89 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM19 19H5V8H19V19ZM7 10H12V15H7V10Z"/>
        </symbol>
        <symbol id="registid" viewBox="0 0 24 24">
            <path d="M19 3H18V1H16V3H8V1H6V3H5C3.89 3 3.01 3.9 3.01 5L3 19C3 20.1 3.89 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM19 19H5V8H19V19ZM7 10H12V15H7V10Z"/>
        </symbol>
        <symbol id="payment_method" viewBox="0 0 24 24">
            <path d="M20 4H4C2.89 4 2.01 4.89 2.01 6L2 18C2 19.11 2.89 20 4 20H20C21.11 20 22 19.11 22 18V6C22 4.89 21.11 4 20 4ZM20 18H4V12H20V18ZM20 8H4V6H20V8Z"/>
        </symbol>
         <symbol id="registration_id" viewBox="0 0 24 24">
            <path d="M20 4H4C2.89 4 2.01 4.89 2.01 6L2 18C2 19.11 2.89 20 4 20H20C21.11 20 22 19.11 22 18V6C22 4.89 21.11 4 20 4ZM20 18H4V12H20V18ZM20 8H4V6H20V8Z"/>
        </symbol>
        <symbol id="shipping_method" viewBox="0 0 24 24">
            <path d="M20 8H17V4H3C1.9 4 1 4.9 1 6V17H3C3 18.66 4.34 20 6 20C7.66 20 9 18.66 9 17H15C15 18.66 16.34 20 18 20C19.66 20 21 18.66 21 17H23V12L20 8ZM6 18.5C5.17 18.5 4.5 17.83 4.5 17C4.5 16.17 5.17 15.5 6 15.5C6.83 15.5 7.5 16.17 7.5 17C7.5 17.83 6.83 18.5 6 18.5ZM19.5 9.5L21.46 12H17V9.5H19.5ZM18 18.5C17.17 18.5 16.5 17.83 16.5 17C16.5 16.17 17.17 15.5 18 15.5C18.83 15.5 19.5 16.17 19.5 17C19.5 17.83 18.83 18.5 18 18.5Z"/>
        </symbol>
    </svg>
    <?php if( wplus_helper::get_setting('setting_elementor_factor_enable') ): ?>
        <div class="container_prefactor">
            <?php do_action('elementor_builder_factor'); ?>
        </div>
    <?php else: ?>
        <div class="container_prefactor">
        
            <div class="header">
                <div class="logo-container">
                    <?php if ($more_manager_info['logo']): ?>
                        <img src="<?php echo $more_manager_info['logo'] ?>" alt="<?php esc_html_e('لوگوی فروشگاه','woodmartplus'); ?>" class="logo">
                    <?php else: ?>
                        <span><?php echo get_bloginfo('name'); ?></span>
                    <?php endif; ?>
                </div>
                <div class="invoice-info">
                    <p>
                        <svg class="icon"><use xlink:href="#icon-invoice"/></svg>
                        <?php esc_html_e('شماره فاکتور','woodmartplus'); ?>: <?php echo $order->get_id() ?>
                    </p>
                    <p>
                        <svg class="icon"><use xlink:href="#icon-calendar"/></svg>
                        <?php esc_html_e('وضعیت سفارش','woodmartplus'); ?> : <?php echo wc_get_order_status_name($order->get_status()) ?>
                    </p>
                    <p>
                        <svg class="icon"><use xlink:href="#icon-qrcode"/></svg>
                        <img src="<?php echo $order_barcode; ?>" alt="order_barcode" width="80px">
                    </p>
                </div>
            </div>

            <h1 class="title"><?php esc_html_e('صورتحساب کالا','woodmartplus'); ?></h1>


            <div class="info-container">
                <?php if( $manager_info ): ?>
                <div class="seller-info">
                    <h3><?php esc_html_e('اطلاعات فروشنده','woodmartplus'); ?></h3>
                    <?php foreach( $manager_info as $key => $manager ): ?>
                        <?php if( !isset( $manager['output'] ) || empty( $manager['output'] ) ) continue; ?>
                        <p>
                            <svg class="icon"><use xlink:href="#<?php echo $key ?>"/></svg>
                            <strong><?php echo esc_html($manager['label']); ?>:</strong> <?php echo esc_html($manager['output']); ?>
                        </p>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
                
                <?php if( $buyer_info ): ?>
                <div class="customer-info">
                    <h3><?php esc_html_e('اطلاعات مشتری','woodmartplus'); ?></h3>
                    <?php $i=1; foreach( $buyer_info as $key => $buyer ): ?>
                        <?php if( !isset( $buyer['output'] ) || empty( $buyer['output'] ) ) continue; ?>
                        <p>
                            <svg class="icon"><use xlink:href="#<?php echo $key ?>"/></svg>
                            <strong><?php echo esc_html($buyer['label']); ?> :</strong>  <?php echo esc_html($buyer['output']); ?>
                        </p>
                    <?php $i++; endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
            <style>
                @media only screen and (max-width: 600px) {
                    .parent_infor-seller-customer {
                            width: 100%;
                            overflow-x: auto;
                    }
                    table.table-info-seller-customer {
                        width: 250%;
                        border-collapse: collapse;
                    }
                }
            </style>
            <div class="parent_infor-seller-customer"> 
                <table>
                    <thead>
                        <tr>
                            <?php foreach( $items_th as $item ): ?>
                            <th><?php echo esc_html($item); ?></th>
                            <?php endforeach; ?>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $i = 1; foreach ($items as $item) : ?>
                        
                            <tr>
                                <?php if( isset( $item['id'] ) ): ?>
                                    <td><?php echo $item['id']; ?>#</td>
                                <?php endif; ?>
                                <?php if( isset( $item['image'] ) ): ?>
                                    <td>
                                            <img src="<?php echo esc_url($item['image']); ?>" width="100" height="100" alt="">
                                    </td>
                                <?php endif; ?>
                                <?php if( isset( $item['product_name'] ) ): ?>
                                    <td><?php echo $item['product_name'] ?></td>
                                <?php endif; ?>
                                <?php if( isset( $item['product_price'] ) ): ?>
                                    <td><?php echo $item['product_price']; ?></td>
                                <?php endif; ?>
                                <?php if( isset( $item['product_discount'] ) ): ?>
                                    <td><?php echo $item['product_discount'] ?></td>
                                <?php endif; ?>
                                <?php if( isset( $item['product_quantity'] ) ): ?>
                                    <td><?php echo $item['product_quantity']; ?></td>
                                <?php endif; ?>
                                <?php if( isset( $item['product_total'] ) ): ?>
                                    <td><?php echo $item['product_total']; ?></td>
                                <?php endif; ?>
                            </tr>
                        <?php $i++; endforeach; ?>
                        <!-- <tr class="total-row">
                            <td colspan="<?php #echo count( $items_th ) - 1; ?>"><?php #esc_html_e('جمع کل','woodmartplus'); ?></td>
                            <td><?php #echo wc_price($order->get_subtotal()); ?></td>
                        </tr> -->
                        <tr>
                            <td colspan="<?php echo count( $items_th ) - 1; ?>" class="title-invoice-cal"><?php esc_html_e('مبلغ تخفیف','woodmartplus'); ?></td>
                            <td class="output-invoice-cal"><?php echo wc_price($total_discount) . '<span style="font-size: 9px;" >'.__('-مبلغ تخفیف محصولات','woodmartplus').'</span>' ?>
                                <br>
                                <?php foreach ($order->get_coupon_codes() as $coupon_code): ?>
                                    <span><?php esc_html_e('کد تخفیف','woodmartplus'); ?> : <?php echo $coupon_code ?></span>
                                    <span><?php esc_html_e('تخفیف','woodmartplus'); ?> <?php echo wc_price($order->get_discount_total()) ?>-</span>
                                <?php endforeach; ?>
                            </td>
                        </tr>
                        <?php if ($order->get_shipping_method()): ?>
                            <tr>
                                <td colspan="<?php echo count( $items_th ) - 1; ?>" class="title-invoice-cal"><?php esc_html_e('مبلغ حمل و نقل','woodmartplus'); ?></td>
                                <td class="output-invoice-cal">
                                    <?php if ($order->get_shipping_total()): ?>
                                        <span><?php echo  wc_price($order->get_shipping_total()) . '-'; ?></span>
                                    <?php endif; ?>
                                    <span><?php echo $order->get_shipping_method(); ?></span>
                                </td>
                            </tr>
                        <?php endif; ?>
                        <?php if ($order->get_fees()): ?>
                            <?php foreach ($order->get_fees() as $fee): ?>
                                <tr>
                                    <td colspan="<?php echo count( $items_th ) - 1; ?>" class="title-invoice-cal"><?php echo $fee->get_name(); ?></td>
                                    <td class="output-invoice-cal">
                                        <?php echo wc_price($fee->get_amount()); ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        
                        <?php foreach( $order->get_items('tax')  as $tax ): ?>
                            <tr>
                                <td colspan="<?php echo count( $items_th ) - 1; ?>"><?php echo $tax->get_name(); ?></td>
                                <td><?php echo wc_price($tax->get_tax_total()); ?></td>
                            </tr>
                        <?php endforeach; ?>

                        <tr class="total-row">
                            <td colspan="<?php echo count( $items_th ) - 1; ?>"><?php esc_html_e('مبلغ نهایی','woodmartplus'); ?></td>
                            <td ><?php echo $order->get_formatted_order_total() ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <div class="footer">
                <?php if($more_manager_info['factor_note']): ?>
                    <div class="store-info">
                            <p>
                                <svg class="icon"><use xlink:href="#icon-info"/></svg>
                                <strong><?php esc_html_e('شرایط و توضیحات:','woodmartplus'); ?></strong>
                            </p>
                            <?php foreach($more_manager_info['factor_note'] as $info): ?>
                                <p><?php echo $info['title']; ?></p>
                            <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <?php if($more_manager_info['signature_image']): ?>
                    <div class="signature-area">
                            <img src="<?php echo $more_manager_info['signature_image']; ?>" alt="<?php esc_html_e('مهر و امضا فروشگاه','woodmartplus'); ?>" class="signature">
                        <svg><use xlink:href="#icon-stamp"/></svg>
                        <p><?php esc_html_e('محل مهر و امضای فروشگاه','woodmartplus'); ?></p>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    <?php endif; ?>
    <div class="action-buttons">
        <button class="action-button print-button" onclick="window.print()">
            <svg><use xlink:href="#icon-print"/></svg>
            <?php esc_html_e('چاپ فاکتور','woodmartplus'); ?>
        </button>
    </div>
    <?php wp_footer(); ?>
</body>
</html>
